/*
 * Velo Payments APIs
 * ## Terms and Definitions  Throughout this document and the Velo platform the following terms are used:  * **Payor.** An entity (typically a corporation) which wishes to pay funds to one or more payees via a payout. * **Payee.** The recipient of funds paid out by a payor. * **Payment.** A single transfer of funds from a payor to a payee. * **Payout.** A batch of Payments, typically used by a payor to logically group payments (e.g. by business day). Technically there need be no relationship between the payments in a payout - a single payout can contain payments to multiple payees and/or multiple payments to a single payee. * **Sandbox.** An integration environment provided by Velo Payments which offers a similar API experience to the production environment, but all funding and payment events are simulated, along with many other services such as OFAC sanctions list checking.  ## Overview  The Velo Payments API allows a payor to perform a number of operations. The following is a list of the main capabilities in a natural order of execution:  * Authenticate with the Velo platform * Maintain a collection of payees * Query the payor’s current balance of funds within the platform and perform additional funding * Issue payments to payees * Query the platform for a history of those payments  This document describes the main concepts and APIs required to get up and running with the Velo Payments platform. It is not an exhaustive API reference. For that, please see the separate Velo Payments API Reference.  ## API Considerations  The Velo Payments API is REST based and uses the JSON format for requests and responses.  Most calls are secured using OAuth 2 security and require a valid authentication access token for successful operation. See the Authentication section for details.  Where a dynamic value is required in the examples below, the {token} format is used, suggesting that the caller needs to supply the appropriate value of the token in question (without including the { or } characters).  Where curl examples are given, the –d @filename.json approach is used, indicating that the request body should be placed into a file named filename.json in the current directory. Each of the curl examples in this document should be considered a single line on the command-line, regardless of how they appear in print.  ## Authenticating with the Velo Platform  Once Velo backoffice staff have added your organization as a payor within the Velo platform sandbox, they will create you a payor Id, an API key and an API secret and share these with you in a secure manner.  You will need to use these values to authenticate with the Velo platform in order to gain access to the APIs. The steps to take are explained in the following:  create a string comprising the API key (e.g. 44a9537d-d55d-4b47-8082-14061c2bcdd8) and API secret (e.g. c396b26b-137a-44fd-87f5-34631f8fd529) with a colon between them. E.g. 44a9537d-d55d-4b47-8082-14061c2bcdd8:c396b26b-137a-44fd-87f5-34631f8fd529  base64 encode this string. E.g.: NDRhOTUzN2QtZDU1ZC00YjQ3LTgwODItMTQwNjFjMmJjZGQ4OmMzOTZiMjZiLTEzN2EtNDRmZC04N2Y1LTM0NjMxZjhmZDUyOQ==  create an HTTP **Authorization** header with the value set to e.g. Basic NDRhOTUzN2QtZDU1ZC00YjQ3LTgwODItMTQwNjFjMmJjZGQ4OmMzOTZiMjZiLTEzN2EtNDRmZC04N2Y1LTM0NjMxZjhmZDUyOQ==  perform the Velo authentication REST call using the HTTP header created above e.g. via curl:  ```   curl -X POST \\   -H \"Content-Type: application/json\" \\   -H \"Authorization: Basic NDRhOTUzN2QtZDU1ZC00YjQ3LTgwODItMTQwNjFjMmJjZGQ4OmMzOTZiMjZiLTEzN2EtNDRmZC04N2Y1LTM0NjMxZjhmZDUyOQ==\" \\   'https://api.sandbox.velopayments.com/v1/authenticate?grant_type=client_credentials' ```  If successful, this call will result in a **200** HTTP status code and a response body such as:  ```   {     \"access_token\":\"19f6bafd-93fd-4747-b229-00507bbc991f\",     \"token_type\":\"bearer\",     \"expires_in\":1799,     \"scope\":\"...\"   } ``` ## API access following authentication Following successful authentication, the value of the access_token field in the response (indicated in green above) should then be presented with all subsequent API calls to allow the Velo platform to validate that the caller is authenticated.  This is achieved by setting the HTTP Authorization header with the value set to e.g. Bearer 19f6bafd-93fd-4747-b229-00507bbc991f such as the curl example below:  ```   -H \"Authorization: Bearer 19f6bafd-93fd-4747-b229-00507bbc991f \" ```  If you make other Velo API calls which require authorization but the Authorization header is missing or invalid then you will get a **401** HTTP status response. 
 *
 * The version of the OpenAPI document: 2.20.11
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package com.velopayments.oa3.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.time.OffsetDateTime;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import javax.validation.constraints.*;
import javax.validation.Valid;

/**
 * GetPaymentsForPayoutResponseV3Summary
 */
@JsonPropertyOrder({
  GetPaymentsForPayoutResponseV3Summary.JSON_PROPERTY_PAYOUT_STATUS,
  GetPaymentsForPayoutResponseV3Summary.JSON_PROPERTY_SUBMITTED_DATE_TIME,
  GetPaymentsForPayoutResponseV3Summary.JSON_PROPERTY_INSTRUCTED_DATE_TIME,
  GetPaymentsForPayoutResponseV3Summary.JSON_PROPERTY_PAYOUT_MEMO,
  GetPaymentsForPayoutResponseV3Summary.JSON_PROPERTY_TOTAL_PAYMENTS,
  GetPaymentsForPayoutResponseV3Summary.JSON_PROPERTY_CONFIRMED_PAYMENTS,
  GetPaymentsForPayoutResponseV3Summary.JSON_PROPERTY_RELEASED_PAYMENTS,
  GetPaymentsForPayoutResponseV3Summary.JSON_PROPERTY_INCOMPLETE_PAYMENTS,
  GetPaymentsForPayoutResponseV3Summary.JSON_PROPERTY_FAILED_PAYMENTS
})
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2020-01-15T12:46:56.400768-05:00[America/New_York]")
public class GetPaymentsForPayoutResponseV3Summary {
  /**
   * The current status of the payout.
   */
  public enum PayoutStatusEnum {
    ACCEPTED("ACCEPTED"),
    
    REJECTED("REJECTED"),
    
    SUBMITTED("SUBMITTED"),
    
    QUOTED("QUOTED"),
    
    INSTRUCTED("INSTRUCTED"),
    
    COMPLETED("COMPLETED"),
    
    INCOMPLETE("INCOMPLETE"),
    
    CONFIRMED("CONFIRMED"),
    
    WITHDRAWN("WITHDRAWN");

    private String value;

    PayoutStatusEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static PayoutStatusEnum fromValue(String value) {
      for (PayoutStatusEnum b : PayoutStatusEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  public static final String JSON_PROPERTY_PAYOUT_STATUS = "payoutStatus";
  private PayoutStatusEnum payoutStatus;

  public static final String JSON_PROPERTY_SUBMITTED_DATE_TIME = "submittedDateTime";
  private OffsetDateTime submittedDateTime;

  public static final String JSON_PROPERTY_INSTRUCTED_DATE_TIME = "instructedDateTime";
  private OffsetDateTime instructedDateTime;

  public static final String JSON_PROPERTY_PAYOUT_MEMO = "payoutMemo";
  private String payoutMemo;

  public static final String JSON_PROPERTY_TOTAL_PAYMENTS = "totalPayments";
  private Integer totalPayments;

  public static final String JSON_PROPERTY_CONFIRMED_PAYMENTS = "confirmedPayments";
  private Integer confirmedPayments;

  public static final String JSON_PROPERTY_RELEASED_PAYMENTS = "releasedPayments";
  private Integer releasedPayments;

  public static final String JSON_PROPERTY_INCOMPLETE_PAYMENTS = "incompletePayments";
  private Integer incompletePayments;

  public static final String JSON_PROPERTY_FAILED_PAYMENTS = "failedPayments";
  private Integer failedPayments;


  public GetPaymentsForPayoutResponseV3Summary payoutStatus(PayoutStatusEnum payoutStatus) {
    
    this.payoutStatus = payoutStatus;
    return this;
  }

   /**
   * The current status of the payout.
   * @return payoutStatus
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "The current status of the payout.")
  @JsonProperty(JSON_PROPERTY_PAYOUT_STATUS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public PayoutStatusEnum getPayoutStatus() {
    return payoutStatus;
  }


  public void setPayoutStatus(PayoutStatusEnum payoutStatus) {
    this.payoutStatus = payoutStatus;
  }


  public GetPaymentsForPayoutResponseV3Summary submittedDateTime(OffsetDateTime submittedDateTime) {
    
    this.submittedDateTime = submittedDateTime;
    return this;
  }

   /**
   * The date/time at which the payout was submitted.
   * @return submittedDateTime
  **/
  @javax.annotation.Nullable
  @Valid
  @ApiModelProperty(value = "The date/time at which the payout was submitted.")
  @JsonProperty(JSON_PROPERTY_SUBMITTED_DATE_TIME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public OffsetDateTime getSubmittedDateTime() {
    return submittedDateTime;
  }


  public void setSubmittedDateTime(OffsetDateTime submittedDateTime) {
    this.submittedDateTime = submittedDateTime;
  }


  public GetPaymentsForPayoutResponseV3Summary instructedDateTime(OffsetDateTime instructedDateTime) {
    
    this.instructedDateTime = instructedDateTime;
    return this;
  }

   /**
   * The date/time at which the payout was instructed.
   * @return instructedDateTime
  **/
  @javax.annotation.Nullable
  @Valid
  @ApiModelProperty(value = "The date/time at which the payout was instructed.")
  @JsonProperty(JSON_PROPERTY_INSTRUCTED_DATE_TIME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public OffsetDateTime getInstructedDateTime() {
    return instructedDateTime;
  }


  public void setInstructedDateTime(OffsetDateTime instructedDateTime) {
    this.instructedDateTime = instructedDateTime;
  }


  public GetPaymentsForPayoutResponseV3Summary payoutMemo(String payoutMemo) {
    
    this.payoutMemo = payoutMemo;
    return this;
  }

   /**
   * The memo attached to the payout.
   * @return payoutMemo
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "Payment Memo value", value = "The memo attached to the payout.")
  @JsonProperty(JSON_PROPERTY_PAYOUT_MEMO)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getPayoutMemo() {
    return payoutMemo;
  }


  public void setPayoutMemo(String payoutMemo) {
    this.payoutMemo = payoutMemo;
  }


  public GetPaymentsForPayoutResponseV3Summary totalPayments(Integer totalPayments) {
    
    this.totalPayments = totalPayments;
    return this;
  }

   /**
   * The count of payments within the payout.
   * @return totalPayments
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "123", value = "The count of payments within the payout.")
  @JsonProperty(JSON_PROPERTY_TOTAL_PAYMENTS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Integer getTotalPayments() {
    return totalPayments;
  }


  public void setTotalPayments(Integer totalPayments) {
    this.totalPayments = totalPayments;
  }


  public GetPaymentsForPayoutResponseV3Summary confirmedPayments(Integer confirmedPayments) {
    
    this.confirmedPayments = confirmedPayments;
    return this;
  }

   /**
   * The count of payments within the payout which have been confirmed.
   * @return confirmedPayments
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "123", value = "The count of payments within the payout which have been confirmed.")
  @JsonProperty(JSON_PROPERTY_CONFIRMED_PAYMENTS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Integer getConfirmedPayments() {
    return confirmedPayments;
  }


  public void setConfirmedPayments(Integer confirmedPayments) {
    this.confirmedPayments = confirmedPayments;
  }


  public GetPaymentsForPayoutResponseV3Summary releasedPayments(Integer releasedPayments) {
    
    this.releasedPayments = releasedPayments;
    return this;
  }

   /**
   * The count of payments within the payout which have been released.
   * @return releasedPayments
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "123", value = "The count of payments within the payout which have been released.")
  @JsonProperty(JSON_PROPERTY_RELEASED_PAYMENTS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Integer getReleasedPayments() {
    return releasedPayments;
  }


  public void setReleasedPayments(Integer releasedPayments) {
    this.releasedPayments = releasedPayments;
  }


  public GetPaymentsForPayoutResponseV3Summary incompletePayments(Integer incompletePayments) {
    
    this.incompletePayments = incompletePayments;
    return this;
  }

   /**
   * The count of payments within the payout which are incomplete.
   * @return incompletePayments
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "123", value = "The count of payments within the payout which are incomplete.")
  @JsonProperty(JSON_PROPERTY_INCOMPLETE_PAYMENTS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Integer getIncompletePayments() {
    return incompletePayments;
  }


  public void setIncompletePayments(Integer incompletePayments) {
    this.incompletePayments = incompletePayments;
  }


  public GetPaymentsForPayoutResponseV3Summary failedPayments(Integer failedPayments) {
    
    this.failedPayments = failedPayments;
    return this;
  }

   /**
   * The count of payments within the payout which have failed or been returned.
   * @return failedPayments
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "0", value = "The count of payments within the payout which have failed or been returned.")
  @JsonProperty(JSON_PROPERTY_FAILED_PAYMENTS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Integer getFailedPayments() {
    return failedPayments;
  }


  public void setFailedPayments(Integer failedPayments) {
    this.failedPayments = failedPayments;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    GetPaymentsForPayoutResponseV3Summary getPaymentsForPayoutResponseV3Summary = (GetPaymentsForPayoutResponseV3Summary) o;
    return Objects.equals(this.payoutStatus, getPaymentsForPayoutResponseV3Summary.payoutStatus) &&
        Objects.equals(this.submittedDateTime, getPaymentsForPayoutResponseV3Summary.submittedDateTime) &&
        Objects.equals(this.instructedDateTime, getPaymentsForPayoutResponseV3Summary.instructedDateTime) &&
        Objects.equals(this.payoutMemo, getPaymentsForPayoutResponseV3Summary.payoutMemo) &&
        Objects.equals(this.totalPayments, getPaymentsForPayoutResponseV3Summary.totalPayments) &&
        Objects.equals(this.confirmedPayments, getPaymentsForPayoutResponseV3Summary.confirmedPayments) &&
        Objects.equals(this.releasedPayments, getPaymentsForPayoutResponseV3Summary.releasedPayments) &&
        Objects.equals(this.incompletePayments, getPaymentsForPayoutResponseV3Summary.incompletePayments) &&
        Objects.equals(this.failedPayments, getPaymentsForPayoutResponseV3Summary.failedPayments);
  }

  @Override
  public int hashCode() {
    return Objects.hash(payoutStatus, submittedDateTime, instructedDateTime, payoutMemo, totalPayments, confirmedPayments, releasedPayments, incompletePayments, failedPayments);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class GetPaymentsForPayoutResponseV3Summary {\n");
    sb.append("    payoutStatus: ").append(toIndentedString(payoutStatus)).append("\n");
    sb.append("    submittedDateTime: ").append(toIndentedString(submittedDateTime)).append("\n");
    sb.append("    instructedDateTime: ").append(toIndentedString(instructedDateTime)).append("\n");
    sb.append("    payoutMemo: ").append(toIndentedString(payoutMemo)).append("\n");
    sb.append("    totalPayments: ").append(toIndentedString(totalPayments)).append("\n");
    sb.append("    confirmedPayments: ").append(toIndentedString(confirmedPayments)).append("\n");
    sb.append("    releasedPayments: ").append(toIndentedString(releasedPayments)).append("\n");
    sb.append("    incompletePayments: ").append(toIndentedString(incompletePayments)).append("\n");
    sb.append("    failedPayments: ").append(toIndentedString(failedPayments)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

