/*
 * Velo Payments APIs
 * ## Terms and Definitions  Throughout this document and the Velo platform the following terms are used:  * **Payor.** An entity (typically a corporation) which wishes to pay funds to one or more payees via a payout. * **Payee.** The recipient of funds paid out by a payor. * **Payment.** A single transfer of funds from a payor to a payee. * **Payout.** A batch of Payments, typically used by a payor to logically group payments (e.g. by business day). Technically there need be no relationship between the payments in a payout - a single payout can contain payments to multiple payees and/or multiple payments to a single payee. * **Sandbox.** An integration environment provided by Velo Payments which offers a similar API experience to the production environment, but all funding and payment events are simulated, along with many other services such as OFAC sanctions list checking.  ## Overview  The Velo Payments API allows a payor to perform a number of operations. The following is a list of the main capabilities in a natural order of execution:  * Authenticate with the Velo platform * Maintain a collection of payees * Query the payor’s current balance of funds within the platform and perform additional funding * Issue payments to payees * Query the platform for a history of those payments  This document describes the main concepts and APIs required to get up and running with the Velo Payments platform. It is not an exhaustive API reference. For that, please see the separate Velo Payments API Reference.  ## API Considerations  The Velo Payments API is REST based and uses the JSON format for requests and responses.  Most calls are secured using OAuth 2 security and require a valid authentication access token for successful operation. See the Authentication section for details.  Where a dynamic value is required in the examples below, the {token} format is used, suggesting that the caller needs to supply the appropriate value of the token in question (without including the { or } characters).  Where curl examples are given, the –d @filename.json approach is used, indicating that the request body should be placed into a file named filename.json in the current directory. Each of the curl examples in this document should be considered a single line on the command-line, regardless of how they appear in print.  ## Authenticating with the Velo Platform  Once Velo backoffice staff have added your organization as a payor within the Velo platform sandbox, they will create you a payor Id, an API key and an API secret and share these with you in a secure manner.  You will need to use these values to authenticate with the Velo platform in order to gain access to the APIs. The steps to take are explained in the following:  create a string comprising the API key (e.g. 44a9537d-d55d-4b47-8082-14061c2bcdd8) and API secret (e.g. c396b26b-137a-44fd-87f5-34631f8fd529) with a colon between them. E.g. 44a9537d-d55d-4b47-8082-14061c2bcdd8:c396b26b-137a-44fd-87f5-34631f8fd529  base64 encode this string. E.g.: NDRhOTUzN2QtZDU1ZC00YjQ3LTgwODItMTQwNjFjMmJjZGQ4OmMzOTZiMjZiLTEzN2EtNDRmZC04N2Y1LTM0NjMxZjhmZDUyOQ==  create an HTTP **Authorization** header with the value set to e.g. Basic NDRhOTUzN2QtZDU1ZC00YjQ3LTgwODItMTQwNjFjMmJjZGQ4OmMzOTZiMjZiLTEzN2EtNDRmZC04N2Y1LTM0NjMxZjhmZDUyOQ==  perform the Velo authentication REST call using the HTTP header created above e.g. via curl:  ```   curl -X POST \\   -H \"Content-Type: application/json\" \\   -H \"Authorization: Basic NDRhOTUzN2QtZDU1ZC00YjQ3LTgwODItMTQwNjFjMmJjZGQ4OmMzOTZiMjZiLTEzN2EtNDRmZC04N2Y1LTM0NjMxZjhmZDUyOQ==\" \\   'https://api.sandbox.velopayments.com/v1/authenticate?grant_type=client_credentials' ```  If successful, this call will result in a **200** HTTP status code and a response body such as:  ```   {     \"access_token\":\"19f6bafd-93fd-4747-b229-00507bbc991f\",     \"token_type\":\"bearer\",     \"expires_in\":1799,     \"scope\":\"...\"   } ``` ## API access following authentication Following successful authentication, the value of the access_token field in the response (indicated in green above) should then be presented with all subsequent API calls to allow the Velo platform to validate that the caller is authenticated.  This is achieved by setting the HTTP Authorization header with the value set to e.g. Bearer 19f6bafd-93fd-4747-b229-00507bbc991f such as the curl example below:  ```   -H \"Authorization: Bearer 19f6bafd-93fd-4747-b229-00507bbc991f \" ```  If you make other Velo API calls which require authorization but the Authorization header is missing or invalid then you will get a **401** HTTP status response. 
 *
 * The version of the OpenAPI document: 2.20.11
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package com.velopayments.oa3.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import com.velopayments.oa3.model.OnboardedStatus2;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.UUID;
import com.fasterxml.jackson.annotation.JsonIgnore;
import org.openapitools.jackson.nullable.JsonNullable;
import java.util.NoSuchElementException;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import javax.validation.constraints.*;
import javax.validation.Valid;

/**
 * PayeeDelta2
 */
@JsonPropertyOrder({
  PayeeDelta2.JSON_PROPERTY_REMOTE_ID,
  PayeeDelta2.JSON_PROPERTY_PAYEE_ID,
  PayeeDelta2.JSON_PROPERTY_DISPLAY_NAME,
  PayeeDelta2.JSON_PROPERTY_DBA_NAME,
  PayeeDelta2.JSON_PROPERTY_EMAIL,
  PayeeDelta2.JSON_PROPERTY_PAYEE_COUNTRY,
  PayeeDelta2.JSON_PROPERTY_ONBOARDED_STATUS
})
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2020-01-15T12:46:56.400768-05:00[America/New_York]")
public class PayeeDelta2 {
  public static final String JSON_PROPERTY_REMOTE_ID = "remoteId";
  private String remoteId;

  public static final String JSON_PROPERTY_PAYEE_ID = "payeeId";
  private UUID payeeId;

  public static final String JSON_PROPERTY_DISPLAY_NAME = "displayName";
  private String displayName;

  public static final String JSON_PROPERTY_DBA_NAME = "dbaName";
  private String dbaName;

  public static final String JSON_PROPERTY_EMAIL = "email";
  private JsonNullable<String> email = JsonNullable.<String>undefined();

  public static final String JSON_PROPERTY_PAYEE_COUNTRY = "payeeCountry";
  private String payeeCountry;

  public static final String JSON_PROPERTY_ONBOARDED_STATUS = "onboardedStatus";
  private OnboardedStatus2 onboardedStatus;


  public PayeeDelta2 remoteId(String remoteId) {
    
    this.remoteId = remoteId;
    return this;
  }

   /**
   * Get remoteId
   * @return remoteId
  **/
  @NotNull
 @Size(min=1,max=100)  @ApiModelProperty(example = "payee_1", required = true, value = "")
  @JsonProperty(JSON_PROPERTY_REMOTE_ID)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getRemoteId() {
    return remoteId;
  }


  public void setRemoteId(String remoteId) {
    this.remoteId = remoteId;
  }


   /**
   * Get payeeId
   * @return payeeId
  **/
  @NotNull
  @Valid
  @ApiModelProperty(required = true, value = "")
  @JsonProperty(JSON_PROPERTY_PAYEE_ID)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public UUID getPayeeId() {
    return payeeId;
  }




  public PayeeDelta2 displayName(String displayName) {
    
    this.displayName = displayName;
    return this;
  }

   /**
   * Get displayName
   * @return displayName
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "Payee1", value = "")
  @JsonProperty(JSON_PROPERTY_DISPLAY_NAME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getDisplayName() {
    return displayName;
  }


  public void setDisplayName(String displayName) {
    this.displayName = displayName;
  }


  public PayeeDelta2 dbaName(String dbaName) {
    
    this.dbaName = dbaName;
    return this;
  }

   /**
   * Get dbaName
   * @return dbaName
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "Payee DBA Name", value = "")
  @JsonProperty(JSON_PROPERTY_DBA_NAME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getDbaName() {
    return dbaName;
  }


  public void setDbaName(String dbaName) {
    this.dbaName = dbaName;
  }


  public PayeeDelta2 email(String email) {
    this.email = JsonNullable.<String>of(email);
    
    return this;
  }

   /**
   * Get email
   * @return email
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "payee1@example.com", value = "")
  @JsonIgnore

  public String getEmail() {
        return email.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_EMAIL)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<String> getEmail_JsonNullable() {
    return email;
  }
  
  @JsonProperty(JSON_PROPERTY_EMAIL)
  public void setEmail_JsonNullable(JsonNullable<String> email) {
    this.email = email;
  }

  public void setEmail(String email) {
    this.email = JsonNullable.<String>of(email);
  }


  public PayeeDelta2 payeeCountry(String payeeCountry) {
    
    this.payeeCountry = payeeCountry;
    return this;
  }

   /**
   * Get payeeCountry
   * @return payeeCountry
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "US", value = "")
  @JsonProperty(JSON_PROPERTY_PAYEE_COUNTRY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getPayeeCountry() {
    return payeeCountry;
  }


  public void setPayeeCountry(String payeeCountry) {
    this.payeeCountry = payeeCountry;
  }


  public PayeeDelta2 onboardedStatus(OnboardedStatus2 onboardedStatus) {
    
    this.onboardedStatus = onboardedStatus;
    return this;
  }

   /**
   * Get onboardedStatus
   * @return onboardedStatus
  **/
  @javax.annotation.Nullable
  @Valid
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_ONBOARDED_STATUS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public OnboardedStatus2 getOnboardedStatus() {
    return onboardedStatus;
  }


  public void setOnboardedStatus(OnboardedStatus2 onboardedStatus) {
    this.onboardedStatus = onboardedStatus;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    PayeeDelta2 payeeDelta2 = (PayeeDelta2) o;
    return Objects.equals(this.remoteId, payeeDelta2.remoteId) &&
        Objects.equals(this.payeeId, payeeDelta2.payeeId) &&
        Objects.equals(this.displayName, payeeDelta2.displayName) &&
        Objects.equals(this.dbaName, payeeDelta2.dbaName) &&
        Objects.equals(this.email, payeeDelta2.email) &&
        Objects.equals(this.payeeCountry, payeeDelta2.payeeCountry) &&
        Objects.equals(this.onboardedStatus, payeeDelta2.onboardedStatus);
  }

  @Override
  public int hashCode() {
    return Objects.hash(remoteId, payeeId, displayName, dbaName, email, payeeCountry, onboardedStatus);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class PayeeDelta2 {\n");
    sb.append("    remoteId: ").append(toIndentedString(remoteId)).append("\n");
    sb.append("    payeeId: ").append(toIndentedString(payeeId)).append("\n");
    sb.append("    displayName: ").append(toIndentedString(displayName)).append("\n");
    sb.append("    dbaName: ").append(toIndentedString(dbaName)).append("\n");
    sb.append("    email: ").append(toIndentedString(email)).append("\n");
    sb.append("    payeeCountry: ").append(toIndentedString(payeeCountry)).append("\n");
    sb.append("    onboardedStatus: ").append(toIndentedString(onboardedStatus)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

