/*
 * Velo Payments APIs
 * ## Terms and Definitions  Throughout this document and the Velo platform the following terms are used:  * **Payor.** An entity (typically a corporation) which wishes to pay funds to one or more payees via a payout. * **Payee.** The recipient of funds paid out by a payor. * **Payment.** A single transfer of funds from a payor to a payee. * **Payout.** A batch of Payments, typically used by a payor to logically group payments (e.g. by business day). Technically there need be no relationship between the payments in a payout - a single payout can contain payments to multiple payees and/or multiple payments to a single payee. * **Sandbox.** An integration environment provided by Velo Payments which offers a similar API experience to the production environment, but all funding and payment events are simulated, along with many other services such as OFAC sanctions list checking.  ## Overview  The Velo Payments API allows a payor to perform a number of operations. The following is a list of the main capabilities in a natural order of execution:  * Authenticate with the Velo platform * Maintain a collection of payees * Query the payor’s current balance of funds within the platform and perform additional funding * Issue payments to payees * Query the platform for a history of those payments  This document describes the main concepts and APIs required to get up and running with the Velo Payments platform. It is not an exhaustive API reference. For that, please see the separate Velo Payments API Reference.  ## API Considerations  The Velo Payments API is REST based and uses the JSON format for requests and responses.  Most calls are secured using OAuth 2 security and require a valid authentication access token for successful operation. See the Authentication section for details.  Where a dynamic value is required in the examples below, the {token} format is used, suggesting that the caller needs to supply the appropriate value of the token in question (without including the { or } characters).  Where curl examples are given, the –d @filename.json approach is used, indicating that the request body should be placed into a file named filename.json in the current directory. Each of the curl examples in this document should be considered a single line on the command-line, regardless of how they appear in print.  ## Authenticating with the Velo Platform  Once Velo backoffice staff have added your organization as a payor within the Velo platform sandbox, they will create you a payor Id, an API key and an API secret and share these with you in a secure manner.  You will need to use these values to authenticate with the Velo platform in order to gain access to the APIs. The steps to take are explained in the following:  create a string comprising the API key (e.g. 44a9537d-d55d-4b47-8082-14061c2bcdd8) and API secret (e.g. c396b26b-137a-44fd-87f5-34631f8fd529) with a colon between them. E.g. 44a9537d-d55d-4b47-8082-14061c2bcdd8:c396b26b-137a-44fd-87f5-34631f8fd529  base64 encode this string. E.g.: NDRhOTUzN2QtZDU1ZC00YjQ3LTgwODItMTQwNjFjMmJjZGQ4OmMzOTZiMjZiLTEzN2EtNDRmZC04N2Y1LTM0NjMxZjhmZDUyOQ==  create an HTTP **Authorization** header with the value set to e.g. Basic NDRhOTUzN2QtZDU1ZC00YjQ3LTgwODItMTQwNjFjMmJjZGQ4OmMzOTZiMjZiLTEzN2EtNDRmZC04N2Y1LTM0NjMxZjhmZDUyOQ==  perform the Velo authentication REST call using the HTTP header created above e.g. via curl:  ```   curl -X POST \\   -H \"Content-Type: application/json\" \\   -H \"Authorization: Basic NDRhOTUzN2QtZDU1ZC00YjQ3LTgwODItMTQwNjFjMmJjZGQ4OmMzOTZiMjZiLTEzN2EtNDRmZC04N2Y1LTM0NjMxZjhmZDUyOQ==\" \\   'https://api.sandbox.velopayments.com/v1/authenticate?grant_type=client_credentials' ```  If successful, this call will result in a **200** HTTP status code and a response body such as:  ```   {     \"access_token\":\"19f6bafd-93fd-4747-b229-00507bbc991f\",     \"token_type\":\"bearer\",     \"expires_in\":1799,     \"scope\":\"...\"   } ``` ## API access following authentication Following successful authentication, the value of the access_token field in the response (indicated in green above) should then be presented with all subsequent API calls to allow the Velo platform to validate that the caller is authenticated.  This is achieved by setting the HTTP Authorization header with the value set to e.g. Bearer 19f6bafd-93fd-4747-b229-00507bbc991f such as the curl example below:  ```   -H \"Authorization: Bearer 19f6bafd-93fd-4747-b229-00507bbc991f \" ```  If you make other Velo API calls which require authorization but the Authorization header is missing or invalid then you will get a **401** HTTP status response. 
 *
 * The version of the OpenAPI document: 2.20.11
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package com.velopayments.oa3.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import javax.validation.constraints.*;
import javax.validation.Valid;

/**
 * RejectedPayment
 */
@JsonPropertyOrder({
  RejectedPayment.JSON_PROPERTY_REMOTE_ID,
  RejectedPayment.JSON_PROPERTY_CURRENCY_TYPE,
  RejectedPayment.JSON_PROPERTY_AMOUNT,
  RejectedPayment.JSON_PROPERTY_SOURCE_ACCOUNT_NAME,
  RejectedPayment.JSON_PROPERTY_PAYOR_PAYMENT_ID,
  RejectedPayment.JSON_PROPERTY_REASON,
  RejectedPayment.JSON_PROPERTY_REASON_CODE,
  RejectedPayment.JSON_PROPERTY_LINE_NUMBER,
  RejectedPayment.JSON_PROPERTY_MESSAGE
})
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2020-01-15T12:46:56.400768-05:00[America/New_York]")
public class RejectedPayment {
  public static final String JSON_PROPERTY_REMOTE_ID = "remoteId";
  private String remoteId;

  public static final String JSON_PROPERTY_CURRENCY_TYPE = "currencyType";
  private String currencyType;

  public static final String JSON_PROPERTY_AMOUNT = "amount";
  private Integer amount;

  public static final String JSON_PROPERTY_SOURCE_ACCOUNT_NAME = "sourceAccountName";
  private String sourceAccountName;

  public static final String JSON_PROPERTY_PAYOR_PAYMENT_ID = "payorPaymentId";
  private String payorPaymentId;

  public static final String JSON_PROPERTY_REASON = "reason";
  private String reason;

  public static final String JSON_PROPERTY_REASON_CODE = "reasonCode";
  private String reasonCode;

  public static final String JSON_PROPERTY_LINE_NUMBER = "lineNumber";
  private Integer lineNumber;

  public static final String JSON_PROPERTY_MESSAGE = "message";
  private String message;


  public RejectedPayment remoteId(String remoteId) {
    
    this.remoteId = remoteId;
    return this;
  }

   /**
   * Get remoteId
   * @return remoteId
  **/
  @NotNull
  @ApiModelProperty(example = "remoteIdVal123", required = true, value = "")
  @JsonProperty(JSON_PROPERTY_REMOTE_ID)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getRemoteId() {
    return remoteId;
  }


  public void setRemoteId(String remoteId) {
    this.remoteId = remoteId;
  }


  public RejectedPayment currencyType(String currencyType) {
    
    this.currencyType = currencyType;
    return this;
  }

   /**
   * Get currencyType
   * @return currencyType
  **/
  @NotNull
 @Size(min=3,max=3)  @ApiModelProperty(example = "USD", required = true, value = "")
  @JsonProperty(JSON_PROPERTY_CURRENCY_TYPE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getCurrencyType() {
    return currencyType;
  }


  public void setCurrencyType(String currencyType) {
    this.currencyType = currencyType;
  }


  public RejectedPayment amount(Integer amount) {
    
    this.amount = amount;
    return this;
  }

   /**
   * Get amount
   * @return amount
  **/
  @NotNull
  @ApiModelProperty(example = "1234", required = true, value = "")
  @JsonProperty(JSON_PROPERTY_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public Integer getAmount() {
    return amount;
  }


  public void setAmount(Integer amount) {
    this.amount = amount;
  }


  public RejectedPayment sourceAccountName(String sourceAccountName) {
    
    this.sourceAccountName = sourceAccountName;
    return this;
  }

   /**
   * Get sourceAccountName
   * @return sourceAccountName
  **/
  @NotNull
  @ApiModelProperty(example = "Chase", required = true, value = "")
  @JsonProperty(JSON_PROPERTY_SOURCE_ACCOUNT_NAME)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getSourceAccountName() {
    return sourceAccountName;
  }


  public void setSourceAccountName(String sourceAccountName) {
    this.sourceAccountName = sourceAccountName;
  }


  public RejectedPayment payorPaymentId(String payorPaymentId) {
    
    this.payorPaymentId = payorPaymentId;
    return this;
  }

   /**
   * Get payorPaymentId
   * @return payorPaymentId
  **/
  @NotNull
  @ApiModelProperty(example = "paymenIdVal123123", required = true, value = "")
  @JsonProperty(JSON_PROPERTY_PAYOR_PAYMENT_ID)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getPayorPaymentId() {
    return payorPaymentId;
  }


  public void setPayorPaymentId(String payorPaymentId) {
    this.payorPaymentId = payorPaymentId;
  }


  public RejectedPayment reason(String reason) {
    
    this.reason = reason;
    return this;
  }

   /**
   * Get reason
   * @return reason
  **/
  @NotNull
  @ApiModelProperty(example = "The payee has not been onboarded", required = true, value = "")
  @JsonProperty(JSON_PROPERTY_REASON)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getReason() {
    return reason;
  }


  public void setReason(String reason) {
    this.reason = reason;
  }


  public RejectedPayment reasonCode(String reasonCode) {
    
    this.reasonCode = reasonCode;
    return this;
  }

   /**
   * Get reasonCode
   * @return reasonCode
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "PAYMENT_VALUE_TOO_HIGH", value = "")
  @JsonProperty(JSON_PROPERTY_REASON_CODE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getReasonCode() {
    return reasonCode;
  }


  public void setReasonCode(String reasonCode) {
    this.reasonCode = reasonCode;
  }


  public RejectedPayment lineNumber(Integer lineNumber) {
    
    this.lineNumber = lineNumber;
    return this;
  }

   /**
   * Get lineNumber
   * @return lineNumber
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "10", value = "")
  @JsonProperty(JSON_PROPERTY_LINE_NUMBER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Integer getLineNumber() {
    return lineNumber;
  }


  public void setLineNumber(Integer lineNumber) {
    this.lineNumber = lineNumber;
  }


  public RejectedPayment message(String message) {
    
    this.message = message;
    return this;
  }

   /**
   * Get message
   * @return message
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "Payment cannot be processed because of the Payee's OFAC or Compliance Status", value = "")
  @JsonProperty(JSON_PROPERTY_MESSAGE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getMessage() {
    return message;
  }


  public void setMessage(String message) {
    this.message = message;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    RejectedPayment rejectedPayment = (RejectedPayment) o;
    return Objects.equals(this.remoteId, rejectedPayment.remoteId) &&
        Objects.equals(this.currencyType, rejectedPayment.currencyType) &&
        Objects.equals(this.amount, rejectedPayment.amount) &&
        Objects.equals(this.sourceAccountName, rejectedPayment.sourceAccountName) &&
        Objects.equals(this.payorPaymentId, rejectedPayment.payorPaymentId) &&
        Objects.equals(this.reason, rejectedPayment.reason) &&
        Objects.equals(this.reasonCode, rejectedPayment.reasonCode) &&
        Objects.equals(this.lineNumber, rejectedPayment.lineNumber) &&
        Objects.equals(this.message, rejectedPayment.message);
  }

  @Override
  public int hashCode() {
    return Objects.hash(remoteId, currencyType, amount, sourceAccountName, payorPaymentId, reason, reasonCode, lineNumber, message);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class RejectedPayment {\n");
    sb.append("    remoteId: ").append(toIndentedString(remoteId)).append("\n");
    sb.append("    currencyType: ").append(toIndentedString(currencyType)).append("\n");
    sb.append("    amount: ").append(toIndentedString(amount)).append("\n");
    sb.append("    sourceAccountName: ").append(toIndentedString(sourceAccountName)).append("\n");
    sb.append("    payorPaymentId: ").append(toIndentedString(payorPaymentId)).append("\n");
    sb.append("    reason: ").append(toIndentedString(reason)).append("\n");
    sb.append("    reasonCode: ").append(toIndentedString(reasonCode)).append("\n");
    sb.append("    lineNumber: ").append(toIndentedString(lineNumber)).append("\n");
    sb.append("    message: ").append(toIndentedString(message)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

