/*
 * Velo Payments APIs
 * ## Terms and Definitions  Throughout this document and the Velo platform the following terms are used:  * **Payor.** An entity (typically a corporation) which wishes to pay funds to one or more payees via a payout. * **Payee.** The recipient of funds paid out by a payor. * **Payment.** A single transfer of funds from a payor to a payee. * **Payout.** A batch of Payments, typically used by a payor to logically group payments (e.g. by business day). Technically there need be no relationship between the payments in a payout - a single payout can contain payments to multiple payees and/or multiple payments to a single payee. * **Sandbox.** An integration environment provided by Velo Payments which offers a similar API experience to the production environment, but all funding and payment events are simulated, along with many other services such as OFAC sanctions list checking.  ## Overview  The Velo Payments API allows a payor to perform a number of operations. The following is a list of the main capabilities in a natural order of execution:  * Authenticate with the Velo platform * Maintain a collection of payees * Query the payor’s current balance of funds within the platform and perform additional funding * Issue payments to payees * Query the platform for a history of those payments  This document describes the main concepts and APIs required to get up and running with the Velo Payments platform. It is not an exhaustive API reference. For that, please see the separate Velo Payments API Reference.  ## API Considerations  The Velo Payments API is REST based and uses the JSON format for requests and responses.  Most calls are secured using OAuth 2 security and require a valid authentication access token for successful operation. See the Authentication section for details.  Where a dynamic value is required in the examples below, the {token} format is used, suggesting that the caller needs to supply the appropriate value of the token in question (without including the { or } characters).  Where curl examples are given, the –d @filename.json approach is used, indicating that the request body should be placed into a file named filename.json in the current directory. Each of the curl examples in this document should be considered a single line on the command-line, regardless of how they appear in print.  ## Authenticating with the Velo Platform  Once Velo backoffice staff have added your organization as a payor within the Velo platform sandbox, they will create you a payor Id, an API key and an API secret and share these with you in a secure manner.  You will need to use these values to authenticate with the Velo platform in order to gain access to the APIs. The steps to take are explained in the following:  create a string comprising the API key (e.g. 44a9537d-d55d-4b47-8082-14061c2bcdd8) and API secret (e.g. c396b26b-137a-44fd-87f5-34631f8fd529) with a colon between them. E.g. 44a9537d-d55d-4b47-8082-14061c2bcdd8:c396b26b-137a-44fd-87f5-34631f8fd529  base64 encode this string. E.g.: NDRhOTUzN2QtZDU1ZC00YjQ3LTgwODItMTQwNjFjMmJjZGQ4OmMzOTZiMjZiLTEzN2EtNDRmZC04N2Y1LTM0NjMxZjhmZDUyOQ==  create an HTTP **Authorization** header with the value set to e.g. Basic NDRhOTUzN2QtZDU1ZC00YjQ3LTgwODItMTQwNjFjMmJjZGQ4OmMzOTZiMjZiLTEzN2EtNDRmZC04N2Y1LTM0NjMxZjhmZDUyOQ==  perform the Velo authentication REST call using the HTTP header created above e.g. via curl:  ```   curl -X POST \\   -H \"Content-Type: application/json\" \\   -H \"Authorization: Basic NDRhOTUzN2QtZDU1ZC00YjQ3LTgwODItMTQwNjFjMmJjZGQ4OmMzOTZiMjZiLTEzN2EtNDRmZC04N2Y1LTM0NjMxZjhmZDUyOQ==\" \\   'https://api.sandbox.velopayments.com/v1/authenticate?grant_type=client_credentials' ```  If successful, this call will result in a **200** HTTP status code and a response body such as:  ```   {     \"access_token\":\"19f6bafd-93fd-4747-b229-00507bbc991f\",     \"token_type\":\"bearer\",     \"expires_in\":1799,     \"scope\":\"...\"   } ``` ## API access following authentication Following successful authentication, the value of the access_token field in the response (indicated in green above) should then be presented with all subsequent API calls to allow the Velo platform to validate that the caller is authenticated.  This is achieved by setting the HTTP Authorization header with the value set to e.g. Bearer 19f6bafd-93fd-4747-b229-00507bbc991f such as the curl example below:  ```   -H \"Authorization: Bearer 19f6bafd-93fd-4747-b229-00507bbc991f \" ```  If you make other Velo API calls which require authorization but the Authorization header is missing or invalid then you will get a **401** HTTP status response. 
 *
 * The version of the OpenAPI document: 2.20.11
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package com.velopayments.oa3.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import com.velopayments.oa3.model.MFAType;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import com.fasterxml.jackson.annotation.JsonIgnore;
import org.openapitools.jackson.nullable.JsonNullable;
import java.util.NoSuchElementException;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import javax.validation.constraints.*;
import javax.validation.Valid;

/**
 * &lt;p&gt;All properties are optional&lt;/p&gt; &lt;p&gt;Only provided properties will be updated&lt;/p&gt; &lt;p&gt;Use null to null out a property that is allowed to be nullable&lt;/p&gt; 
 */
@ApiModel(description = "<p>All properties are optional</p> <p>Only provided properties will be updated</p> <p>Use null to null out a property that is allowed to be nullable</p> ")
@JsonPropertyOrder({
  UserDetailsUpdateRequest.JSON_PROPERTY_PRIMARY_CONTACT_NUMBER,
  UserDetailsUpdateRequest.JSON_PROPERTY_SECONDARY_CONTACT_NUMBER,
  UserDetailsUpdateRequest.JSON_PROPERTY_FIRST_NAME,
  UserDetailsUpdateRequest.JSON_PROPERTY_LAST_NAME,
  UserDetailsUpdateRequest.JSON_PROPERTY_EMAIL,
  UserDetailsUpdateRequest.JSON_PROPERTY_SMS_NUMBER,
  UserDetailsUpdateRequest.JSON_PROPERTY_MFA_TYPE,
  UserDetailsUpdateRequest.JSON_PROPERTY_VERIFICATION_CODE
})
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2020-01-15T12:46:56.400768-05:00[America/New_York]")
public class UserDetailsUpdateRequest {
  public static final String JSON_PROPERTY_PRIMARY_CONTACT_NUMBER = "primaryContactNumber";
  private JsonNullable<String> primaryContactNumber = JsonNullable.<String>undefined();

  public static final String JSON_PROPERTY_SECONDARY_CONTACT_NUMBER = "secondaryContactNumber";
  private JsonNullable<String> secondaryContactNumber = JsonNullable.<String>undefined();

  public static final String JSON_PROPERTY_FIRST_NAME = "firstName";
  private JsonNullable<String> firstName = JsonNullable.<String>undefined();

  public static final String JSON_PROPERTY_LAST_NAME = "lastName";
  private JsonNullable<String> lastName = JsonNullable.<String>undefined();

  public static final String JSON_PROPERTY_EMAIL = "email";
  private JsonNullable<String> email = JsonNullable.<String>undefined();

  public static final String JSON_PROPERTY_SMS_NUMBER = "smsNumber";
  private JsonNullable<String> smsNumber = JsonNullable.<String>undefined();

  public static final String JSON_PROPERTY_MFA_TYPE = "mfaType";
  private JsonNullable<MFAType> mfaType = JsonNullable.<MFAType>undefined();

  public static final String JSON_PROPERTY_VERIFICATION_CODE = "verificationCode";
  private JsonNullable<String> verificationCode = JsonNullable.<String>undefined();


  public UserDetailsUpdateRequest primaryContactNumber(String primaryContactNumber) {
    this.primaryContactNumber = JsonNullable.<String>of(primaryContactNumber);
    
    return this;
  }

   /**
   * The main contact number for the user 
   * @return primaryContactNumber
  **/
  @javax.annotation.Nullable
 @Pattern(regexp="^\\+?[1-9]\\d{1,14}$")  @ApiModelProperty(example = "11235555555", value = "The main contact number for the user ")
  @JsonIgnore

  public String getPrimaryContactNumber() {
        return primaryContactNumber.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_PRIMARY_CONTACT_NUMBER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<String> getPrimaryContactNumber_JsonNullable() {
    return primaryContactNumber;
  }
  
  @JsonProperty(JSON_PROPERTY_PRIMARY_CONTACT_NUMBER)
  public void setPrimaryContactNumber_JsonNullable(JsonNullable<String> primaryContactNumber) {
    this.primaryContactNumber = primaryContactNumber;
  }

  public void setPrimaryContactNumber(String primaryContactNumber) {
    this.primaryContactNumber = JsonNullable.<String>of(primaryContactNumber);
  }


  public UserDetailsUpdateRequest secondaryContactNumber(String secondaryContactNumber) {
    this.secondaryContactNumber = JsonNullable.<String>of(secondaryContactNumber);
    
    return this;
  }

   /**
   * The secondary contact number for the user 
   * @return secondaryContactNumber
  **/
  @javax.annotation.Nullable
 @Pattern(regexp="^\\+?[1-9]\\d{1,14}$")  @ApiModelProperty(example = "11235555550", value = "The secondary contact number for the user ")
  @JsonIgnore

  public String getSecondaryContactNumber() {
        return secondaryContactNumber.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_SECONDARY_CONTACT_NUMBER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<String> getSecondaryContactNumber_JsonNullable() {
    return secondaryContactNumber;
  }
  
  @JsonProperty(JSON_PROPERTY_SECONDARY_CONTACT_NUMBER)
  public void setSecondaryContactNumber_JsonNullable(JsonNullable<String> secondaryContactNumber) {
    this.secondaryContactNumber = secondaryContactNumber;
  }

  public void setSecondaryContactNumber(String secondaryContactNumber) {
    this.secondaryContactNumber = JsonNullable.<String>of(secondaryContactNumber);
  }


  public UserDetailsUpdateRequest firstName(String firstName) {
    this.firstName = JsonNullable.<String>of(firstName);
    
    return this;
  }

   /**
   * Get firstName
   * @return firstName
  **/
  @javax.annotation.Nullable
 @Size(min=1,max=128)  @ApiModelProperty(example = "John", value = "")
  @JsonIgnore

  public String getFirstName() {
        return firstName.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_FIRST_NAME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<String> getFirstName_JsonNullable() {
    return firstName;
  }
  
  @JsonProperty(JSON_PROPERTY_FIRST_NAME)
  public void setFirstName_JsonNullable(JsonNullable<String> firstName) {
    this.firstName = firstName;
  }

  public void setFirstName(String firstName) {
    this.firstName = JsonNullable.<String>of(firstName);
  }


  public UserDetailsUpdateRequest lastName(String lastName) {
    this.lastName = JsonNullable.<String>of(lastName);
    
    return this;
  }

   /**
   * Get lastName
   * @return lastName
  **/
  @javax.annotation.Nullable
 @Size(min=1,max=128)  @ApiModelProperty(example = "Doe", value = "")
  @JsonIgnore

  public String getLastName() {
        return lastName.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_LAST_NAME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<String> getLastName_JsonNullable() {
    return lastName;
  }
  
  @JsonProperty(JSON_PROPERTY_LAST_NAME)
  public void setLastName_JsonNullable(JsonNullable<String> lastName) {
    this.lastName = lastName;
  }

  public void setLastName(String lastName) {
    this.lastName = JsonNullable.<String>of(lastName);
  }


  public UserDetailsUpdateRequest email(String email) {
    this.email = JsonNullable.<String>of(email);
    
    return this;
  }

   /**
   * the email address of the user
   * @return email
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "foo@example.com", value = "the email address of the user")
  @JsonIgnore

  public String getEmail() {
        return email.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_EMAIL)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<String> getEmail_JsonNullable() {
    return email;
  }
  
  @JsonProperty(JSON_PROPERTY_EMAIL)
  public void setEmail_JsonNullable(JsonNullable<String> email) {
    this.email = email;
  }

  public void setEmail(String email) {
    this.email = JsonNullable.<String>of(email);
  }


  public UserDetailsUpdateRequest smsNumber(String smsNumber) {
    this.smsNumber = JsonNullable.<String>of(smsNumber);
    
    return this;
  }

   /**
   * The phone number of a device that the user can receive sms messages on 
   * @return smsNumber
  **/
  @javax.annotation.Nullable
 @Pattern(regexp="^\\+?[1-9]\\d{1,14}$")  @ApiModelProperty(example = "11235555555", value = "The phone number of a device that the user can receive sms messages on ")
  @JsonIgnore

  public String getSmsNumber() {
        return smsNumber.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_SMS_NUMBER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<String> getSmsNumber_JsonNullable() {
    return smsNumber;
  }
  
  @JsonProperty(JSON_PROPERTY_SMS_NUMBER)
  public void setSmsNumber_JsonNullable(JsonNullable<String> smsNumber) {
    this.smsNumber = smsNumber;
  }

  public void setSmsNumber(String smsNumber) {
    this.smsNumber = JsonNullable.<String>of(smsNumber);
  }


  public UserDetailsUpdateRequest mfaType(MFAType mfaType) {
    this.mfaType = JsonNullable.<MFAType>of(mfaType);
    
    return this;
  }

   /**
   * Get mfaType
   * @return mfaType
  **/
  @javax.annotation.Nullable
  @Valid
  @ApiModelProperty(value = "")
  @JsonIgnore

  public MFAType getMfaType() {
        return mfaType.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_MFA_TYPE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<MFAType> getMfaType_JsonNullable() {
    return mfaType;
  }
  
  @JsonProperty(JSON_PROPERTY_MFA_TYPE)
  public void setMfaType_JsonNullable(JsonNullable<MFAType> mfaType) {
    this.mfaType = mfaType;
  }

  public void setMfaType(MFAType mfaType) {
    this.mfaType = JsonNullable.<MFAType>of(mfaType);
  }


  public UserDetailsUpdateRequest verificationCode(String verificationCode) {
    this.verificationCode = JsonNullable.<String>of(verificationCode);
    
    return this;
  }

   /**
   * &lt;p&gt;Optional property that MUST be suppied when manually verifying a user&lt;/p&gt; &lt;p&gt;The user&#39;s smsNumber is registered via a separate endpoint and an OTP sent to them&lt;/p&gt; 
   * @return verificationCode
  **/
  @javax.annotation.Nullable
 @Size(min=6,max=6)  @ApiModelProperty(example = "123456", value = "<p>Optional property that MUST be suppied when manually verifying a user</p> <p>The user's smsNumber is registered via a separate endpoint and an OTP sent to them</p> ")
  @JsonIgnore

  public String getVerificationCode() {
        return verificationCode.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_VERIFICATION_CODE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<String> getVerificationCode_JsonNullable() {
    return verificationCode;
  }
  
  @JsonProperty(JSON_PROPERTY_VERIFICATION_CODE)
  public void setVerificationCode_JsonNullable(JsonNullable<String> verificationCode) {
    this.verificationCode = verificationCode;
  }

  public void setVerificationCode(String verificationCode) {
    this.verificationCode = JsonNullable.<String>of(verificationCode);
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    UserDetailsUpdateRequest userDetailsUpdateRequest = (UserDetailsUpdateRequest) o;
    return Objects.equals(this.primaryContactNumber, userDetailsUpdateRequest.primaryContactNumber) &&
        Objects.equals(this.secondaryContactNumber, userDetailsUpdateRequest.secondaryContactNumber) &&
        Objects.equals(this.firstName, userDetailsUpdateRequest.firstName) &&
        Objects.equals(this.lastName, userDetailsUpdateRequest.lastName) &&
        Objects.equals(this.email, userDetailsUpdateRequest.email) &&
        Objects.equals(this.smsNumber, userDetailsUpdateRequest.smsNumber) &&
        Objects.equals(this.mfaType, userDetailsUpdateRequest.mfaType) &&
        Objects.equals(this.verificationCode, userDetailsUpdateRequest.verificationCode);
  }

  @Override
  public int hashCode() {
    return Objects.hash(primaryContactNumber, secondaryContactNumber, firstName, lastName, email, smsNumber, mfaType, verificationCode);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class UserDetailsUpdateRequest {\n");
    sb.append("    primaryContactNumber: ").append(toIndentedString(primaryContactNumber)).append("\n");
    sb.append("    secondaryContactNumber: ").append(toIndentedString(secondaryContactNumber)).append("\n");
    sb.append("    firstName: ").append(toIndentedString(firstName)).append("\n");
    sb.append("    lastName: ").append(toIndentedString(lastName)).append("\n");
    sb.append("    email: ").append(toIndentedString(email)).append("\n");
    sb.append("    smsNumber: ").append(toIndentedString(smsNumber)).append("\n");
    sb.append("    mfaType: ").append(toIndentedString(mfaType)).append("\n");
    sb.append("    verificationCode: ").append(toIndentedString(verificationCode)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

