/*
 * Decompiled with CFR 0.152.
 */
package com.velopayments.oa3.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import javax.annotation.Nullable;
import javax.validation.constraints.NotNull;
import org.openapitools.jackson.nullable.JsonNullable;

@JsonPropertyOrder(value={"enabled", "minBalance", "targetBalance"})
public class AutoTopUpConfig {
    public static final String JSON_PROPERTY_ENABLED = "enabled";
    private Boolean enabled;
    public static final String JSON_PROPERTY_MIN_BALANCE = "minBalance";
    private JsonNullable<Long> minBalance = JsonNullable.undefined();
    public static final String JSON_PROPERTY_TARGET_BALANCE = "targetBalance";
    private JsonNullable<Long> targetBalance = JsonNullable.undefined();

    public AutoTopUpConfig enabled(Boolean enabled) {
        this.enabled = enabled;
        return this;
    }

    @NotNull
    @ApiModelProperty(example="true", required=true, value="Is auto top-up enabled? automatically trigger funding to top-up the source account balance when the balance falls below the configured minimum level.")
    @JsonProperty(value="enabled")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public Boolean getEnabled() {
        return this.enabled;
    }

    public void setEnabled(Boolean enabled) {
        this.enabled = enabled;
    }

    public AutoTopUpConfig minBalance(Long minBalance) {
        this.minBalance = JsonNullable.of((Object)minBalance);
        return this;
    }

    @Nullable
    @ApiModelProperty(example="10000", value="When the payor balance falls below this level then auto top-up will be triggered. Note - This is in minor units.")
    @JsonIgnore
    public Long getMinBalance() {
        return (Long)this.minBalance.orElse(null);
    }

    @JsonProperty(value="minBalance")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public JsonNullable<Long> getMinBalance_JsonNullable() {
        return this.minBalance;
    }

    @JsonProperty(value="minBalance")
    public void setMinBalance_JsonNullable(JsonNullable<Long> minBalance) {
        this.minBalance = minBalance;
    }

    public void setMinBalance(Long minBalance) {
        this.minBalance = JsonNullable.of((Object)minBalance);
    }

    public AutoTopUpConfig targetBalance(Long targetBalance) {
        this.targetBalance = JsonNullable.of((Object)targetBalance);
        return this;
    }

    @Nullable
    @ApiModelProperty(example="300000", value="When the payor balance falls below the min balance then auto top-up will request funds bring the balance to this level. Note - this is in minor units.")
    @JsonIgnore
    public Long getTargetBalance() {
        return (Long)this.targetBalance.orElse(null);
    }

    @JsonProperty(value="targetBalance")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public JsonNullable<Long> getTargetBalance_JsonNullable() {
        return this.targetBalance;
    }

    @JsonProperty(value="targetBalance")
    public void setTargetBalance_JsonNullable(JsonNullable<Long> targetBalance) {
        this.targetBalance = targetBalance;
    }

    public void setTargetBalance(Long targetBalance) {
        this.targetBalance = JsonNullable.of((Object)targetBalance);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AutoTopUpConfig autoTopUpConfig = (AutoTopUpConfig)o;
        return Objects.equals(this.enabled, autoTopUpConfig.enabled) && Objects.equals(this.minBalance, autoTopUpConfig.minBalance) && Objects.equals(this.targetBalance, autoTopUpConfig.targetBalance);
    }

    public int hashCode() {
        return Objects.hash(this.enabled, this.minBalance, this.targetBalance);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class AutoTopUpConfig {\n");
        sb.append("    enabled: ").append(this.toIndentedString(this.enabled)).append("\n");
        sb.append("    minBalance: ").append(this.toIndentedString(this.minBalance)).append("\n");
        sb.append("    targetBalance: ").append(this.toIndentedString(this.targetBalance)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

