/*
 * Decompiled with CFR 0.152.
 */
package com.velopayments.oa3.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.velopayments.oa3.model.MFAStatus;
import com.velopayments.oa3.model.MFAType;
import com.velopayments.oa3.model.TokenType;
import io.swagger.annotations.ApiModelProperty;
import java.time.OffsetDateTime;
import java.util.Objects;
import javax.annotation.Nullable;
import javax.validation.Valid;
import org.openapitools.jackson.nullable.JsonNullable;

@JsonPropertyOrder(value={"expiryDate", "mfaType", "tokenType", "mfaVerified", "mfaStatus"})
public class CheckTokenResponse {
    public static final String JSON_PROPERTY_EXPIRY_DATE = "expiryDate";
    private OffsetDateTime expiryDate;
    public static final String JSON_PROPERTY_MFA_TYPE = "mfaType";
    private JsonNullable<MFAType> mfaType = JsonNullable.undefined();
    public static final String JSON_PROPERTY_TOKEN_TYPE = "tokenType";
    private TokenType tokenType;
    public static final String JSON_PROPERTY_MFA_VERIFIED = "mfaVerified";
    private Boolean mfaVerified;
    public static final String JSON_PROPERTY_MFA_STATUS = "mfaStatus";
    private MFAStatus mfaStatus;

    public CheckTokenResponse expiryDate(OffsetDateTime expiryDate) {
        this.expiryDate = expiryDate;
        return this;
    }

    @Nullable
    @Valid
    @ApiModelProperty(example="2019-10-25T14:08:25.701Z", value="the timestamp when the token will expire")
    @JsonProperty(value="expiryDate")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public OffsetDateTime getExpiryDate() {
        return this.expiryDate;
    }

    public void setExpiryDate(OffsetDateTime expiryDate) {
        this.expiryDate = expiryDate;
    }

    public CheckTokenResponse mfaType(MFAType mfaType) {
        this.mfaType = JsonNullable.of((Object)((Object)mfaType));
        return this;
    }

    @Nullable
    @Valid
    @ApiModelProperty(value="")
    @JsonIgnore
    public MFAType getMfaType() {
        return (MFAType)((Object)this.mfaType.orElse(null));
    }

    @JsonProperty(value="mfaType")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public JsonNullable<MFAType> getMfaType_JsonNullable() {
        return this.mfaType;
    }

    @JsonProperty(value="mfaType")
    public void setMfaType_JsonNullable(JsonNullable<MFAType> mfaType) {
        this.mfaType = mfaType;
    }

    public void setMfaType(MFAType mfaType) {
        this.mfaType = JsonNullable.of((Object)((Object)mfaType));
    }

    public CheckTokenResponse tokenType(TokenType tokenType) {
        this.tokenType = tokenType;
        return this;
    }

    @Nullable
    @Valid
    @ApiModelProperty(value="")
    @JsonProperty(value="tokenType")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public TokenType getTokenType() {
        return this.tokenType;
    }

    public void setTokenType(TokenType tokenType) {
        this.tokenType = tokenType;
    }

    public CheckTokenResponse mfaVerified(Boolean mfaVerified) {
        this.mfaVerified = mfaVerified;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="has the user verified their MFA device by logging in")
    @JsonProperty(value="mfaVerified")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getMfaVerified() {
        return this.mfaVerified;
    }

    public void setMfaVerified(Boolean mfaVerified) {
        this.mfaVerified = mfaVerified;
    }

    public CheckTokenResponse mfaStatus(MFAStatus mfaStatus) {
        this.mfaStatus = mfaStatus;
        return this;
    }

    @Nullable
    @Valid
    @ApiModelProperty(value="")
    @JsonProperty(value="mfaStatus")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public MFAStatus getMfaStatus() {
        return this.mfaStatus;
    }

    public void setMfaStatus(MFAStatus mfaStatus) {
        this.mfaStatus = mfaStatus;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CheckTokenResponse checkTokenResponse = (CheckTokenResponse)o;
        return Objects.equals(this.expiryDate, checkTokenResponse.expiryDate) && Objects.equals(this.mfaType, checkTokenResponse.mfaType) && Objects.equals((Object)this.tokenType, (Object)checkTokenResponse.tokenType) && Objects.equals(this.mfaVerified, checkTokenResponse.mfaVerified) && Objects.equals((Object)this.mfaStatus, (Object)checkTokenResponse.mfaStatus);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.expiryDate, this.mfaType, this.tokenType, this.mfaVerified, this.mfaStatus});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class CheckTokenResponse {\n");
        sb.append("    expiryDate: ").append(this.toIndentedString(this.expiryDate)).append("\n");
        sb.append("    mfaType: ").append(this.toIndentedString(this.mfaType)).append("\n");
        sb.append("    tokenType: ").append(this.toIndentedString((Object)this.tokenType)).append("\n");
        sb.append("    mfaVerified: ").append(this.toIndentedString(this.mfaVerified)).append("\n");
        sb.append("    mfaStatus: ").append(this.toIndentedString((Object)this.mfaStatus)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

