/*
 * Decompiled with CFR 0.152.
 */
package com.velopayments.oa3.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import javax.annotation.Nullable;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import org.openapitools.jackson.nullable.JsonNullable;

@JsonPropertyOrder(value={"name", "taxId", "operatingName"})
public class Company2 {
    public static final String JSON_PROPERTY_NAME = "name";
    private String name;
    public static final String JSON_PROPERTY_TAX_ID = "taxId";
    private JsonNullable<String> taxId = JsonNullable.undefined();
    public static final String JSON_PROPERTY_OPERATING_NAME = "operatingName";
    private JsonNullable<String> operatingName = JsonNullable.undefined();

    public Company2 name(String name) {
        this.name = name;
        return this;
    }

    @NotNull
    @Size(min=1, max=40)
    @ApiModelProperty(example="ABC Group Plc", required=true, value="")
    @JsonProperty(value="name")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public @NotNull @Size(min=1, max=40) String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Company2 taxId(String taxId) {
        this.taxId = JsonNullable.of((Object)taxId);
        return this;
    }

    @Nullable
    @Size(min=6, max=30)
    @ApiModelProperty(example="123123123", value="Company Tax Id must be between 6 and 30 characters long")
    @JsonIgnore
    public @Size(min=6, max=30) String getTaxId() {
        return (String)this.taxId.orElse(null);
    }

    @JsonProperty(value="taxId")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public JsonNullable<String> getTaxId_JsonNullable() {
        return this.taxId;
    }

    @JsonProperty(value="taxId")
    public void setTaxId_JsonNullable(JsonNullable<String> taxId) {
        this.taxId = taxId;
    }

    public void setTaxId(String taxId) {
        this.taxId = JsonNullable.of((Object)taxId);
    }

    public Company2 operatingName(String operatingName) {
        this.operatingName = JsonNullable.of((Object)operatingName);
        return this;
    }

    @Nullable
    @Size(min=1, max=100)
    @ApiModelProperty(example="ABC Co", value="")
    @JsonIgnore
    public @Size(min=1, max=100) String getOperatingName() {
        return (String)this.operatingName.orElse(null);
    }

    @JsonProperty(value="operatingName")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public JsonNullable<String> getOperatingName_JsonNullable() {
        return this.operatingName;
    }

    @JsonProperty(value="operatingName")
    public void setOperatingName_JsonNullable(JsonNullable<String> operatingName) {
        this.operatingName = operatingName;
    }

    public void setOperatingName(String operatingName) {
        this.operatingName = JsonNullable.of((Object)operatingName);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Company2 company2 = (Company2)o;
        return Objects.equals(this.name, company2.name) && Objects.equals(this.taxId, company2.taxId) && Objects.equals(this.operatingName, company2.operatingName);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.taxId, this.operatingName);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Company2 {\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    taxId: ").append(this.toIndentedString(this.taxId)).append("\n");
        sb.append("    operatingName: ").append(this.toIndentedString(this.operatingName)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

