/*
 * Decompiled with CFR 0.152.
 */
package com.velopayments.oa3.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import javax.annotation.Nullable;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Pattern;
import javax.validation.constraints.Size;

@JsonPropertyOrder(value={"paymentChannelName", "iban", "accountNumber", "routingNumber", "countryCode", "currency", "accountName"})
public class CreatePaymentChannel {
    public static final String JSON_PROPERTY_PAYMENT_CHANNEL_NAME = "paymentChannelName";
    private String paymentChannelName;
    public static final String JSON_PROPERTY_IBAN = "iban";
    private String iban;
    public static final String JSON_PROPERTY_ACCOUNT_NUMBER = "accountNumber";
    private String accountNumber;
    public static final String JSON_PROPERTY_ROUTING_NUMBER = "routingNumber";
    private String routingNumber;
    public static final String JSON_PROPERTY_COUNTRY_CODE = "countryCode";
    private CountryCodeEnum countryCode;
    public static final String JSON_PROPERTY_CURRENCY = "currency";
    private CurrencyEnum currency;
    public static final String JSON_PROPERTY_ACCOUNT_NAME = "accountName";
    private String accountName;

    public CreatePaymentChannel paymentChannelName(String paymentChannelName) {
        this.paymentChannelName = paymentChannelName;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="My Payment Channel", value="")
    @JsonProperty(value="paymentChannelName")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getPaymentChannelName() {
        return this.paymentChannelName;
    }

    public void setPaymentChannelName(String paymentChannelName) {
        this.paymentChannelName = paymentChannelName;
    }

    public CreatePaymentChannel iban(String iban) {
        this.iban = iban;
        return this;
    }

    @Nullable
    @Pattern(regexp="^[A-Za-z0-9]+$")
    @Size(min=15, max=34)
    @ApiModelProperty(example="XXXXXXXXXXXXXXXXXXXXXXXXXXXXXX1234", value="Must match the regular expression ```^[A-Za-z0-9]+$```. Either routing number and account number or only iban must be set")
    @JsonProperty(value="iban")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public @Pattern(regexp="^[A-Za-z0-9]+$") @Size(min=15, max=34) String getIban() {
        return this.iban;
    }

    public void setIban(String iban) {
        this.iban = iban;
    }

    public CreatePaymentChannel accountNumber(String accountNumber) {
        this.accountNumber = accountNumber;
        return this;
    }

    @Nullable
    @Size(min=6, max=17)
    @ApiModelProperty(example="XXXXXX5678", value="Either routing number and account number or only iban must be set")
    @JsonProperty(value="accountNumber")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public @Size(min=6, max=17) String getAccountNumber() {
        return this.accountNumber;
    }

    public void setAccountNumber(String accountNumber) {
        this.accountNumber = accountNumber;
    }

    public CreatePaymentChannel routingNumber(String routingNumber) {
        this.routingNumber = routingNumber;
        return this;
    }

    @Nullable
    @Size(min=9, max=9)
    @ApiModelProperty(example="XXXXX6789", value="Either routing number and account number or only iban must be set")
    @JsonProperty(value="routingNumber")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public @Size(min=9, max=9) String getRoutingNumber() {
        return this.routingNumber;
    }

    public void setRoutingNumber(String routingNumber) {
        this.routingNumber = routingNumber;
    }

    public CreatePaymentChannel countryCode(CountryCodeEnum countryCode) {
        this.countryCode = countryCode;
        return this;
    }

    @NotNull
    @Size(min=2, max=2)
    @ApiModelProperty(example="US", required=true, value="Two character country code")
    @JsonProperty(value="countryCode")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public @NotNull @Size(min=2, max=2) CountryCodeEnum getCountryCode() {
        return this.countryCode;
    }

    public void setCountryCode(CountryCodeEnum countryCode) {
        this.countryCode = countryCode;
    }

    public CreatePaymentChannel currency(CurrencyEnum currency) {
        this.currency = currency;
        return this;
    }

    @NotNull
    @ApiModelProperty(required=true, value="")
    @JsonProperty(value="currency")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public CurrencyEnum getCurrency() {
        return this.currency;
    }

    public void setCurrency(CurrencyEnum currency) {
        this.currency = currency;
    }

    public CreatePaymentChannel accountName(String accountName) {
        this.accountName = accountName;
        return this;
    }

    @NotNull
    @ApiModelProperty(example="My account", required=true, value="")
    @JsonProperty(value="accountName")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getAccountName() {
        return this.accountName;
    }

    public void setAccountName(String accountName) {
        this.accountName = accountName;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CreatePaymentChannel createPaymentChannel = (CreatePaymentChannel)o;
        return Objects.equals(this.paymentChannelName, createPaymentChannel.paymentChannelName) && Objects.equals(this.iban, createPaymentChannel.iban) && Objects.equals(this.accountNumber, createPaymentChannel.accountNumber) && Objects.equals(this.routingNumber, createPaymentChannel.routingNumber) && Objects.equals((Object)this.countryCode, (Object)createPaymentChannel.countryCode) && Objects.equals((Object)this.currency, (Object)createPaymentChannel.currency) && Objects.equals(this.accountName, createPaymentChannel.accountName);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.paymentChannelName, this.iban, this.accountNumber, this.routingNumber, this.countryCode, this.currency, this.accountName});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class CreatePaymentChannel {\n");
        sb.append("    paymentChannelName: ").append(this.toIndentedString(this.paymentChannelName)).append("\n");
        sb.append("    iban: ").append(this.toIndentedString(this.iban)).append("\n");
        sb.append("    accountNumber: ").append(this.toIndentedString(this.accountNumber)).append("\n");
        sb.append("    routingNumber: ").append(this.toIndentedString(this.routingNumber)).append("\n");
        sb.append("    countryCode: ").append(this.toIndentedString((Object)this.countryCode)).append("\n");
        sb.append("    currency: ").append(this.toIndentedString((Object)this.currency)).append("\n");
        sb.append("    accountName: ").append(this.toIndentedString(this.accountName)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum CurrencyEnum {
        USD("USD"),
        GBP("GBP"),
        EUR("EUR");

        private String value;

        private CurrencyEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static CurrencyEnum fromValue(String value) {
            for (CurrencyEnum b : CurrencyEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }

    public static enum CountryCodeEnum {
        AF("AF"),
        AX("AX"),
        AL("AL"),
        DZ("DZ"),
        AS("AS"),
        AD("AD"),
        AO("AO"),
        AI("AI"),
        AQ("AQ"),
        AG("AG"),
        AR("AR"),
        AM("AM"),
        AW("AW"),
        AU("AU"),
        AT("AT"),
        AZ("AZ"),
        BS("BS"),
        BH("BH"),
        BD("BD"),
        BB("BB"),
        BY("BY"),
        BE("BE"),
        BZ("BZ"),
        BJ("BJ"),
        BM("BM"),
        BT("BT"),
        BO("BO"),
        BQ("BQ"),
        BA("BA"),
        BW("BW"),
        BV("BV"),
        BR("BR"),
        IO("IO"),
        BN("BN"),
        BG("BG"),
        BF("BF"),
        BI("BI"),
        KH("KH"),
        CM("CM"),
        CA("CA"),
        CV("CV"),
        KY("KY"),
        CF("CF"),
        TD("TD"),
        CL("CL"),
        CN("CN"),
        CX("CX"),
        CC("CC"),
        CO("CO"),
        KM("KM"),
        CG("CG"),
        CD("CD"),
        CK("CK"),
        CR("CR"),
        CI("CI"),
        HR("HR"),
        CU("CU"),
        CW("CW"),
        CY("CY"),
        CZ("CZ"),
        DK("DK"),
        DJ("DJ"),
        DM("DM"),
        DO("DO"),
        EC("EC"),
        EG("EG"),
        SV("SV"),
        GQ("GQ"),
        ER("ER"),
        EE("EE"),
        ET("ET"),
        FK("FK"),
        FO("FO"),
        FJ("FJ"),
        FI("FI"),
        FR("FR"),
        GF("GF"),
        PF("PF"),
        TF("TF"),
        GA("GA"),
        GM("GM"),
        GE("GE"),
        DE("DE"),
        GH("GH"),
        GI("GI"),
        GR("GR"),
        GL("GL"),
        GD("GD"),
        GP("GP"),
        GU("GU"),
        GT("GT"),
        GG("GG"),
        GN("GN"),
        GW("GW"),
        GY("GY"),
        HT("HT"),
        HM("HM"),
        VA("VA"),
        HN("HN"),
        HK("HK"),
        HU("HU"),
        IS("IS"),
        IN("IN"),
        ID("ID"),
        IR("IR"),
        IQ("IQ"),
        IE("IE"),
        IM("IM"),
        IL("IL"),
        IT("IT"),
        JM("JM"),
        JP("JP"),
        JE("JE"),
        JO("JO"),
        KZ("KZ"),
        KE("KE"),
        KI("KI"),
        KP("KP"),
        KR("KR"),
        KW("KW"),
        KG("KG"),
        LA("LA"),
        LV("LV"),
        LB("LB"),
        LS("LS"),
        LR("LR"),
        LY("LY"),
        LI("LI"),
        LT("LT"),
        LU("LU"),
        MO("MO"),
        MK("MK"),
        MG("MG"),
        MW("MW"),
        MY("MY"),
        MV("MV"),
        ML("ML"),
        MT("MT"),
        MH("MH"),
        MQ("MQ"),
        MR("MR"),
        MU("MU"),
        YT("YT"),
        MX("MX"),
        FM("FM"),
        MD("MD"),
        MC("MC"),
        MN("MN"),
        ME("ME"),
        MS("MS"),
        MA("MA"),
        MZ("MZ"),
        MM("MM"),
        NA("NA"),
        NR("NR"),
        NP("NP"),
        NL("NL"),
        NC("NC"),
        NZ("NZ"),
        NI("NI"),
        NE("NE"),
        NG("NG"),
        NU("NU"),
        NF("NF"),
        MP("MP"),
        NO("NO"),
        OM("OM"),
        PK("PK"),
        PW("PW"),
        PS("PS"),
        PA("PA"),
        PG("PG"),
        PY("PY"),
        PE("PE"),
        PH("PH"),
        PN("PN"),
        PL("PL"),
        PT("PT"),
        PR("PR"),
        QA("QA"),
        RE("RE"),
        RO("RO"),
        RU("RU"),
        RW("RW"),
        BL("BL"),
        SH("SH"),
        KN("KN"),
        LC("LC"),
        MF("MF"),
        PM("PM"),
        VC("VC"),
        WS("WS"),
        SM("SM"),
        ST("ST"),
        SA("SA"),
        SN("SN"),
        RS("RS"),
        SC("SC"),
        SL("SL"),
        SG("SG"),
        SX("SX"),
        SK("SK"),
        SI("SI"),
        SB("SB"),
        SO("SO"),
        ZA("ZA"),
        GS("GS"),
        SS("SS"),
        ES("ES"),
        LK("LK"),
        SD("SD"),
        SR("SR"),
        SJ("SJ"),
        SZ("SZ"),
        SE("SE"),
        CH("CH"),
        SY("SY"),
        TW("TW"),
        TJ("TJ"),
        TZ("TZ"),
        TH("TH"),
        TL("TL"),
        TG("TG"),
        TK("TK"),
        TO("TO"),
        TT("TT"),
        TN("TN"),
        TR("TR"),
        TM("TM"),
        TC("TC"),
        TV("TV"),
        UG("UG"),
        UA("UA"),
        AE("AE"),
        GB("GB"),
        US("US"),
        UM("UM"),
        UY("UY"),
        UZ("UZ"),
        VU("VU"),
        VE("VE"),
        VN("VN"),
        VG("VG"),
        VI("VI"),
        WF("WF"),
        EH("EH"),
        YE("YE"),
        ZM("ZM"),
        ZW("ZW");

        private String value;

        private CountryCodeEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static CountryCodeEnum fromValue(String value) {
            for (CountryCodeEnum b : CountryCodeEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }
}

