/*
 * Decompiled with CFR 0.152.
 */
package com.velopayments.oa3.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModelProperty;
import java.time.OffsetDateTime;
import java.util.Objects;
import javax.annotation.Nullable;
import javax.validation.Valid;

@JsonPropertyOrder(value={"payoutStatus", "submittedDateTime", "instructedDateTime", "payoutMemo", "totalPayments", "confirmedPayments", "releasedPayments", "incompletePayments", "failedPayments"})
public class GetPaymentsForPayoutResponseV3Summary {
    public static final String JSON_PROPERTY_PAYOUT_STATUS = "payoutStatus";
    private PayoutStatusEnum payoutStatus;
    public static final String JSON_PROPERTY_SUBMITTED_DATE_TIME = "submittedDateTime";
    private OffsetDateTime submittedDateTime;
    public static final String JSON_PROPERTY_INSTRUCTED_DATE_TIME = "instructedDateTime";
    private OffsetDateTime instructedDateTime;
    public static final String JSON_PROPERTY_PAYOUT_MEMO = "payoutMemo";
    private String payoutMemo;
    public static final String JSON_PROPERTY_TOTAL_PAYMENTS = "totalPayments";
    private Integer totalPayments;
    public static final String JSON_PROPERTY_CONFIRMED_PAYMENTS = "confirmedPayments";
    private Integer confirmedPayments;
    public static final String JSON_PROPERTY_RELEASED_PAYMENTS = "releasedPayments";
    private Integer releasedPayments;
    public static final String JSON_PROPERTY_INCOMPLETE_PAYMENTS = "incompletePayments";
    private Integer incompletePayments;
    public static final String JSON_PROPERTY_FAILED_PAYMENTS = "failedPayments";
    private Integer failedPayments;

    public GetPaymentsForPayoutResponseV3Summary payoutStatus(PayoutStatusEnum payoutStatus) {
        this.payoutStatus = payoutStatus;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The current status of the payout.")
    @JsonProperty(value="payoutStatus")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public PayoutStatusEnum getPayoutStatus() {
        return this.payoutStatus;
    }

    public void setPayoutStatus(PayoutStatusEnum payoutStatus) {
        this.payoutStatus = payoutStatus;
    }

    public GetPaymentsForPayoutResponseV3Summary submittedDateTime(OffsetDateTime submittedDateTime) {
        this.submittedDateTime = submittedDateTime;
        return this;
    }

    @Nullable
    @Valid
    @ApiModelProperty(value="The date/time at which the payout was submitted.")
    @JsonProperty(value="submittedDateTime")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public OffsetDateTime getSubmittedDateTime() {
        return this.submittedDateTime;
    }

    public void setSubmittedDateTime(OffsetDateTime submittedDateTime) {
        this.submittedDateTime = submittedDateTime;
    }

    public GetPaymentsForPayoutResponseV3Summary instructedDateTime(OffsetDateTime instructedDateTime) {
        this.instructedDateTime = instructedDateTime;
        return this;
    }

    @Nullable
    @Valid
    @ApiModelProperty(value="The date/time at which the payout was instructed.")
    @JsonProperty(value="instructedDateTime")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public OffsetDateTime getInstructedDateTime() {
        return this.instructedDateTime;
    }

    public void setInstructedDateTime(OffsetDateTime instructedDateTime) {
        this.instructedDateTime = instructedDateTime;
    }

    public GetPaymentsForPayoutResponseV3Summary payoutMemo(String payoutMemo) {
        this.payoutMemo = payoutMemo;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="Payment Memo value", value="The memo attached to the payout.")
    @JsonProperty(value="payoutMemo")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getPayoutMemo() {
        return this.payoutMemo;
    }

    public void setPayoutMemo(String payoutMemo) {
        this.payoutMemo = payoutMemo;
    }

    public GetPaymentsForPayoutResponseV3Summary totalPayments(Integer totalPayments) {
        this.totalPayments = totalPayments;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="123", value="The count of payments within the payout.")
    @JsonProperty(value="totalPayments")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Integer getTotalPayments() {
        return this.totalPayments;
    }

    public void setTotalPayments(Integer totalPayments) {
        this.totalPayments = totalPayments;
    }

    public GetPaymentsForPayoutResponseV3Summary confirmedPayments(Integer confirmedPayments) {
        this.confirmedPayments = confirmedPayments;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="123", value="The count of payments within the payout which have been confirmed.")
    @JsonProperty(value="confirmedPayments")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Integer getConfirmedPayments() {
        return this.confirmedPayments;
    }

    public void setConfirmedPayments(Integer confirmedPayments) {
        this.confirmedPayments = confirmedPayments;
    }

    public GetPaymentsForPayoutResponseV3Summary releasedPayments(Integer releasedPayments) {
        this.releasedPayments = releasedPayments;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="123", value="The count of payments within the payout which have been released.")
    @JsonProperty(value="releasedPayments")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Integer getReleasedPayments() {
        return this.releasedPayments;
    }

    public void setReleasedPayments(Integer releasedPayments) {
        this.releasedPayments = releasedPayments;
    }

    public GetPaymentsForPayoutResponseV3Summary incompletePayments(Integer incompletePayments) {
        this.incompletePayments = incompletePayments;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="123", value="The count of payments within the payout which are incomplete.")
    @JsonProperty(value="incompletePayments")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Integer getIncompletePayments() {
        return this.incompletePayments;
    }

    public void setIncompletePayments(Integer incompletePayments) {
        this.incompletePayments = incompletePayments;
    }

    public GetPaymentsForPayoutResponseV3Summary failedPayments(Integer failedPayments) {
        this.failedPayments = failedPayments;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="0", value="The count of payments within the payout which have failed or been returned.")
    @JsonProperty(value="failedPayments")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Integer getFailedPayments() {
        return this.failedPayments;
    }

    public void setFailedPayments(Integer failedPayments) {
        this.failedPayments = failedPayments;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GetPaymentsForPayoutResponseV3Summary getPaymentsForPayoutResponseV3Summary = (GetPaymentsForPayoutResponseV3Summary)o;
        return Objects.equals((Object)this.payoutStatus, (Object)getPaymentsForPayoutResponseV3Summary.payoutStatus) && Objects.equals(this.submittedDateTime, getPaymentsForPayoutResponseV3Summary.submittedDateTime) && Objects.equals(this.instructedDateTime, getPaymentsForPayoutResponseV3Summary.instructedDateTime) && Objects.equals(this.payoutMemo, getPaymentsForPayoutResponseV3Summary.payoutMemo) && Objects.equals(this.totalPayments, getPaymentsForPayoutResponseV3Summary.totalPayments) && Objects.equals(this.confirmedPayments, getPaymentsForPayoutResponseV3Summary.confirmedPayments) && Objects.equals(this.releasedPayments, getPaymentsForPayoutResponseV3Summary.releasedPayments) && Objects.equals(this.incompletePayments, getPaymentsForPayoutResponseV3Summary.incompletePayments) && Objects.equals(this.failedPayments, getPaymentsForPayoutResponseV3Summary.failedPayments);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.payoutStatus, this.submittedDateTime, this.instructedDateTime, this.payoutMemo, this.totalPayments, this.confirmedPayments, this.releasedPayments, this.incompletePayments, this.failedPayments});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class GetPaymentsForPayoutResponseV3Summary {\n");
        sb.append("    payoutStatus: ").append(this.toIndentedString((Object)this.payoutStatus)).append("\n");
        sb.append("    submittedDateTime: ").append(this.toIndentedString(this.submittedDateTime)).append("\n");
        sb.append("    instructedDateTime: ").append(this.toIndentedString(this.instructedDateTime)).append("\n");
        sb.append("    payoutMemo: ").append(this.toIndentedString(this.payoutMemo)).append("\n");
        sb.append("    totalPayments: ").append(this.toIndentedString(this.totalPayments)).append("\n");
        sb.append("    confirmedPayments: ").append(this.toIndentedString(this.confirmedPayments)).append("\n");
        sb.append("    releasedPayments: ").append(this.toIndentedString(this.releasedPayments)).append("\n");
        sb.append("    incompletePayments: ").append(this.toIndentedString(this.incompletePayments)).append("\n");
        sb.append("    failedPayments: ").append(this.toIndentedString(this.failedPayments)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum PayoutStatusEnum {
        ACCEPTED("ACCEPTED"),
        REJECTED("REJECTED"),
        SUBMITTED("SUBMITTED"),
        QUOTED("QUOTED"),
        INSTRUCTED("INSTRUCTED"),
        COMPLETED("COMPLETED"),
        INCOMPLETE("INCOMPLETE"),
        CONFIRMED("CONFIRMED"),
        WITHDRAWN("WITHDRAWN");

        private String value;

        private PayoutStatusEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static PayoutStatusEnum fromValue(String value) {
            for (PayoutStatusEnum b : PayoutStatusEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }
}

