/*
 * Decompiled with CFR 0.152.
 */
package com.velopayments.oa3.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.velopayments.oa3.model.IndividualName;
import io.swagger.annotations.ApiModelProperty;
import java.time.LocalDate;
import java.util.Objects;
import javax.annotation.Nullable;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;

@JsonPropertyOrder(value={"name", "nationalIdentification", "dateOfBirth"})
public class Individual {
    public static final String JSON_PROPERTY_NAME = "name";
    private IndividualName name;
    public static final String JSON_PROPERTY_NATIONAL_IDENTIFICATION = "nationalIdentification";
    private String nationalIdentification;
    public static final String JSON_PROPERTY_DATE_OF_BIRTH = "dateOfBirth";
    private LocalDate dateOfBirth;

    public Individual name(IndividualName name) {
        this.name = name;
        return this;
    }

    @NotNull
    @Valid
    @ApiModelProperty(required=true, value="")
    @JsonProperty(value="name")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public IndividualName getName() {
        return this.name;
    }

    public void setName(IndividualName name) {
        this.name = name;
    }

    public Individual nationalIdentification(String nationalIdentification) {
        this.nationalIdentification = nationalIdentification;
        return this;
    }

    @Nullable
    @Size(min=6, max=30)
    @ApiModelProperty(value="The identification particular to the payees country")
    @JsonProperty(value="nationalIdentification")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public @Size(min=6, max=30) String getNationalIdentification() {
        return this.nationalIdentification;
    }

    public void setNationalIdentification(String nationalIdentification) {
        this.nationalIdentification = nationalIdentification;
    }

    public Individual dateOfBirth(LocalDate dateOfBirth) {
        this.dateOfBirth = dateOfBirth;
        return this;
    }

    @NotNull
    @Valid
    @ApiModelProperty(required=true, value="The date of birth of the payee")
    @JsonProperty(value="dateOfBirth")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public LocalDate getDateOfBirth() {
        return this.dateOfBirth;
    }

    public void setDateOfBirth(LocalDate dateOfBirth) {
        this.dateOfBirth = dateOfBirth;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Individual individual = (Individual)o;
        return Objects.equals(this.name, individual.name) && Objects.equals(this.nationalIdentification, individual.nationalIdentification) && Objects.equals(this.dateOfBirth, individual.dateOfBirth);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.nationalIdentification, this.dateOfBirth);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Individual {\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    nationalIdentification: ").append(this.toIndentedString(this.nationalIdentification)).append("\n");
        sb.append("    dateOfBirth: ").append(this.toIndentedString(this.dateOfBirth)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

