/*
 * Decompiled with CFR 0.152.
 */
package com.velopayments.oa3.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.velopayments.oa3.model.Language;
import com.velopayments.oa3.model.Task;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import javax.validation.Valid;
import javax.validation.constraints.Size;

@JsonPropertyOrder(value={"tasks", "country", "language", "payorName"})
public class InviteResponse {
    public static final String JSON_PROPERTY_TASKS = "tasks";
    private List<Task> tasks = null;
    public static final String JSON_PROPERTY_COUNTRY = "country";
    private String country;
    public static final String JSON_PROPERTY_LANGUAGE = "language";
    private Language language;
    public static final String JSON_PROPERTY_PAYOR_NAME = "payorName";
    private String payorName;

    public InviteResponse tasks(List<Task> tasks) {
        this.tasks = tasks;
        return this;
    }

    public InviteResponse addTasksItem(Task tasksItem) {
        if (this.tasks == null) {
            this.tasks = new ArrayList<Task>();
        }
        this.tasks.add(tasksItem);
        return this;
    }

    @Nullable
    @Valid
    @Size(min=5, max=5)
    @ApiModelProperty(value="The tasks that have to be completed for the invite ")
    @JsonProperty(value="tasks")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public @Valid @Size(min=5, max=5) List<Task> getTasks() {
        return this.tasks;
    }

    public void setTasks(List<Task> tasks) {
        this.tasks = tasks;
    }

    public InviteResponse country(String country) {
        this.country = country;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="United Kingdom", value="The country that the payee resides in")
    @JsonProperty(value="country")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getCountry() {
        return this.country;
    }

    public void setCountry(String country) {
        this.country = country;
    }

    public InviteResponse language(Language language) {
        this.language = language;
        return this;
    }

    @Nullable
    @Valid
    @ApiModelProperty(value="")
    @JsonProperty(value="language")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Language getLanguage() {
        return this.language;
    }

    public void setLanguage(Language language) {
        this.language = language;
    }

    public InviteResponse payorName(String payorName) {
        this.payorName = payorName;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="Foo Widgets, Inc", value="The name of the payor that invited the payee")
    @JsonProperty(value="payorName")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getPayorName() {
        return this.payorName;
    }

    public void setPayorName(String payorName) {
        this.payorName = payorName;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        InviteResponse inviteResponse = (InviteResponse)o;
        return Objects.equals(this.tasks, inviteResponse.tasks) && Objects.equals(this.country, inviteResponse.country) && Objects.equals((Object)this.language, (Object)inviteResponse.language) && Objects.equals(this.payorName, inviteResponse.payorName);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.tasks, this.country, this.language, this.payorName});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class InviteResponse {\n");
        sb.append("    tasks: ").append(this.toIndentedString(this.tasks)).append("\n");
        sb.append("    country: ").append(this.toIndentedString(this.country)).append("\n");
        sb.append("    language: ").append(this.toIndentedString((Object)this.language)).append("\n");
        sb.append("    payorName: ").append(this.toIndentedString(this.payorName)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

