/*
 * Decompiled with CFR 0.152.
 */
package com.velopayments.oa3.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import javax.annotation.Nullable;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Pattern;
import javax.validation.constraints.Size;

@JsonPropertyOrder(value={"paymentChannelName", "iban", "accountNumber", "routingNumber", "countryCode", "currency", "accountName"})
public class PayeePaymentChannel2 {
    public static final String JSON_PROPERTY_PAYMENT_CHANNEL_NAME = "paymentChannelName";
    private String paymentChannelName;
    public static final String JSON_PROPERTY_IBAN = "iban";
    private String iban;
    public static final String JSON_PROPERTY_ACCOUNT_NUMBER = "accountNumber";
    private String accountNumber;
    public static final String JSON_PROPERTY_ROUTING_NUMBER = "routingNumber";
    private String routingNumber;
    public static final String JSON_PROPERTY_COUNTRY_CODE = "countryCode";
    private String countryCode;
    public static final String JSON_PROPERTY_CURRENCY = "currency";
    private CurrencyEnum currency;
    public static final String JSON_PROPERTY_ACCOUNT_NAME = "accountName";
    private String accountName;

    public PayeePaymentChannel2 paymentChannelName(String paymentChannelName) {
        this.paymentChannelName = paymentChannelName;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="paymentChannelName")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getPaymentChannelName() {
        return this.paymentChannelName;
    }

    public void setPaymentChannelName(String paymentChannelName) {
        this.paymentChannelName = paymentChannelName;
    }

    public PayeePaymentChannel2 iban(String iban) {
        this.iban = iban;
        return this;
    }

    @Nullable
    @Pattern(regexp="^[A-Za-z0-9]+$")
    @Size(min=15, max=34)
    @ApiModelProperty(example="XXXXXXXXXXXXXXXXXXXXXXXXXXXXXX1234", value="Must match the regular expression ```^[A-Za-z0-9]+$```.")
    @JsonProperty(value="iban")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public @Pattern(regexp="^[A-Za-z0-9]+$") @Size(min=15, max=34) String getIban() {
        return this.iban;
    }

    public void setIban(String iban) {
        this.iban = iban;
    }

    public PayeePaymentChannel2 accountNumber(String accountNumber) {
        this.accountNumber = accountNumber;
        return this;
    }

    @NotNull
    @Size(min=6, max=17)
    @ApiModelProperty(example="XXXXXX5678", required=true, value="")
    @JsonProperty(value="accountNumber")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public @NotNull @Size(min=6, max=17) String getAccountNumber() {
        return this.accountNumber;
    }

    public void setAccountNumber(String accountNumber) {
        this.accountNumber = accountNumber;
    }

    public PayeePaymentChannel2 routingNumber(String routingNumber) {
        this.routingNumber = routingNumber;
        return this;
    }

    @NotNull
    @Size(min=9, max=9)
    @ApiModelProperty(example="XXXXX6789", required=true, value="")
    @JsonProperty(value="routingNumber")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public @NotNull @Size(min=9, max=9) String getRoutingNumber() {
        return this.routingNumber;
    }

    public void setRoutingNumber(String routingNumber) {
        this.routingNumber = routingNumber;
    }

    public PayeePaymentChannel2 countryCode(String countryCode) {
        this.countryCode = countryCode;
        return this;
    }

    @NotNull
    @Pattern(regexp="^[A-Z]{2}$")
    @Size(min=2, max=2)
    @ApiModelProperty(example="US", required=true, value="Country Code must be a valid 2 letter ISO 3166-1 country code")
    @JsonProperty(value="countryCode")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public @NotNull @Pattern(regexp="^[A-Z]{2}$") @Size(min=2, max=2) String getCountryCode() {
        return this.countryCode;
    }

    public void setCountryCode(String countryCode) {
        this.countryCode = countryCode;
    }

    public PayeePaymentChannel2 currency(CurrencyEnum currency) {
        this.currency = currency;
        return this;
    }

    @NotNull
    @ApiModelProperty(required=true, value="")
    @JsonProperty(value="currency")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public CurrencyEnum getCurrency() {
        return this.currency;
    }

    public void setCurrency(CurrencyEnum currency) {
        this.currency = currency;
    }

    public PayeePaymentChannel2 accountName(String accountName) {
        this.accountName = accountName;
        return this;
    }

    @NotNull
    @ApiModelProperty(example="My account", required=true, value="")
    @JsonProperty(value="accountName")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getAccountName() {
        return this.accountName;
    }

    public void setAccountName(String accountName) {
        this.accountName = accountName;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PayeePaymentChannel2 payeePaymentChannel2 = (PayeePaymentChannel2)o;
        return Objects.equals(this.paymentChannelName, payeePaymentChannel2.paymentChannelName) && Objects.equals(this.iban, payeePaymentChannel2.iban) && Objects.equals(this.accountNumber, payeePaymentChannel2.accountNumber) && Objects.equals(this.routingNumber, payeePaymentChannel2.routingNumber) && Objects.equals(this.countryCode, payeePaymentChannel2.countryCode) && Objects.equals((Object)this.currency, (Object)payeePaymentChannel2.currency) && Objects.equals(this.accountName, payeePaymentChannel2.accountName);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.paymentChannelName, this.iban, this.accountNumber, this.routingNumber, this.countryCode, this.currency, this.accountName});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class PayeePaymentChannel2 {\n");
        sb.append("    paymentChannelName: ").append(this.toIndentedString(this.paymentChannelName)).append("\n");
        sb.append("    iban: ").append(this.toIndentedString(this.iban)).append("\n");
        sb.append("    accountNumber: ").append(this.toIndentedString(this.accountNumber)).append("\n");
        sb.append("    routingNumber: ").append(this.toIndentedString(this.routingNumber)).append("\n");
        sb.append("    countryCode: ").append(this.toIndentedString(this.countryCode)).append("\n");
        sb.append("    currency: ").append(this.toIndentedString((Object)this.currency)).append("\n");
        sb.append("    accountName: ").append(this.toIndentedString(this.accountName)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum CurrencyEnum {
        USD("USD"),
        GBP("GBP"),
        EUR("EUR");

        private String value;

        private CurrencyEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static CurrencyEnum fromValue(String value) {
            for (CurrencyEnum b : CurrencyEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }
}

