/*
 * Decompiled with CFR 0.152.
 */
package com.velopayments.oa3.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModelProperty;
import java.time.OffsetDateTime;
import java.util.Objects;
import java.util.UUID;
import javax.annotation.Nullable;
import javax.validation.Valid;
import org.openapitools.jackson.nullable.JsonNullable;

@JsonPropertyOrder(value={"payorId", "remoteId", "invitationStatus", "invitationStatusTimestamp", "paymentChannelId"})
public class PayeePayorRefV2 {
    public static final String JSON_PROPERTY_PAYOR_ID = "payorId";
    private UUID payorId;
    public static final String JSON_PROPERTY_REMOTE_ID = "remoteId";
    private String remoteId;
    public static final String JSON_PROPERTY_INVITATION_STATUS = "invitationStatus";
    private InvitationStatusEnum invitationStatus;
    public static final String JSON_PROPERTY_INVITATION_STATUS_TIMESTAMP = "invitationStatusTimestamp";
    private JsonNullable<OffsetDateTime> invitationStatusTimestamp = JsonNullable.undefined();
    public static final String JSON_PROPERTY_PAYMENT_CHANNEL_ID = "paymentChannelId";
    private UUID paymentChannelId;

    public PayeePayorRefV2 payorId(UUID payorId) {
        this.payorId = payorId;
        return this;
    }

    @Nullable
    @Valid
    @ApiModelProperty(example="ba08877f-9d96-41e4-9c26-44a872d856ae", value="")
    @JsonProperty(value="payorId")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public UUID getPayorId() {
        return this.payorId;
    }

    public void setPayorId(UUID payorId) {
        this.payorId = payorId;
    }

    public PayeePayorRefV2 remoteId(String remoteId) {
        this.remoteId = remoteId;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="uniqueIdForRemoteEntity", value="")
    @JsonProperty(value="remoteId")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getRemoteId() {
        return this.remoteId;
    }

    public void setRemoteId(String remoteId) {
        this.remoteId = remoteId;
    }

    public PayeePayorRefV2 invitationStatus(InvitationStatusEnum invitationStatus) {
        this.invitationStatus = invitationStatus;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="ACCEPTED", value="")
    @JsonProperty(value="invitationStatus")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public InvitationStatusEnum getInvitationStatus() {
        return this.invitationStatus;
    }

    public void setInvitationStatus(InvitationStatusEnum invitationStatus) {
        this.invitationStatus = invitationStatus;
    }

    public PayeePayorRefV2 invitationStatusTimestamp(OffsetDateTime invitationStatusTimestamp) {
        this.invitationStatusTimestamp = JsonNullable.of((Object)invitationStatusTimestamp);
        return this;
    }

    @Nullable
    @Valid
    @ApiModelProperty(example="2019-01-20T09:00Z", value="The timestamp when the invitation status is updated")
    @JsonIgnore
    public OffsetDateTime getInvitationStatusTimestamp() {
        return (OffsetDateTime)this.invitationStatusTimestamp.orElse(null);
    }

    @JsonProperty(value="invitationStatusTimestamp")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public JsonNullable<OffsetDateTime> getInvitationStatusTimestamp_JsonNullable() {
        return this.invitationStatusTimestamp;
    }

    @JsonProperty(value="invitationStatusTimestamp")
    public void setInvitationStatusTimestamp_JsonNullable(JsonNullable<OffsetDateTime> invitationStatusTimestamp) {
        this.invitationStatusTimestamp = invitationStatusTimestamp;
    }

    public void setInvitationStatusTimestamp(OffsetDateTime invitationStatusTimestamp) {
        this.invitationStatusTimestamp = JsonNullable.of((Object)invitationStatusTimestamp);
    }

    public PayeePayorRefV2 paymentChannelId(UUID paymentChannelId) {
        this.paymentChannelId = paymentChannelId;
        return this;
    }

    @Nullable
    @Valid
    @ApiModelProperty(example="70faaff7-2c32-4b44-b27f-f0b6c484e6f3", value="")
    @JsonProperty(value="paymentChannelId")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public UUID getPaymentChannelId() {
        return this.paymentChannelId;
    }

    public void setPaymentChannelId(UUID paymentChannelId) {
        this.paymentChannelId = paymentChannelId;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PayeePayorRefV2 payeePayorRefV2 = (PayeePayorRefV2)o;
        return Objects.equals(this.payorId, payeePayorRefV2.payorId) && Objects.equals(this.remoteId, payeePayorRefV2.remoteId) && Objects.equals((Object)this.invitationStatus, (Object)payeePayorRefV2.invitationStatus) && Objects.equals(this.invitationStatusTimestamp, payeePayorRefV2.invitationStatusTimestamp) && Objects.equals(this.paymentChannelId, payeePayorRefV2.paymentChannelId);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.payorId, this.remoteId, this.invitationStatus, this.invitationStatusTimestamp, this.paymentChannelId});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class PayeePayorRefV2 {\n");
        sb.append("    payorId: ").append(this.toIndentedString(this.payorId)).append("\n");
        sb.append("    remoteId: ").append(this.toIndentedString(this.remoteId)).append("\n");
        sb.append("    invitationStatus: ").append(this.toIndentedString((Object)this.invitationStatus)).append("\n");
        sb.append("    invitationStatusTimestamp: ").append(this.toIndentedString(this.invitationStatusTimestamp)).append("\n");
        sb.append("    paymentChannelId: ").append(this.toIndentedString(this.paymentChannelId)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum InvitationStatusEnum {
        ACCEPTED("ACCEPTED"),
        PENDING("PENDING"),
        DECLINED("DECLINED");

        private String value;

        private InvitationStatusEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static InvitationStatusEnum fromValue(String value) {
            for (InvitationStatusEnum b : InvitationStatusEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }
}

