/*
 * Decompiled with CFR 0.152.
 */
package com.velopayments.oa3.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.swagger.annotations.ApiModelProperty;
import java.net.URI;
import java.util.Objects;
import javax.annotation.Nullable;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import org.openapitools.jackson.nullable.JsonNullable;

@JsonPropertyOrder(value={"payorName", "logoUrl", "collectiveAlias", "supportContact", "dbaName"})
public class PayorBrandingResponse {
    public static final String JSON_PROPERTY_PAYOR_NAME = "payorName";
    private String payorName;
    public static final String JSON_PROPERTY_LOGO_URL = "logoUrl";
    private URI logoUrl;
    public static final String JSON_PROPERTY_COLLECTIVE_ALIAS = "collectiveAlias";
    private JsonNullable<String> collectiveAlias = JsonNullable.undefined();
    public static final String JSON_PROPERTY_SUPPORT_CONTACT = "supportContact";
    private JsonNullable<String> supportContact = JsonNullable.undefined();
    public static final String JSON_PROPERTY_DBA_NAME = "dbaName";
    private JsonNullable<String> dbaName = JsonNullable.undefined();

    public PayorBrandingResponse payorName(String payorName) {
        this.payorName = payorName;
        return this;
    }

    @NotNull
    @ApiModelProperty(example="Key West Imports, Inc", required=true, value="The name of the payor")
    @JsonProperty(value="payorName")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getPayorName() {
        return this.payorName;
    }

    public void setPayorName(String payorName) {
        this.payorName = payorName;
    }

    public PayorBrandingResponse logoUrl(URI logoUrl) {
        this.logoUrl = logoUrl;
        return this;
    }

    @NotNull
    @Valid
    @ApiModelProperty(example="example.com", required=true, value="The URL to use for this payor\u2019s logo")
    @JsonProperty(value="logoUrl")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public URI getLogoUrl() {
        return this.logoUrl;
    }

    public void setLogoUrl(URI logoUrl) {
        this.logoUrl = logoUrl;
    }

    public PayorBrandingResponse collectiveAlias(String collectiveAlias) {
        this.collectiveAlias = JsonNullable.of((Object)collectiveAlias);
        return this;
    }

    @Nullable
    @ApiModelProperty(example="Payee", value="How the payor has chosen to refer to payees")
    @JsonIgnore
    public String getCollectiveAlias() {
        return (String)this.collectiveAlias.orElse(null);
    }

    @JsonProperty(value="collectiveAlias")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public JsonNullable<String> getCollectiveAlias_JsonNullable() {
        return this.collectiveAlias;
    }

    @JsonProperty(value="collectiveAlias")
    public void setCollectiveAlias_JsonNullable(JsonNullable<String> collectiveAlias) {
        this.collectiveAlias = collectiveAlias;
    }

    public void setCollectiveAlias(String collectiveAlias) {
        this.collectiveAlias = JsonNullable.of((Object)collectiveAlias);
    }

    public PayorBrandingResponse supportContact(String supportContact) {
        this.supportContact = JsonNullable.of((Object)supportContact);
        return this;
    }

    @Nullable
    @ApiModelProperty(example="support@example.com", value="The payor\u2019s support contact address")
    @JsonIgnore
    public String getSupportContact() {
        return (String)this.supportContact.orElse(null);
    }

    @JsonProperty(value="supportContact")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public JsonNullable<String> getSupportContact_JsonNullable() {
        return this.supportContact;
    }

    @JsonProperty(value="supportContact")
    public void setSupportContact_JsonNullable(JsonNullable<String> supportContact) {
        this.supportContact = supportContact;
    }

    public void setSupportContact(String supportContact) {
        this.supportContact = JsonNullable.of((Object)supportContact);
    }

    public PayorBrandingResponse dbaName(String dbaName) {
        this.dbaName = JsonNullable.of((Object)dbaName);
        return this;
    }

    @Nullable
    @ApiModelProperty(example="Key West Imports", value="The payor\u2019s 'Doing Business As' name")
    @JsonIgnore
    public String getDbaName() {
        return (String)this.dbaName.orElse(null);
    }

    @JsonProperty(value="dbaName")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public JsonNullable<String> getDbaName_JsonNullable() {
        return this.dbaName;
    }

    @JsonProperty(value="dbaName")
    public void setDbaName_JsonNullable(JsonNullable<String> dbaName) {
        this.dbaName = dbaName;
    }

    public void setDbaName(String dbaName) {
        this.dbaName = JsonNullable.of((Object)dbaName);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PayorBrandingResponse payorBrandingResponse = (PayorBrandingResponse)o;
        return Objects.equals(this.payorName, payorBrandingResponse.payorName) && Objects.equals(this.logoUrl, payorBrandingResponse.logoUrl) && Objects.equals(this.collectiveAlias, payorBrandingResponse.collectiveAlias) && Objects.equals(this.supportContact, payorBrandingResponse.supportContact) && Objects.equals(this.dbaName, payorBrandingResponse.dbaName);
    }

    public int hashCode() {
        return Objects.hash(this.payorName, this.logoUrl, this.collectiveAlias, this.supportContact, this.dbaName);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class PayorBrandingResponse {\n");
        sb.append("    payorName: ").append(this.toIndentedString(this.payorName)).append("\n");
        sb.append("    logoUrl: ").append(this.toIndentedString(this.logoUrl)).append("\n");
        sb.append("    collectiveAlias: ").append(this.toIndentedString(this.collectiveAlias)).append("\n");
        sb.append("    supportContact: ").append(this.toIndentedString(this.supportContact)).append("\n");
        sb.append("    dbaName: ").append(this.toIndentedString(this.dbaName)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

