/*
 * Decompiled with CFR 0.152.
 */
package com.velopayments.oa3.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import javax.annotation.Nullable;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;

@JsonPropertyOrder(value={"remoteId", "currencyType", "amount", "sourceAccountName", "payorPaymentId", "reason", "reasonCode", "lineNumber", "message"})
public class RejectedPayment {
    public static final String JSON_PROPERTY_REMOTE_ID = "remoteId";
    private String remoteId;
    public static final String JSON_PROPERTY_CURRENCY_TYPE = "currencyType";
    private String currencyType;
    public static final String JSON_PROPERTY_AMOUNT = "amount";
    private Integer amount;
    public static final String JSON_PROPERTY_SOURCE_ACCOUNT_NAME = "sourceAccountName";
    private String sourceAccountName;
    public static final String JSON_PROPERTY_PAYOR_PAYMENT_ID = "payorPaymentId";
    private String payorPaymentId;
    public static final String JSON_PROPERTY_REASON = "reason";
    private String reason;
    public static final String JSON_PROPERTY_REASON_CODE = "reasonCode";
    private String reasonCode;
    public static final String JSON_PROPERTY_LINE_NUMBER = "lineNumber";
    private Integer lineNumber;
    public static final String JSON_PROPERTY_MESSAGE = "message";
    private String message;

    public RejectedPayment remoteId(String remoteId) {
        this.remoteId = remoteId;
        return this;
    }

    @NotNull
    @ApiModelProperty(example="remoteIdVal123", required=true, value="")
    @JsonProperty(value="remoteId")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getRemoteId() {
        return this.remoteId;
    }

    public void setRemoteId(String remoteId) {
        this.remoteId = remoteId;
    }

    public RejectedPayment currencyType(String currencyType) {
        this.currencyType = currencyType;
        return this;
    }

    @NotNull
    @Size(min=3, max=3)
    @ApiModelProperty(example="USD", required=true, value="")
    @JsonProperty(value="currencyType")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public @NotNull @Size(min=3, max=3) String getCurrencyType() {
        return this.currencyType;
    }

    public void setCurrencyType(String currencyType) {
        this.currencyType = currencyType;
    }

    public RejectedPayment amount(Integer amount) {
        this.amount = amount;
        return this;
    }

    @NotNull
    @ApiModelProperty(example="1234", required=true, value="")
    @JsonProperty(value="amount")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public Integer getAmount() {
        return this.amount;
    }

    public void setAmount(Integer amount) {
        this.amount = amount;
    }

    public RejectedPayment sourceAccountName(String sourceAccountName) {
        this.sourceAccountName = sourceAccountName;
        return this;
    }

    @NotNull
    @ApiModelProperty(example="Chase", required=true, value="")
    @JsonProperty(value="sourceAccountName")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getSourceAccountName() {
        return this.sourceAccountName;
    }

    public void setSourceAccountName(String sourceAccountName) {
        this.sourceAccountName = sourceAccountName;
    }

    public RejectedPayment payorPaymentId(String payorPaymentId) {
        this.payorPaymentId = payorPaymentId;
        return this;
    }

    @NotNull
    @ApiModelProperty(example="paymenIdVal123123", required=true, value="")
    @JsonProperty(value="payorPaymentId")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getPayorPaymentId() {
        return this.payorPaymentId;
    }

    public void setPayorPaymentId(String payorPaymentId) {
        this.payorPaymentId = payorPaymentId;
    }

    public RejectedPayment reason(String reason) {
        this.reason = reason;
        return this;
    }

    @NotNull
    @ApiModelProperty(example="The payee has not been onboarded", required=true, value="")
    @JsonProperty(value="reason")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getReason() {
        return this.reason;
    }

    public void setReason(String reason) {
        this.reason = reason;
    }

    public RejectedPayment reasonCode(String reasonCode) {
        this.reasonCode = reasonCode;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="PAYMENT_VALUE_TOO_HIGH", value="")
    @JsonProperty(value="reasonCode")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getReasonCode() {
        return this.reasonCode;
    }

    public void setReasonCode(String reasonCode) {
        this.reasonCode = reasonCode;
    }

    public RejectedPayment lineNumber(Integer lineNumber) {
        this.lineNumber = lineNumber;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="10", value="")
    @JsonProperty(value="lineNumber")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Integer getLineNumber() {
        return this.lineNumber;
    }

    public void setLineNumber(Integer lineNumber) {
        this.lineNumber = lineNumber;
    }

    public RejectedPayment message(String message) {
        this.message = message;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="Payment cannot be processed because of the Payee's OFAC or Compliance Status", value="")
    @JsonProperty(value="message")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RejectedPayment rejectedPayment = (RejectedPayment)o;
        return Objects.equals(this.remoteId, rejectedPayment.remoteId) && Objects.equals(this.currencyType, rejectedPayment.currencyType) && Objects.equals(this.amount, rejectedPayment.amount) && Objects.equals(this.sourceAccountName, rejectedPayment.sourceAccountName) && Objects.equals(this.payorPaymentId, rejectedPayment.payorPaymentId) && Objects.equals(this.reason, rejectedPayment.reason) && Objects.equals(this.reasonCode, rejectedPayment.reasonCode) && Objects.equals(this.lineNumber, rejectedPayment.lineNumber) && Objects.equals(this.message, rejectedPayment.message);
    }

    public int hashCode() {
        return Objects.hash(this.remoteId, this.currencyType, this.amount, this.sourceAccountName, this.payorPaymentId, this.reason, this.reasonCode, this.lineNumber, this.message);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class RejectedPayment {\n");
        sb.append("    remoteId: ").append(this.toIndentedString(this.remoteId)).append("\n");
        sb.append("    currencyType: ").append(this.toIndentedString(this.currencyType)).append("\n");
        sb.append("    amount: ").append(this.toIndentedString(this.amount)).append("\n");
        sb.append("    sourceAccountName: ").append(this.toIndentedString(this.sourceAccountName)).append("\n");
        sb.append("    payorPaymentId: ").append(this.toIndentedString(this.payorPaymentId)).append("\n");
        sb.append("    reason: ").append(this.toIndentedString(this.reason)).append("\n");
        sb.append("    reasonCode: ").append(this.toIndentedString(this.reasonCode)).append("\n");
        sb.append("    lineNumber: ").append(this.toIndentedString(this.lineNumber)).append("\n");
        sb.append("    message: ").append(this.toIndentedString(this.message)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

