/*
 * Decompiled with CFR 0.152.
 */
package com.velopayments.oa3.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.velopayments.oa3.model.MFAType;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import javax.annotation.Nullable;
import javax.validation.Valid;
import javax.validation.constraints.Pattern;
import javax.validation.constraints.Size;
import org.openapitools.jackson.nullable.JsonNullable;

@ApiModel(description="<p>All properties are optional</p> <p>Only provided properties will be updated</p> <p>Use null to null out a property that is allowed to be nullable</p> ")
@JsonPropertyOrder(value={"primaryContactNumber", "secondaryContactNumber", "firstName", "lastName", "email", "smsNumber", "mfaType", "verificationCode"})
public class UserDetailsUpdateRequest {
    public static final String JSON_PROPERTY_PRIMARY_CONTACT_NUMBER = "primaryContactNumber";
    private JsonNullable<String> primaryContactNumber = JsonNullable.undefined();
    public static final String JSON_PROPERTY_SECONDARY_CONTACT_NUMBER = "secondaryContactNumber";
    private JsonNullable<String> secondaryContactNumber = JsonNullable.undefined();
    public static final String JSON_PROPERTY_FIRST_NAME = "firstName";
    private JsonNullable<String> firstName = JsonNullable.undefined();
    public static final String JSON_PROPERTY_LAST_NAME = "lastName";
    private JsonNullable<String> lastName = JsonNullable.undefined();
    public static final String JSON_PROPERTY_EMAIL = "email";
    private JsonNullable<String> email = JsonNullable.undefined();
    public static final String JSON_PROPERTY_SMS_NUMBER = "smsNumber";
    private JsonNullable<String> smsNumber = JsonNullable.undefined();
    public static final String JSON_PROPERTY_MFA_TYPE = "mfaType";
    private JsonNullable<MFAType> mfaType = JsonNullable.undefined();
    public static final String JSON_PROPERTY_VERIFICATION_CODE = "verificationCode";
    private JsonNullable<String> verificationCode = JsonNullable.undefined();

    public UserDetailsUpdateRequest primaryContactNumber(String primaryContactNumber) {
        this.primaryContactNumber = JsonNullable.of((Object)primaryContactNumber);
        return this;
    }

    @Nullable
    @Pattern(regexp="^\\+?[1-9]\\d{1,14}$")
    @ApiModelProperty(example="11235555555", value="The main contact number for the user ")
    @JsonIgnore
    public @Pattern(regexp="^\\+?[1-9]\\d{1,14}$") String getPrimaryContactNumber() {
        return (String)this.primaryContactNumber.orElse(null);
    }

    @JsonProperty(value="primaryContactNumber")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public JsonNullable<String> getPrimaryContactNumber_JsonNullable() {
        return this.primaryContactNumber;
    }

    @JsonProperty(value="primaryContactNumber")
    public void setPrimaryContactNumber_JsonNullable(JsonNullable<String> primaryContactNumber) {
        this.primaryContactNumber = primaryContactNumber;
    }

    public void setPrimaryContactNumber(String primaryContactNumber) {
        this.primaryContactNumber = JsonNullable.of((Object)primaryContactNumber);
    }

    public UserDetailsUpdateRequest secondaryContactNumber(String secondaryContactNumber) {
        this.secondaryContactNumber = JsonNullable.of((Object)secondaryContactNumber);
        return this;
    }

    @Nullable
    @Pattern(regexp="^\\+?[1-9]\\d{1,14}$")
    @ApiModelProperty(example="11235555550", value="The secondary contact number for the user ")
    @JsonIgnore
    public @Pattern(regexp="^\\+?[1-9]\\d{1,14}$") String getSecondaryContactNumber() {
        return (String)this.secondaryContactNumber.orElse(null);
    }

    @JsonProperty(value="secondaryContactNumber")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public JsonNullable<String> getSecondaryContactNumber_JsonNullable() {
        return this.secondaryContactNumber;
    }

    @JsonProperty(value="secondaryContactNumber")
    public void setSecondaryContactNumber_JsonNullable(JsonNullable<String> secondaryContactNumber) {
        this.secondaryContactNumber = secondaryContactNumber;
    }

    public void setSecondaryContactNumber(String secondaryContactNumber) {
        this.secondaryContactNumber = JsonNullable.of((Object)secondaryContactNumber);
    }

    public UserDetailsUpdateRequest firstName(String firstName) {
        this.firstName = JsonNullable.of((Object)firstName);
        return this;
    }

    @Nullable
    @Size(min=1, max=128)
    @ApiModelProperty(example="John", value="")
    @JsonIgnore
    public @Size(min=1, max=128) String getFirstName() {
        return (String)this.firstName.orElse(null);
    }

    @JsonProperty(value="firstName")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public JsonNullable<String> getFirstName_JsonNullable() {
        return this.firstName;
    }

    @JsonProperty(value="firstName")
    public void setFirstName_JsonNullable(JsonNullable<String> firstName) {
        this.firstName = firstName;
    }

    public void setFirstName(String firstName) {
        this.firstName = JsonNullable.of((Object)firstName);
    }

    public UserDetailsUpdateRequest lastName(String lastName) {
        this.lastName = JsonNullable.of((Object)lastName);
        return this;
    }

    @Nullable
    @Size(min=1, max=128)
    @ApiModelProperty(example="Doe", value="")
    @JsonIgnore
    public @Size(min=1, max=128) String getLastName() {
        return (String)this.lastName.orElse(null);
    }

    @JsonProperty(value="lastName")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public JsonNullable<String> getLastName_JsonNullable() {
        return this.lastName;
    }

    @JsonProperty(value="lastName")
    public void setLastName_JsonNullable(JsonNullable<String> lastName) {
        this.lastName = lastName;
    }

    public void setLastName(String lastName) {
        this.lastName = JsonNullable.of((Object)lastName);
    }

    public UserDetailsUpdateRequest email(String email) {
        this.email = JsonNullable.of((Object)email);
        return this;
    }

    @Nullable
    @ApiModelProperty(example="foo@example.com", value="the email address of the user")
    @JsonIgnore
    public String getEmail() {
        return (String)this.email.orElse(null);
    }

    @JsonProperty(value="email")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public JsonNullable<String> getEmail_JsonNullable() {
        return this.email;
    }

    @JsonProperty(value="email")
    public void setEmail_JsonNullable(JsonNullable<String> email) {
        this.email = email;
    }

    public void setEmail(String email) {
        this.email = JsonNullable.of((Object)email);
    }

    public UserDetailsUpdateRequest smsNumber(String smsNumber) {
        this.smsNumber = JsonNullable.of((Object)smsNumber);
        return this;
    }

    @Nullable
    @Pattern(regexp="^\\+?[1-9]\\d{1,14}$")
    @ApiModelProperty(example="11235555555", value="The phone number of a device that the user can receive sms messages on ")
    @JsonIgnore
    public @Pattern(regexp="^\\+?[1-9]\\d{1,14}$") String getSmsNumber() {
        return (String)this.smsNumber.orElse(null);
    }

    @JsonProperty(value="smsNumber")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public JsonNullable<String> getSmsNumber_JsonNullable() {
        return this.smsNumber;
    }

    @JsonProperty(value="smsNumber")
    public void setSmsNumber_JsonNullable(JsonNullable<String> smsNumber) {
        this.smsNumber = smsNumber;
    }

    public void setSmsNumber(String smsNumber) {
        this.smsNumber = JsonNullable.of((Object)smsNumber);
    }

    public UserDetailsUpdateRequest mfaType(MFAType mfaType) {
        this.mfaType = JsonNullable.of((Object)((Object)mfaType));
        return this;
    }

    @Nullable
    @Valid
    @ApiModelProperty(value="")
    @JsonIgnore
    public MFAType getMfaType() {
        return (MFAType)((Object)this.mfaType.orElse(null));
    }

    @JsonProperty(value="mfaType")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public JsonNullable<MFAType> getMfaType_JsonNullable() {
        return this.mfaType;
    }

    @JsonProperty(value="mfaType")
    public void setMfaType_JsonNullable(JsonNullable<MFAType> mfaType) {
        this.mfaType = mfaType;
    }

    public void setMfaType(MFAType mfaType) {
        this.mfaType = JsonNullable.of((Object)((Object)mfaType));
    }

    public UserDetailsUpdateRequest verificationCode(String verificationCode) {
        this.verificationCode = JsonNullable.of((Object)verificationCode);
        return this;
    }

    @Nullable
    @Size(min=6, max=6)
    @ApiModelProperty(example="123456", value="<p>Optional property that MUST be suppied when manually verifying a user</p> <p>The user's smsNumber is registered via a separate endpoint and an OTP sent to them</p> ")
    @JsonIgnore
    public @Size(min=6, max=6) String getVerificationCode() {
        return (String)this.verificationCode.orElse(null);
    }

    @JsonProperty(value="verificationCode")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public JsonNullable<String> getVerificationCode_JsonNullable() {
        return this.verificationCode;
    }

    @JsonProperty(value="verificationCode")
    public void setVerificationCode_JsonNullable(JsonNullable<String> verificationCode) {
        this.verificationCode = verificationCode;
    }

    public void setVerificationCode(String verificationCode) {
        this.verificationCode = JsonNullable.of((Object)verificationCode);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        UserDetailsUpdateRequest userDetailsUpdateRequest = (UserDetailsUpdateRequest)o;
        return Objects.equals(this.primaryContactNumber, userDetailsUpdateRequest.primaryContactNumber) && Objects.equals(this.secondaryContactNumber, userDetailsUpdateRequest.secondaryContactNumber) && Objects.equals(this.firstName, userDetailsUpdateRequest.firstName) && Objects.equals(this.lastName, userDetailsUpdateRequest.lastName) && Objects.equals(this.email, userDetailsUpdateRequest.email) && Objects.equals(this.smsNumber, userDetailsUpdateRequest.smsNumber) && Objects.equals(this.mfaType, userDetailsUpdateRequest.mfaType) && Objects.equals(this.verificationCode, userDetailsUpdateRequest.verificationCode);
    }

    public int hashCode() {
        return Objects.hash(this.primaryContactNumber, this.secondaryContactNumber, this.firstName, this.lastName, this.email, this.smsNumber, this.mfaType, this.verificationCode);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class UserDetailsUpdateRequest {\n");
        sb.append("    primaryContactNumber: ").append(this.toIndentedString(this.primaryContactNumber)).append("\n");
        sb.append("    secondaryContactNumber: ").append(this.toIndentedString(this.secondaryContactNumber)).append("\n");
        sb.append("    firstName: ").append(this.toIndentedString(this.firstName)).append("\n");
        sb.append("    lastName: ").append(this.toIndentedString(this.lastName)).append("\n");
        sb.append("    email: ").append(this.toIndentedString(this.email)).append("\n");
        sb.append("    smsNumber: ").append(this.toIndentedString(this.smsNumber)).append("\n");
        sb.append("    mfaType: ").append(this.toIndentedString(this.mfaType)).append("\n");
        sb.append("    verificationCode: ").append(this.toIndentedString(this.verificationCode)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

