/*
 * Decompiled with CFR 0.152.
 */
package com.versionone.om;

import com.versionone.om.AssetID;
import com.versionone.om.BaseAsset;
import com.versionone.om.Conversation;
import com.versionone.om.Effort;
import com.versionone.om.Epic;
import com.versionone.om.Expression;
import com.versionone.om.Issue;
import com.versionone.om.MetaDataAttribute;
import com.versionone.om.PrimaryWorkitem;
import com.versionone.om.Project;
import com.versionone.om.Request;
import com.versionone.om.Role;
import com.versionone.om.SecondaryWorkitem;
import com.versionone.om.Theme;
import com.versionone.om.V1Instance;
import com.versionone.om.filters.EffortFilter;
import com.versionone.om.filters.EpicFilter;
import com.versionone.om.filters.IssueFilter;
import com.versionone.om.filters.PrimaryWorkitemFilter;
import com.versionone.om.filters.RequestFilter;
import com.versionone.om.filters.SecondaryWorkitemFilter;
import com.versionone.om.filters.ThemeFilter;
import com.versionone.om.filters.WorkitemFilter;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@MetaDataAttribute(value="Member")
public class Member
extends BaseAsset {
    private static final String NICKNAME_VALUE = "Nickname";
    private static final String DEFAULT_ROLE_VALUE = "DefaultRole";

    Member(AssetID id, V1Instance instance) {
        super(id, instance);
    }

    Member(V1Instance instance) {
        super(instance);
    }

    public String getShortName() {
        return (String)this.get(NICKNAME_VALUE);
    }

    public void setShortName(String shortName) {
        this.set(NICKNAME_VALUE, shortName);
    }

    public Role getDefaultRole() {
        return this.getRelation(Role.class, DEFAULT_ROLE_VALUE);
    }

    public void setDefaultRole(Role defaultRole) {
        this.setRelation(DEFAULT_ROLE_VALUE, defaultRole);
    }

    public String getUsername() {
        return (String)this.get("Username");
    }

    public void setUsername(String value) {
        this.set("Username", value);
    }

    public void setPassword(String value) {
        this.set("Password", value);
    }

    public String getEmail() {
        return (String)this.get("Email");
    }

    public void setEmail(String value) {
        this.set("Email", value);
    }

    public String getPhone() {
        return (String)this.get("Phone");
    }

    public void setPhone(String value) {
        this.set("Phone", value);
    }

    public Collection<Project> getAssignedProjects() {
        return this.getMultiRelation("Scopes");
    }

    public Collection<Expression> getExpressions() {
        return this.getMultiRelation("Expressions");
    }

    public Collection<PrimaryWorkitem> getOwnedPrimaryWorkitems(PrimaryWorkitemFilter filter) {
        filter = filter != null ? filter : new PrimaryWorkitemFilter();
        filter.owners.clear();
        filter.owners.add(this);
        return this.getInstance().get().primaryWorkitems(filter);
    }

    public Collection<SecondaryWorkitem> getOwnedSecondaryWorkitems(SecondaryWorkitemFilter filter) {
        filter = filter != null ? filter : new SecondaryWorkitemFilter();
        filter.owners.clear();
        filter.owners.add(this);
        return this.getInstance().get().secondaryWorkitems(filter);
    }

    public Collection<Theme> getOwnedThemes(ThemeFilter filter) {
        filter = filter != null ? filter : new ThemeFilter();
        filter.owners.clear();
        filter.owners.add(this);
        return this.getInstance().get().themes(filter);
    }

    public Collection<Issue> getOwnedIssues(IssueFilter filter) {
        filter = filter != null ? filter : new IssueFilter();
        filter.owner.clear();
        filter.owner.add(this);
        return this.getInstance().get().issues(filter);
    }

    public Collection<Request> getOwnedRequests(RequestFilter filter) {
        filter = filter != null ? filter : new RequestFilter();
        filter.owner.clear();
        filter.owner.add(this);
        return this.getInstance().get().requests(filter);
    }

    public Collection<Epic> getOwnedEpics(EpicFilter filter) {
        filter = filter != null ? filter : new EpicFilter();
        filter.owners.clear();
        filter.owners.add(this);
        return this.getInstance().get().epics(filter);
    }

    public Collection<Effort> getEffortRecords(EffortFilter filter) {
        filter = filter != null ? filter : new EffortFilter();
        filter.member.clear();
        filter.member.add(this);
        return this.getInstance().get().effortRecords(filter);
    }

    @Override
    void closeImpl() throws UnsupportedOperationException {
        this.getInstance().executeOperation(this, "Inactivate");
    }

    @Override
    void reactivateImpl() throws UnsupportedOperationException {
        this.getInstance().executeOperation(this, "Reactivate");
    }

    public Double getTotalEstimate(PrimaryWorkitemFilter filter) {
        filter = filter != null ? filter : new PrimaryWorkitemFilter();
        return this.getSum("OwnedWorkitems:PrimaryWorkitem", filter, "Estimate");
    }

    public Double getTotalDetailEstimate(WorkitemFilter filter) {
        filter = filter != null ? filter : new WorkitemFilter();
        return this.getSum("OwnedWorkitems", filter, "DetailEstimate");
    }

    public Double getTotalToDo(WorkitemFilter filter) {
        filter = filter != null ? filter : new WorkitemFilter();
        return this.getSum("OwnedWorkitems", filter, "ToDo");
    }

    public Double getTotalDone(WorkitemFilter filter) {
        filter = filter != null ? filter : new WorkitemFilter();
        return this.getSum("OwnedWorkitems", filter, "Actuals.Value");
    }

    @Override
    public Conversation createConversation(Member author, String content) {
        Conversation conversation = this.getInstance().create().conversation(author, content);
        Iterator<Expression> expressionIterator = conversation.getContainedExpressions().iterator();
        if (expressionIterator.hasNext()) {
            expressionIterator.next().getMentions().add(this);
            conversation.save();
        }
        return conversation;
    }

    @Override
    public Conversation createConversation(Member author, String content, Map<String, Object> attributes) {
        Conversation conversation = this.getInstance().create().conversation(author, content, attributes);
        Iterator<Expression> expressionIterator = conversation.getContainedExpressions().iterator();
        if (expressionIterator.hasNext()) {
            expressionIterator.next().getMentions().add(this);
            conversation.save();
        }
        conversation.save();
        return conversation;
    }

    public Conversation createConversation(String content) {
        Conversation conversation = this.getInstance().create().conversation(this, content);
        return conversation;
    }

    public boolean getNotifyViaEmail() {
        return (Boolean)this.get("NotifyViaEmail");
    }

    public void setNotifyViaEmail(boolean value) {
        this.set("NotifyViaEmail", value);
    }

    public boolean getSendConversationEmails() {
        return (Boolean)this.get("SendConversationEmails");
    }

    public void setSendConversationEmails(boolean status) {
        this.set("SendConversationEmails", status);
    }
}

