/*
 * Decompiled with CFR 0.152.
 */
package com.victorsima.uber;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.squareup.okhttp.OkHttpClient;
import com.victorsima.uber.UberAuthService;
import com.victorsima.uber.UberService;
import com.victorsima.uber.exception.ForbiddenException;
import com.victorsima.uber.exception.UnauthorizedException;
import com.victorsima.uber.model.AccessToken;
import retrofit.Callback;
import retrofit.ErrorHandler;
import retrofit.RequestInterceptor;
import retrofit.RestAdapter;
import retrofit.RetrofitError;
import retrofit.client.Client;
import retrofit.client.OkClient;
import retrofit.client.Response;
import retrofit.converter.Converter;
import retrofit.converter.GsonConverter;

public class UberClient {
    private String version;
    private String accessToken;
    private String serverToken;
    private String clientId;
    private String clientSecret;
    private UberService apiService;
    private UberAuthService authService;
    private Gson gson;

    public UberClient(String version, String clientId, String clientSecret, RestAdapter.LogLevel logLevel) {
        this(version, clientId, clientSecret, null, logLevel);
    }

    public UberClient(String version, String clientId, String clientSecret, Client client, RestAdapter.LogLevel logLevel) {
        this.version = version;
        this.clientId = clientId;
        this.clientSecret = clientSecret;
        GsonBuilder gsonBuilder = new GsonBuilder().excludeFieldsWithoutExposeAnnotation().setDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'");
        OkHttpClient okHttpClient = new OkHttpClient();
        this.gson = gsonBuilder.create();
        RestAdapter restAdapter = new RestAdapter.Builder().setEndpoint("https://api.uber.com/" + version).setRequestInterceptor(new RequestInterceptor(){

            public void intercept(RequestInterceptor.RequestFacade requestFacade) {
                if (UberClient.this.hasAccessToken()) {
                    requestFacade.addHeader("Authorization", "Bearer " + UberClient.this.accessToken);
                    return;
                }
                if (UberClient.this.hasServerToken()) {
                    requestFacade.addHeader("Authorization", "Token " + UberClient.this.serverToken);
                }
            }
        }).setErrorHandler(new ErrorHandler(){

            public Throwable handleError(RetrofitError retrofitError) {
                switch (retrofitError.getResponse().getStatus()) {
                    case 401: {
                        return new UnauthorizedException();
                    }
                    case 403: {
                        return new ForbiddenException();
                    }
                }
                return null;
            }
        }).setLogLevel(logLevel).setClient((Client)(client == null ? new OkClient(okHttpClient) : client)).setConverter((Converter)new GsonConverter(this.gson)).build();
        this.apiService = (UberService)restAdapter.create(UberService.class);
        RestAdapter authRestAdapter = new RestAdapter.Builder().setEndpoint("https://login.uber.com").setLogLevel(logLevel).setClient((Client)(client == null ? new OkClient(okHttpClient) : client)).setConverter((Converter)new GsonConverter(gsonBuilder.create())).build();
        this.authService = (UberAuthService)authRestAdapter.create(UberAuthService.class);
    }

    public boolean hasAccessToken() {
        return this.accessToken != null && this.accessToken.length() > 0;
    }

    public String getAccessToken() {
        return this.accessToken;
    }

    public void setAccessToken(String accessToken) {
        this.accessToken = accessToken;
    }

    public boolean hasServerToken() {
        return this.serverToken != null && this.serverToken.length() > 0;
    }

    public String getServerToken() {
        return this.serverToken;
    }

    public void setServerToken(String serverToken) {
        this.serverToken = serverToken;
    }

    public UberService getApiService() {
        return this.apiService;
    }

    public void requestAccessToken(String code, final Callback<AccessToken> callback) {
        this.authService.requestAccessToken(this.clientId, this.clientSecret, code, "authorization_code", new Callback<AccessToken>(){

            public void success(AccessToken accessToken, Response response) {
                UberClient.this.accessToken = accessToken.getAccessToken();
                callback.success((Object)accessToken, response);
            }

            public void failure(RetrofitError error) {
                this.failure(error);
            }
        });
    }
}

