/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.loginsightapi;

import com.vmware.loginsightapi.core.FieldConstraint;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;

public class ConstraintBuilder {
    List<FieldConstraint> constraints = new ArrayList<FieldConstraint>();

    public ConstraintBuilder eq(String field, String value) {
        this.constraints.add(FieldConstraint.eq(field, value));
        return this;
    }

    public ConstraintBuilder ne(String field, String value) {
        this.constraints.add(FieldConstraint.ne(field, value));
        return this;
    }

    public ConstraintBuilder lt(String field, String value) {
        this.constraints.add(FieldConstraint.lt(field, value));
        return this;
    }

    public ConstraintBuilder le(String field, String value) {
        this.constraints.add(FieldConstraint.le(field, value));
        return this;
    }

    public ConstraintBuilder gt(String field, String value) {
        this.constraints.add(FieldConstraint.gt(field, value));
        return this;
    }

    public ConstraintBuilder ge(String field, String value) {
        this.constraints.add(FieldConstraint.ge(field, value));
        return this;
    }

    public ConstraintBuilder contains(String field, String value) {
        this.constraints.add(FieldConstraint.contains(field, value));
        return this;
    }

    public ConstraintBuilder notContains(String field, String value) {
        this.constraints.add(FieldConstraint.notContains(field, value));
        return this;
    }

    public ConstraintBuilder has(String field, String value) {
        this.constraints.add(FieldConstraint.has(field, value));
        return this;
    }

    public ConstraintBuilder notHas(String field, String value) {
        this.constraints.add(FieldConstraint.notHas(field, value));
        return this;
    }

    public ConstraintBuilder matchesRegex(String field, String value) {
        this.constraints.add(FieldConstraint.matchesRegex(field, value));
        return this;
    }

    public ConstraintBuilder notMatchesRegex(String field, String value) {
        this.constraints.add(FieldConstraint.notMatchesRegex(field, value));
        return this;
    }

    public List<FieldConstraint> build() {
        return this.constraints;
    }

    public String buildPathSegment() {
        String expression = this.constraints.stream().map(constraint -> {
            try {
                return constraint.toExpressionEncoded();
            }
            catch (UnsupportedEncodingException ex) {
                throw new RuntimeException("Unable to encode the field constraint " + constraint.toExpression());
            }
        }).collect(Collectors.joining("/"));
        return expression;
    }
}

