/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vipclient.i18n.messages.api.opt.server;

import com.vmware.vipclient.i18n.VIPCfg;
import com.vmware.vipclient.i18n.messages.api.url.V2URL;
import com.vmware.vipclient.i18n.util.JSONUtils;
import java.util.HashMap;
import java.util.Map;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.json.simple.JSONValue;
import org.json.simple.parser.ParseException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LocaleOpt {
    private Logger logger = LoggerFactory.getLogger((String)LocaleOpt.class.getName());

    public Map<String, String> getTerritoriesFromCLDR(String language) {
        String responseData = VIPCfg.getInstance().getVipService().getHttpRequester().request(V2URL.getRegionListURL(language, VIPCfg.getInstance().getVipService().getHttpRequester().getBaseURL()), "GET", null);
        Map respMap = null;
        try {
            JSONObject jsonObject = (JSONObject)JSONValue.parseWithException((String)responseData);
            JSONArray jsonArray = (JSONArray)jsonObject.get((Object)"data");
            if (jsonArray != null && !jsonArray.isEmpty()) {
                Map<String, Object> regionMap = JSONUtils.getMapFromJson(jsonArray.get(0).toString());
                respMap = (Map)regionMap.get("territories");
            }
        }
        catch (ParseException e) {
            this.logger.error(e.getMessage());
        }
        return respMap;
    }

    public Map<String, String> getDisplayNamesFromCLDR(String language) {
        String responseData = VIPCfg.getInstance().getVipService().getHttpRequester().request(V2URL.getSupportedLanguageListURL(language, VIPCfg.getInstance().getVipService().getHttpRequester().getBaseURL()), "GET", null);
        HashMap<String, String> dispMap = null;
        try {
            JSONObject jsonObject = (JSONObject)JSONValue.parseWithException((String)responseData);
            Object data = jsonObject.get((Object)"data");
            if (data == null || "".equals(data)) {
                return dispMap;
            }
            JSONObject jsonData = (JSONObject)data;
            JSONArray jsonArray = (JSONArray)jsonData.get((Object)"languages");
            if (jsonArray != null && !jsonArray.isEmpty()) {
                dispMap = new HashMap<String, String>();
                for (int i = 0; i < jsonArray.size(); ++i) {
                    Map<String, Object> tmpMap = JSONUtils.getMapFromJson(jsonArray.get(i).toString());
                    dispMap.put(tmpMap.get("languageTag").toString(), tmpMap.get("displayName").toString());
                }
            }
        }
        catch (ParseException e) {
            this.logger.error(e.getMessage());
        }
        return dispMap;
    }
}

