/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vipclient.i18n.l2.text;

import com.vmware.vipclient.i18n.l2.common.PatternCategory;
import com.vmware.vipclient.i18n.l2.number.parser.IntegerDigitsParser;
import com.vmware.vipclient.i18n.l2.text.NumberFormat;
import com.vmware.vipclient.i18n.l2.text.NumberPatternInfo;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.HashMap;
import org.json.simple.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DecimalFormat
extends NumberFormat {
    Logger logger = LoggerFactory.getLogger(DecimalFormat.class);
    private JSONObject numberSymbols;
    private String pattern;
    private int style;
    private JSONObject fractionData;

    public DecimalFormat(JSONObject formatData, int style) {
        JSONObject numberFormats;
        if (style == 1) {
            this.numberSymbols = (JSONObject)((HashMap)formatData.get((Object)PatternCategory.NUMBERS.toString())).get("numberSymbols");
            numberFormats = (JSONObject)((HashMap)formatData.get((Object)PatternCategory.NUMBERS.toString())).get("numberFormats");
            this.fractionData = (JSONObject)formatData.get((Object)"fraction");
        } else {
            this.numberSymbols = (JSONObject)formatData.get((Object)"numberSymbols");
            numberFormats = (JSONObject)formatData.get((Object)"numberFormats");
        }
        this.pattern = DecimalFormat.getPattern(numberFormats, style);
        this.style = style;
    }

    @Override
    public String format(long value, Integer fractionSize) {
        return this.parseNumber(String.valueOf(value), fractionSize);
    }

    @Override
    public String format(double value, Integer fractionSize) {
        return this.parseNumber(String.valueOf(value), fractionSize);
    }

    @Override
    public String format(BigInteger value, Integer fractionSize) {
        return this.parseNumber(String.valueOf(value), fractionSize);
    }

    @Override
    public String format(BigDecimal value, Integer fractionSize) {
        return this.parseNumber(String.valueOf(value), fractionSize);
    }

    @Override
    public String format(String value, Integer fractionSize) {
        return this.parseNumber(value, fractionSize);
    }

    public NumberPatternInfo parsePattern(String pattern) {
        char ch;
        String positivePattern;
        NumberPatternInfo patternInfo = new NumberPatternInfo();
        String[] patternParts = new String[2];
        String negativePattern = null;
        if (pattern.indexOf(";") >= 0) {
            patternParts = pattern.split(";");
            positivePattern = patternParts[0];
            negativePattern = patternParts[1];
        } else {
            positivePattern = pattern;
        }
        String[] positiveParts = new String[2];
        if (positivePattern.indexOf(".") >= 0) {
            positiveParts = positivePattern.split("\\.");
        } else if (positivePattern.indexOf(69) >= 0) {
            positiveParts[0] = positivePattern.substring(0, positivePattern.indexOf(69));
            positiveParts[1] = positivePattern.substring(positivePattern.indexOf(69));
        } else {
            positiveParts[0] = positivePattern.substring(0, positivePattern.lastIndexOf(48) + 1);
            positiveParts[1] = positivePattern.substring(positivePattern.lastIndexOf(48) + 1);
        }
        String integerPattern = positiveParts[0];
        String fractionPattern = positiveParts[1];
        String posPrefix = "";
        for (int i = 0; i < integerPattern.length() && '0' != (ch = integerPattern.charAt(i)) && '#' != ch; ++i) {
            posPrefix = posPrefix + ch;
        }
        integerPattern = !"".equals(posPrefix) ? integerPattern.substring(posPrefix.length()) : integerPattern;
        int groupSize = 0;
        int groupSize2 = 0;
        if (integerPattern.indexOf(",") >= 0) {
            groupSize = integerPattern.length() - 1 - integerPattern.lastIndexOf(",");
            String[] integerParts = integerPattern.split(",");
            groupSize2 = integerParts.length > 2 ? integerParts[integerParts.length - 2].length() : 0;
        }
        int maxIntegerDigit = 0;
        int minIntegerDigit = 0;
        if (integerPattern.indexOf(48) >= 0) {
            minIntegerDigit = integerPattern.length() - integerPattern.indexOf(48);
            if ('0' == integerPattern.charAt(0)) {
                maxIntegerDigit = minIntegerDigit;
            }
        }
        String posSuffix = "";
        int minFractionDigits = 0;
        int maxFractionDigits = 0;
        if (fractionPattern != null && !"".equals(fractionPattern)) {
            for (int i = 0; i < fractionPattern.length(); ++i) {
                char ch2 = fractionPattern.charAt(i);
                if (ch2 == '0') {
                    minFractionDigits = i + 1;
                    continue;
                }
                if (ch2 == '#') {
                    maxFractionDigits = i + 1;
                    continue;
                }
                if (ch2 == 'E') {
                    posSuffix = fractionPattern.substring(i);
                    break;
                }
                posSuffix = posSuffix + ch2;
            }
            if (maxFractionDigits < minFractionDigits) {
                maxFractionDigits = minFractionDigits;
            }
        }
        patternInfo.setPositivePrefix(posPrefix);
        patternInfo.setPositiveSuffix(posSuffix);
        patternInfo.setMinimumIntegerDigits(minIntegerDigit);
        patternInfo.setMaximumIntegerDigits(maxIntegerDigit);
        patternInfo.setMinimumFractionDigits(minFractionDigits);
        patternInfo.setMaximumFractionDigits(maxFractionDigits);
        patternInfo.setGroupingSize(groupSize);
        patternInfo.setSecondaryGroupingSize(groupSize2);
        String negPrefix = "";
        String negSuffix = "";
        if (negativePattern != null && !"".equals(negativePattern)) {
            char ch3;
            int i;
            String[] negativeParts = new String[2];
            if (negativePattern.indexOf(".") > 0) {
                negativeParts = negativePattern.split("\\.");
            } else {
                negativeParts[0] = negativePattern.substring(0, positivePattern.lastIndexOf(48) + 1);
                negativeParts[1] = negativePattern.substring(positivePattern.lastIndexOf(48) + 1);
            }
            String negIntegerPattern = negativeParts[0];
            String negFractionPattern = negativeParts[1];
            for (i = 0; i < negIntegerPattern.length() && '0' != (ch3 = negIntegerPattern.charAt(i)) && '#' != ch3; ++i) {
                negPrefix = negPrefix + ch3;
            }
            for (i = 0; i < negFractionPattern.length(); ++i) {
                ch3 = negFractionPattern.charAt(i);
                if (ch3 == '0' || ch3 == '#') continue;
                negSuffix = negSuffix + ch3;
            }
        } else {
            negPrefix = "-" + patternInfo.getPositivePrefix();
            negSuffix = patternInfo.getPositiveSuffix();
        }
        patternInfo.setNegativePrefix(negPrefix);
        patternInfo.setNegativeSuffix(negSuffix);
        return patternInfo;
    }

    public String parseNumber(String numStr, Integer customizedFractionSize) {
        StringBuilder localizedNumStr = new StringBuilder();
        NumberPatternInfo patternInfo = null;
        try {
            patternInfo = this.parsePattern(this.pattern);
            if (this.style == 1) {
                this.adjustFraction4Currency(patternInfo);
            }
        }
        catch (Exception e) {
            this.logger.error(e.getMessage());
            return "";
        }
        int fractionLength = 0;
        if (numStr.indexOf(".") > 0) {
            fractionLength = numStr.length() - 1 - numStr.indexOf(".");
        }
        if (customizedFractionSize == null) {
            if (fractionLength < patternInfo.getMinimumFractionDigits()) {
                fractionLength = patternInfo.getMinimumFractionDigits();
            } else if (fractionLength > patternInfo.getMaximumFractionDigits()) {
                fractionLength = patternInfo.getMaximumFractionDigits();
            }
        } else {
            fractionLength = customizedFractionSize;
        }
        BigDecimal b = new BigDecimal(numStr);
        boolean isNegative = this.isNegative(b.doubleValue());
        if (!isNegative) {
            localizedNumStr.append(patternInfo.getPositivePrefix());
        } else {
            localizedNumStr.append(patternInfo.getNegativePrefix());
        }
        b = b.abs();
        numStr = b.toString();
        numStr = this.style == 2 ? b.multiply(new BigDecimal(100)).setScale(fractionLength, 4).toString() : b.setScale(fractionLength, 6).toString();
        String[] numArray = numStr.toString().split("\\.");
        IntegerDigitsParser parser = new IntegerDigitsParser(this.numberSymbols);
        String groupedIntegerDigits = parser.groupIntegerDigits(numArray[0], patternInfo.getGroupingSize());
        localizedNumStr.append(groupedIntegerDigits);
        String localizedDecimalSep = (String)this.numberSymbols.get((Object)"decimal");
        if (numArray.length > 1) {
            localizedNumStr.append(localizedDecimalSep).append(numArray[1]);
        }
        if (!isNegative) {
            localizedNumStr.append(patternInfo.getPositiveSuffix());
        } else {
            localizedNumStr.append(patternInfo.getNegativeSuffix());
        }
        return localizedNumStr.toString();
    }

    private void adjustFraction4Currency(NumberPatternInfo patternInfo) {
        if (this.fractionData != null) {
            int round = Integer.parseInt((String)this.fractionData.get((Object)"_rounding"));
            int digits = Integer.parseInt((String)this.fractionData.get((Object)"_digits"));
            int oldMinDigits = patternInfo.getMinimumFractionDigits();
            if (oldMinDigits == patternInfo.getMaximumFractionDigits()) {
                patternInfo.setMinimumFractionDigits(digits);
                patternInfo.setMaximumFractionDigits(digits);
            } else {
                patternInfo.setMinimumFractionDigits(Math.min(digits, oldMinDigits));
                patternInfo.setMaximumFractionDigits(digits);
            }
        }
    }

    private boolean isNegative(double number) {
        return number < 0.0 || number == 0.0 && 1.0 / number < 0.0;
    }
}

