/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vipclient.i18n.base;

import com.vmware.vipclient.i18n.messages.api.url.URLUtils;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.cert.X509Certificate;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.KeyManager;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpRequester {
    static Logger logger = LoggerFactory.getLogger(HttpRequester.class);
    private static SSLSocketFactory sslSocketFactory;
    private String vipHostName;
    private String baseURL;
    private Map<String, String> commonHeaderParams = null;

    public void setCustomizedHeaderParams(Map<String, String> params) {
        this.commonHeaderParams = params;
    }

    public void setBaseURL(String baseURL) {
        this.baseURL = baseURL;
    }

    protected HttpRequester(String vIPServer) throws MalformedURLException {
        if (null != vIPServer && vIPServer.length() > 0) {
            if (!vIPServer.trim().startsWith("http://") && !vIPServer.trim().startsWith("https://")) {
                vIPServer = "https://".concat(vIPServer);
            }
            URL url = new URL(vIPServer);
            this.baseURL = url.toString();
            this.vipHostName = url.getHost();
        }
    }

    protected static boolean ping(String ipAddress) {
        boolean status = false;
        try {
            status = InetAddress.getByName(ipAddress).isReachable(5000);
        }
        catch (IOException e) {
            return false;
        }
        return status;
    }

    public Map<String, Object> request(String url, String method, Object requestData) {
        return this.request(url, method, requestData, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, Object> request(String url, String method, Object requestData, Map<String, String> customizedHeaderParams) {
        HashMap<String, Object> response = new HashMap<String, Object>();
        String r = "";
        HttpURLConnection conn = null;
        try {
            StringBuilder urlStr = new StringBuilder();
            if ("GET".equalsIgnoreCase(method) && requestData != null) {
                if (requestData instanceof Map) {
                    urlStr.append(URLUtils.appendParamToURL(new StringBuilder(url), "", this.getFormStr((Map)requestData)));
                }
            } else {
                urlStr.append(url);
            }
            logger.info("[" + method + "]" + urlStr.toString());
            conn = this.createConnection(urlStr.toString(), customizedHeaderParams);
            if (conn != null) {
                conn.setRequestMethod(method);
                if ("POST".equalsIgnoreCase(method)) {
                    this.writeData(requestData, conn);
                } else {
                    conn.connect();
                }
                switch (conn.getResponseCode()) {
                    case 304: {
                        break;
                    }
                    case 200: {
                        r = this.handleResult(conn);
                        response.put("body", r);
                    }
                }
                response.put("headers", conn.getHeaderFields());
                response.put("response_code", conn.getResponseCode());
                response.put("response_msg", conn.getResponseMessage());
                response.put("response_timestamp", System.currentTimeMillis());
                Long maxAgeMillis = URLUtils.getMaxAgeMillis(conn.getHeaderFields());
                if (maxAgeMillis != null) {
                    response.put("max-age", maxAgeMillis);
                }
            }
        }
        catch (IOException e) {
            logger.info(e.getMessage());
        }
        finally {
            if (conn != null) {
                conn.disconnect();
                conn = null;
            }
        }
        return response;
    }

    public String getBaseURL() {
        return this.baseURL;
    }

    private String handleResult(HttpURLConnection conn) throws IOException {
        InputStream is = conn.getInputStream();
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        byte[] buffer = new byte[1024];
        int len = 0;
        while (-1 != (len = is.read(buffer))) {
            baos.write(buffer, 0, len);
            baos.flush();
        }
        baos.close();
        is.close();
        return baos.toString("utf-8");
    }

    private void writeData(Object requestData, HttpURLConnection conn) throws IOException {
        if (requestData != null) {
            String outStr = "";
            if (requestData instanceof Map) {
                conn.setRequestProperty("Content-Type", "application/x-www-form-urlencoded;charset=utf-8");
                outStr = this.getFormStr((Map)requestData);
                logger.info("[Content-Type][form]" + outStr + "");
            } else if (requestData instanceof String) {
                outStr = requestData.toString();
                conn.setRequestProperty("Content-Type", "application/json;charset=utf-8");
                logger.info("[Content-Type[json]" + outStr + "");
            }
            conn.connect();
            OutputStream p = conn.getOutputStream();
            p.write(outStr.getBytes("utf-8"));
            p.flush();
            p.close();
        }
    }

    private String getFormStr(Map<String, String> params) {
        StringBuilder p = new StringBuilder();
        if (params != null) {
            Set<Map.Entry<String, String>> entrySet = params.entrySet();
            for (Map.Entry<String, String> me : entrySet) {
                String key = me.getKey();
                String value = me.getValue();
                p.append("&").append(key).append("=").append(value);
            }
        }
        if (p.length() > 0) {
            return p.substring(1, p.length());
        }
        return p.toString();
    }

    private HttpURLConnection createConnection(String path, Map<String, String> customizedHeaderParams) {
        URLConnection connection = null;
        try {
            URL url = new URL(path.trim());
            assert (null != url);
            assert ("http".equals(url.getProtocol()) || "https".equals(url.getProtocol()));
            connection = (HttpURLConnection)url.openConnection();
            if (connection instanceof HttpsURLConnection) {
                HttpsURLConnection httpsConn = (HttpsURLConnection)connection;
                httpsConn.setHostnameVerifier(new HostnameVerifier(){

                    @Override
                    public boolean verify(String hostname, SSLSession session) {
                        return true;
                    }
                });
                httpsConn.setSSLSocketFactory(HttpRequester.getSocketFactory());
            }
        }
        catch (IOException e) {
            logger.error(e.getMessage());
        }
        if (connection != null) {
            connection.setConnectTimeout(5000);
            connection.setReadTimeout(5000);
            connection.setDoOutput(true);
            connection.setDoInput(true);
            connection.setRequestProperty("accept", "*/*");
            this.addHeaderParams((HttpURLConnection)connection, customizedHeaderParams);
        }
        return connection;
    }

    private static final SSLSocketFactory getSocketFactory() {
        if (sslSocketFactory == null) {
            try {
                TrustManager[] tm = new TrustManager[]{new X509TrustManager(){

                    @Override
                    public void checkClientTrusted(X509Certificate[] cert, String authType) {
                    }

                    @Override
                    public void checkServerTrusted(X509Certificate[] cert, String authType) {
                    }

                    @Override
                    public X509Certificate[] getAcceptedIssuers() {
                        logger.info("no client accept check");
                        return null;
                    }
                }};
                String ssl = "SSL";
                SSLContext context = SSLContext.getInstance(ssl);
                context.init(new KeyManager[0], tm, new SecureRandom());
                sslSocketFactory = context.getSocketFactory();
            }
            catch (KeyManagementException | NoSuchAlgorithmException e) {
                logger.error(e.getMessage());
            }
        }
        return sslSocketFactory;
    }

    public boolean isConnected() {
        String ipAddress = this.vipHostName.contains(":") ? this.vipHostName.split(":")[0] : this.vipHostName;
        return HttpRequester.ping(ipAddress);
    }

    private void addHeaderParams(HttpURLConnection connection, Map<String, String> customizedHeaderParams) {
        if (customizedHeaderParams != null) {
            for (Map.Entry<String, String> entry : customizedHeaderParams.entrySet()) {
                connection.setRequestProperty(entry.getKey(), entry.getValue());
            }
        }
        if (this.commonHeaderParams != null) {
            for (Map.Entry<String, String> entry : this.commonHeaderParams.entrySet()) {
                connection.setRequestProperty(entry.getKey(), entry.getValue());
            }
        }
    }
}

