/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vipclient.i18n.base.cache;

import com.vmware.vipclient.i18n.VIPCfg;
import com.vmware.vipclient.i18n.base.cache.CacheItem;
import java.util.HashMap;
import java.util.Map;

public class MessageCacheItem
implements CacheItem {
    private String locale;
    private String etag;
    private long timestamp;
    private Long maxAgeMillis = 86400000L;
    private final Map<String, String> cachedData = new HashMap<String, String>();

    public MessageCacheItem() {
    }

    public MessageCacheItem(Map<String, String> dataMap) {
        if (dataMap != null) {
            this.cachedData.putAll(dataMap);
        }
    }

    public MessageCacheItem(String locale, Map<String, String> dataMap, String etag, long timestamp, Long maxAgeMillis) {
        this.setCacheItem(locale, dataMap, etag, timestamp, maxAgeMillis);
    }

    public synchronized void setCacheItem(String locale, Map<String, String> dataToCache, String etag, long timestamp, Long maxAgeMillis) {
        if (dataToCache != null) {
            this.cachedData.putAll(dataToCache);
        }
        this.setCacheItem(locale, etag, timestamp, maxAgeMillis);
    }

    public synchronized void setCacheItem(String locale, String etag, long timestamp, Long maxAgeMillis) {
        this.locale = locale;
        if (etag != null && !etag.isEmpty()) {
            this.etag = etag;
        }
        this.timestamp = timestamp;
        if (maxAgeMillis != null) {
            this.maxAgeMillis = maxAgeMillis;
        }
    }

    public synchronized void setCacheItem(MessageCacheItem cacheItem) {
        this.setCacheItem(cacheItem.getLocale(), cacheItem.getCachedData(), cacheItem.getEtag(), cacheItem.getTimestamp(), cacheItem.getMaxAgeMillis());
    }

    public String getEtag() {
        return this.etag;
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public Map<String, String> getCachedData() {
        return this.cachedData;
    }

    public Long getMaxAgeMillis() {
        return this.maxAgeMillis;
    }

    public String getLocale() {
        return this.locale;
    }

    public synchronized boolean isExpired() {
        if (VIPCfg.getInstance().getVipServer() == null) {
            return false;
        }
        if (VIPCfg.getInstance().getCacheExpiredTime() != 0L) {
            return false;
        }
        Long responseTimeStamp = this.getTimestamp();
        if (responseTimeStamp == null) {
            return true;
        }
        Long maxAgeResponse = this.getMaxAgeMillis();
        if (maxAgeResponse != null) {
            this.maxAgeMillis = maxAgeResponse;
        }
        return System.currentTimeMillis() - responseTimeStamp > this.maxAgeMillis;
    }
}

