/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vipclient.i18n.messages.api.opt.local;

import com.vmware.i18n.PatternUtil;
import com.vmware.i18n.dto.LocaleDataDTO;
import com.vmware.i18n.pattern.service.impl.PatternServiceImpl;
import com.vmware.i18n.utils.CommonUtil;
import com.vmware.vipclient.i18n.messages.api.opt.PatternOpt;
import java.util.Map;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LocalPatternOpt
implements PatternOpt {
    Logger logger = LoggerFactory.getLogger(LocalPatternOpt.class);

    @Override
    public JSONObject getPatterns(String locale) {
        this.logger.debug("Look for pattern from local bundle for locale [{}]!", (Object)locale);
        String normalizedLocale = CommonUtil.getCLDRLocale((String)locale, (Map)PatternServiceImpl.localePathMap, (Map)PatternServiceImpl.localeAliasesMap);
        this.logger.debug("Normalized locale for locale [{}] is [{}]", (Object)locale, (Object)normalizedLocale);
        return this.getPatternsByLocale(normalizedLocale);
    }

    @Override
    public JSONObject getPatterns(String language, String region) {
        this.logger.debug("Look for pattern from local bundle for language [{}], region [{}]!", (Object)language, (Object)region);
        LocaleDataDTO resultData = CommonUtil.getLocale((String)language, (String)region);
        String normalizedLocale = resultData.getLocale();
        this.logger.debug("Normalized locale for language [{}], region [{}] is [{}]", new Object[]{language, region, normalizedLocale});
        return this.getPatternsByLocale(normalizedLocale);
    }

    private JSONObject getPatternsByLocale(String normalizedLocale) {
        if (normalizedLocale == null || normalizedLocale.isEmpty()) {
            return null;
        }
        try {
            String patternStr = PatternUtil.getPatternFromLib((String)normalizedLocale, null);
            Map patterns = (Map)new JSONParser().parse(patternStr);
            return (JSONObject)patterns.get("categories");
        }
        catch (Exception e) {
            e.printStackTrace();
            this.logger.error(e.getMessage());
            return null;
        }
    }
}

