/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vipclient.i18n.messages.service;

import com.vmware.vipclient.i18n.VIPCfg;
import com.vmware.vipclient.i18n.base.DataSourceEnum;
import com.vmware.vipclient.i18n.messages.service.FormattingCacheService;
import com.vmware.vipclient.i18n.util.LocaleUtility;
import java.util.Iterator;
import java.util.ListIterator;
import java.util.Locale;
import org.json.simple.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PatternService {
    Logger logger = LoggerFactory.getLogger(PatternService.class);

    public JSONObject getPatternsByCategory(String locale, String category) {
        JSONObject patterns = this.getPatternsByLocale(locale);
        return (JSONObject)patterns.get((Object)category);
    }

    public JSONObject getPatterns(String locale) {
        JSONObject patterns = this.getPatternsByLocale(locale);
        if (patterns != null) {
            return patterns;
        }
        Iterator<Locale> fallbackLocalesIter = LocaleUtility.getFallbackLocales().iterator();
        while (fallbackLocalesIter.hasNext()) {
            String fallbackLocale = fallbackLocalesIter.next().toLanguageTag();
            if (fallbackLocale.equalsIgnoreCase(locale)) continue;
            this.logger.info("Can't find pattern for locale [{}], look for fallback locale [{}] pattern as fallback!", (Object)locale, (Object)fallbackLocale);
            patterns = this.getPatternsByLocale(fallbackLocale);
            if (patterns == null) continue;
            new FormattingCacheService().addPatterns(locale, patterns);
            this.logger.debug("Fallback locale [{}] pattern is cached for locale [{}]!\n\n", (Object)fallbackLocale, (Object)locale);
            return patterns;
        }
        return null;
    }

    public JSONObject getPatternsByLocale(String locale) {
        if (locale != null && !locale.isEmpty()) {
            locale = locale.replace("_", "-");
        }
        JSONObject patterns = null;
        this.logger.debug("Look for pattern from cache for locale [{}]!", (Object)locale);
        FormattingCacheService formattingCacheService = new FormattingCacheService();
        patterns = formattingCacheService.getPatterns(locale);
        if (patterns != null) {
            this.logger.debug("Find pattern from cache for locale [{}]!", (Object)locale);
            return patterns;
        }
        patterns = this.getPatternsFromDS(locale, VIPCfg.getInstance().getMsgOriginsQueue().listIterator());
        if (patterns != null) {
            this.logger.debug("Find the pattern for locale [{}].\n", (Object)locale);
            formattingCacheService.addPatterns(locale, patterns);
            this.logger.debug("Pattern is cached for locale [{}]!\n\n", (Object)locale);
            return patterns;
        }
        return null;
    }

    public JSONObject getPatterns(String language, String region) {
        JSONObject patterns = this.getPatternsByLanguageRegion(language, region);
        if (patterns != null) {
            return patterns;
        }
        Iterator<Locale> fallbackLocalesIter = LocaleUtility.getFallbackLocales().iterator();
        while (fallbackLocalesIter.hasNext()) {
            String fallbackLocale = fallbackLocalesIter.next().toLanguageTag();
            if (fallbackLocale.equalsIgnoreCase(new Locale(language, region).toLanguageTag())) continue;
            this.logger.info("Can't find pattern for language [{}] region [{}], look for fallback locale [{}] pattern as fallback!", new Object[]{language, region, fallbackLocale});
            patterns = this.getPatternsByLocale(fallbackLocale);
            if (patterns == null) continue;
            new FormattingCacheService().addPatterns(language, region, patterns);
            this.logger.debug("Fallback locale [{}] pattern is cached for language [{}], region [{}]!\n\n", new Object[]{fallbackLocale, language, region});
            return patterns;
        }
        return null;
    }

    public JSONObject getPatternsByLanguageRegion(String language, String region) {
        language = language.replace("_", "-");
        JSONObject patterns = null;
        this.logger.debug("Look for pattern from cache for language [{}], region [{}]!", (Object)language, (Object)region);
        FormattingCacheService formattingCacheService = new FormattingCacheService();
        patterns = formattingCacheService.getPatterns(language, region);
        if (patterns != null) {
            this.logger.debug("Find pattern from cache for language [{}], region [{}]!", (Object)language, (Object)region);
            return patterns;
        }
        patterns = this.getPatternsFromDS(language, region, VIPCfg.getInstance().getMsgOriginsQueue().listIterator());
        if (patterns != null) {
            this.logger.debug("Find the pattern for language [{}], region [{}].\n", (Object)language, (Object)region);
            formattingCacheService.addPatterns(language, region, patterns);
            this.logger.debug("Pattern is cached for language [{}], region [{}]!\n\n", (Object)language, (Object)region);
            return patterns;
        }
        return null;
    }

    private JSONObject getPatternsFromDS(String locale, ListIterator<DataSourceEnum> msgSourceQueueIter) {
        JSONObject patterns = null;
        if (!msgSourceQueueIter.hasNext()) {
            return patterns;
        }
        DataSourceEnum dataSource = msgSourceQueueIter.next();
        patterns = dataSource.createPatternOpt().getPatterns(locale);
        if (patterns == null || patterns.isEmpty()) {
            patterns = this.getPatternsFromDS(locale, msgSourceQueueIter);
        }
        return patterns;
    }

    private JSONObject getPatternsFromDS(String language, String region, ListIterator<DataSourceEnum> msgSourceQueueIter) {
        JSONObject patterns = null;
        if (!msgSourceQueueIter.hasNext()) {
            return patterns;
        }
        DataSourceEnum dataSource = msgSourceQueueIter.next();
        patterns = dataSource.createPatternOpt().getPatterns(language, region);
        if (patterns == null || patterns.isEmpty()) {
            patterns = this.getPatternsFromDS(language, region, msgSourceQueueIter);
        }
        return patterns;
    }
}

