/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vipclient.i18n.messages.service;

import com.vmware.vipclient.i18n.VIPCfg;
import com.vmware.vipclient.i18n.base.DataSourceEnum;
import com.vmware.vipclient.i18n.messages.api.opt.ProductOpt;
import com.vmware.vipclient.i18n.messages.dto.BaseDTO;
import com.vmware.vipclient.i18n.messages.dto.MessagesDTO;
import com.vmware.vipclient.i18n.messages.service.ComponentService;
import com.vmware.vipclient.i18n.util.LocaleUtility;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProductService {
    private BaseDTO dto = null;
    Logger logger = LoggerFactory.getLogger(ProductService.class);

    public ProductService(BaseDTO dto) {
        this.dto = dto;
    }

    public List<Map> getAllComponentTranslation() {
        ArrayList<Map> list = new ArrayList<Map>();
        List<String> locales = this.getSupportedLocales();
        List<String> components = this.getComponents();
        if (locales != null && components != null) {
            for (String languageTag : locales) {
                for (String component : components) {
                    MessagesDTO msgDTO = new MessagesDTO(component.trim(), LocaleUtility.fmtToMappedLocale(Locale.forLanguageTag(languageTag)).toString().trim(), this.dto.getProductID(), this.dto.getVersion());
                    Map<String, String> retMap = new ComponentService(msgDTO).getMessages(null).getCachedData();
                    if (retMap == null) continue;
                    list.add(retMap);
                }
            }
        }
        return list;
    }

    public List<String> getComponents() {
        List<String> components = null;
        Iterator<DataSourceEnum> msgSourceQueueIter = VIPCfg.getInstance().getMsgOriginsQueue().iterator();
        while ((components == null || components.isEmpty()) && msgSourceQueueIter.hasNext()) {
            DataSourceEnum dataSource = msgSourceQueueIter.next();
            ProductOpt opt = dataSource.createProductOpt(this.dto);
            components = opt.getComponents();
            if (components != null && !components.isEmpty()) continue;
            this.logger.error("Failed to get list of components from {0} data source", (Object)dataSource.toString());
        }
        return components;
    }

    public List<String> getSupportedLocales() {
        List<String> locales = null;
        Iterator<DataSourceEnum> msgSourceQueueIter = VIPCfg.getInstance().getMsgOriginsQueue().iterator();
        while ((locales == null || locales.isEmpty()) && msgSourceQueueIter.hasNext()) {
            DataSourceEnum dataSource = msgSourceQueueIter.next();
            ProductOpt opt = dataSource.createProductOpt(this.dto);
            locales = opt.getSupportedLocales();
            if (locales != null && !locales.isEmpty()) continue;
            this.logger.error("Failed to get list of locales from {0} data source", (Object)dataSource.toString());
        }
        return locales;
    }
}

