/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vipclient.i18n.util;

import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Collectors;

public class LocaleUtility {
    private static Locale defaultLocale;
    private static Locale sourceLocale;
    private static List<Locale> fallbackLocales;
    private static InheritableThreadLocal<Map<String, Locale>> threadLocal;

    public static void setLocale(Locale locale) {
        Map localeMap = (Map)threadLocal.get();
        localeMap.put("LOCALE_L3", locale);
        threadLocal.set(localeMap);
    }

    public static Locale getLocale() {
        Map localeMap = (Map)threadLocal.get();
        Locale locale = (Locale)localeMap.get("LOCALE_L3");
        if (locale == null) {
            return defaultLocale;
        }
        return locale;
    }

    public static void setL2Locale(Locale locale) {
        Map localeMap = (Map)threadLocal.get();
        localeMap.put("LOCALE_L2", locale);
        threadLocal.set(localeMap);
    }

    public static Locale getL2Locale() {
        Map localeMap = (Map)threadLocal.get();
        Locale locale = (Locale)localeMap.get("LOCALE_L2");
        if (locale == null) {
            return defaultLocale;
        }
        return locale;
    }

    public static boolean isDefaultLocale(Locale locale) {
        if (locale != null) {
            return LocaleUtility.isDefaultLocale(locale.toLanguageTag());
        }
        return false;
    }

    public static boolean isDefaultLocale(String languageTag) {
        languageTag = languageTag.replaceAll("_", "-");
        Locale match = Locale.lookup(Arrays.asList(new Locale.LanguageRange(languageTag)), Arrays.asList(LocaleUtility.getDefaultLocale()));
        return match != null;
    }

    public static Locale fmtToMappedLocale(String zhLocale) {
        return LocaleUtility.fmtToMappedLocale(Locale.forLanguageTag(zhLocale.replace("_", "-")));
    }

    public static Locale fmtToMappedLocale(Locale zhLocale) {
        if (zhLocale.toLanguageTag().equalsIgnoreCase("zh-CN") || zhLocale.toLanguageTag().equalsIgnoreCase("zh-Hans-CN")) {
            return Locale.forLanguageTag("zh-Hans");
        }
        if (zhLocale.toLanguageTag().equalsIgnoreCase("zh-TW") || zhLocale.toLanguageTag().equalsIgnoreCase("zh-Hant-TW")) {
            return Locale.forLanguageTag("zh-HANT");
        }
        return zhLocale;
    }

    public static boolean isSameLocale(String locale1, String locale2) {
        String loc1 = LocaleUtility.fmtToMappedLocale(locale1).toLanguageTag();
        String loc2 = LocaleUtility.fmtToMappedLocale(locale2).toLanguageTag();
        return loc1.equals(loc2);
    }

    public static Locale pickupLocaleFromList(List<Locale> locales, Locale preferredLocale) {
        Locale langLocale = null;
        preferredLocale = LocaleUtility.fmtToMappedLocale(preferredLocale);
        for (Locale configuredLocale : locales) {
            if (!(configuredLocale = LocaleUtility.fmtToMappedLocale(configuredLocale)).getLanguage().equals(preferredLocale.getLanguage())) continue;
            String configuredScript = configuredLocale.getScript();
            String preferredScript = preferredLocale.getScript();
            if (preferredScript.equalsIgnoreCase("") && configuredScript.equalsIgnoreCase("") || !preferredScript.equalsIgnoreCase("") && preferredScript.equalsIgnoreCase(configuredScript)) {
                return configuredLocale;
            }
            langLocale = langLocale == null ? configuredLocale : langLocale;
        }
        if (langLocale != null && !langLocale.getLanguage().equalsIgnoreCase("zh")) {
            return new Locale(langLocale.getLanguage());
        }
        return preferredLocale;
    }

    public static String normalizeToLanguageTag(String localeStr) {
        if (null == localeStr || "".equalsIgnoreCase(localeStr)) {
            return localeStr;
        }
        if (LocaleUtility.isLanguageTag(localeStr)) {
            return localeStr;
        }
        String language = "";
        String country = "";
        String script = "";
        String[] os = localeStr.split("_");
        block5: for (int i = 0; i < os.length; ++i) {
            switch (i) {
                case 0: {
                    language = os[0];
                    continue block5;
                }
                case 1: {
                    country = "".equalsIgnoreCase(os[1]) ? "" : "-" + os[1];
                    continue block5;
                }
                case 2: {
                    script = "".equalsIgnoreCase(os[2]) ? "" : "-" + os[2].replace("#", "");
                    continue block5;
                }
            }
        }
        return language + script + country;
    }

    public static boolean isLanguageTag(String languageTag) {
        if (null == languageTag || "".equalsIgnoreCase(languageTag)) {
            return false;
        }
        return languageTag.contains("-");
    }

    public static Locale getDefaultLocale() {
        return defaultLocale == null ? LocaleUtility.getSourceLocale() : defaultLocale;
    }

    public static void setDefaultLocale(Locale defaultLocale) {
        LocaleUtility.defaultLocale = defaultLocale;
    }

    public static Locale getSourceLocale() {
        return sourceLocale;
    }

    public static void setSourceLocale(Locale sourceLocale) {
        LocaleUtility.sourceLocale = sourceLocale;
    }

    public static List<Locale> getFallbackLocales() {
        return fallbackLocales;
    }

    public static void setFallbackLocales(List<Locale> fallbackLocales) {
        LocaleUtility.fallbackLocales = fallbackLocales;
    }

    static {
        sourceLocale = Locale.ENGLISH;
        fallbackLocales = new LinkedList<Locale>(Arrays.asList(LocaleUtility.getDefaultLocale(), Locale.forLanguageTag("source")));
        threadLocal = new InheritableThreadLocal<Map<String, Locale>>(){

            @Override
            protected Map<String, Locale> initialValue() {
                return new HashMap<String, Locale>();
            }

            @Override
            protected Map<String, Locale> childValue(Map<String, Locale> parentValue) {
                return parentValue.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> new Locale.Builder().setLocale((Locale)e.getValue()).build()));
            }
        };
    }
}

