/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vipclient.i18n.base.cache.persist;

import com.vmware.vipclient.i18n.base.cache.TranslationCacheManager;
import com.vmware.vipclient.i18n.base.cache.persist.CacheSnapshot;
import com.vmware.vipclient.i18n.base.cache.persist.Loader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.util.Map;
import org.json.simple.parser.JSONParser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DiskCacheLoader
implements Loader {
    Logger logger = LoggerFactory.getLogger(DiskCacheLoader.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<String, String> load(String key) {
        CacheSnapshot c = TranslationCacheManager.getInstance().getCacheSnapshot();
        String rootpath = c.getCacheRootPath();
        File file = new File(rootpath + File.separator + key);
        FileInputStream fis = null;
        InputStreamReader reader = null;
        Map map = null;
        try {
            Object o;
            if (file.exists()) {
                try {
                    fis = new FileInputStream(file);
                }
                catch (Exception e) {
                    this.logger.error(e.getMessage());
                }
            }
            if ((o = new JSONParser().parse((Reader)(reader = new InputStreamReader((InputStream)fis, "UTF-8")))) != null) {
                map = (Map)o;
            }
        }
        catch (Exception e) {
            this.logger.error(e.getMessage());
        }
        finally {
            try {
                if (fis != null) {
                    fis.close();
                }
            }
            catch (IOException e) {
                this.logger.error(e.getMessage());
            }
            try {
                if (reader != null) {
                    reader.close();
                }
            }
            catch (IOException e) {
                this.logger.error(e.getMessage());
            }
        }
        return map;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean updateOrInsert(String key, String content) {
        CacheSnapshot c = TranslationCacheManager.getInstance().getCacheSnapshot();
        String rootpath = c.getCacheRootPath();
        OutputStreamWriter writer = null;
        try {
            writer = new FileWriter(rootpath + File.separator + key);
            writer.write(content);
        }
        catch (IOException e) {
            this.logger.error(e.getMessage());
            boolean bl = false;
            return bl;
        }
        finally {
            if (writer != null) {
                try {
                    writer.close();
                }
                catch (IOException e) {
                    this.logger.error(e.getMessage());
                }
            }
        }
        return true;
    }

    @Override
    public boolean delete(String key) {
        CacheSnapshot c = TranslationCacheManager.getInstance().getCacheSnapshot();
        String rootpath = c.getCacheRootPath();
        boolean f = false;
        if (this.isExisting(key)) {
            f = new File(rootpath + File.separator + key).delete();
        }
        return f;
    }

    @Override
    public boolean isExisting(String key) {
        CacheSnapshot c = TranslationCacheManager.getInstance().getCacheSnapshot();
        String rootpath = c.getCacheRootPath();
        return new File(rootpath + File.separator + key).exists();
    }

    @Override
    public boolean clear() {
        return false;
    }

    @Override
    public boolean refreshCacheSnapshot(CacheSnapshot cacheSnapshot) {
        boolean bl;
        ObjectOutputStream os = new ObjectOutputStream(new FileOutputStream("cacheSnapshot.ser"));
        try {
            os.writeObject(cacheSnapshot);
            bl = true;
        }
        catch (Throwable throwable) {
            try {
                try {
                    os.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (Exception ex) {
                this.logger.error(ex.getMessage());
                return false;
            }
        }
        os.close();
        return bl;
    }

    public CacheSnapshot getCacheSnapshot() {
        CacheSnapshot c = null;
        try (FileInputStream fs = new FileInputStream("cacheSnapshot.ser");
             ObjectInputStream ins = new ObjectInputStream(fs);){
            Object o = ins.readObject();
            if (o != null) {
                c = (CacheSnapshot)o;
            }
        }
        catch (Exception ex) {
            this.logger.error(ex.getMessage());
            return null;
        }
        return c;
    }
}

