/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vipclient.i18n;

import com.vmware.vipclient.i18n.base.DataSourceEnum;
import com.vmware.vipclient.i18n.base.Task;
import com.vmware.vipclient.i18n.base.VIPService;
import com.vmware.vipclient.i18n.base.cache.Cache;
import com.vmware.vipclient.i18n.base.cache.CacheMode;
import com.vmware.vipclient.i18n.base.cache.TranslationCacheManager;
import com.vmware.vipclient.i18n.exceptions.VIPClientInitException;
import com.vmware.vipclient.i18n.messages.dto.MessagesDTO;
import com.vmware.vipclient.i18n.messages.service.ProductService;
import com.vmware.vipclient.i18n.util.LocaleUtility;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VIPCfg {
    Logger logger = LoggerFactory.getLogger(VIPCfg.class);
    private static VIPCfg gcInstance;
    private static Map<String, VIPCfg> moduleCfgs;
    private VIPService vipService;
    @Deprecated
    private DataSourceEnum messageOrigin = DataSourceEnum.VIP;
    private List<DataSourceEnum> msgOriginsQueue = new LinkedList<DataSourceEnum>();
    private CacheMode cacheMode = CacheMode.MEMORY;
    private String cachePath;
    private boolean pseudo;
    private boolean collectSource;
    private boolean cleanCache;
    private long cacheExpiredTime;
    private boolean machineTranslation;
    private boolean initializeCache;
    private int interalCleanCache;
    private String productName;
    private String version;
    private String i18nScope = "numbers,dates,currencies,plurals,measurements";
    private String offlineResourcesBaseUrl;
    public static final String CACHE_L3 = "CACHE_L3";
    public static final String CACHE_L2 = "CACHE_L2";
    private boolean isSubInstance = false;

    public boolean isSubInstance() {
        return this.isSubInstance;
    }

    public void setSubInstance(boolean subInstance) {
        this.isSubInstance = subInstance;
    }

    private VIPCfg() {
    }

    public static synchronized VIPCfg getInstance() {
        if (gcInstance == null) {
            gcInstance = new VIPCfg();
        }
        return gcInstance;
    }

    public static synchronized VIPCfg getSubInstance(String productName) {
        if (!moduleCfgs.containsKey(productName)) {
            VIPCfg cfg = new VIPCfg();
            cfg.isSubInstance = true;
            moduleCfgs.put(productName, cfg);
        }
        return moduleCfgs.get(productName);
    }

    public void initialize(String vipServer, String productName, String version) {
        this.setProductName(productName);
        this.setVersion(version);
        this.setVipServer(vipServer);
    }

    public void initialize(String cfg) throws VIPClientInitException {
        ResourceBundle prop = ResourceBundle.getBundle(cfg);
        if (prop == null) {
            throw new VIPClientInitException("Can't not initialize VIPCfg, resource bundle is null.");
        }
        if (prop.containsKey("productName")) {
            this.setProductName(prop.getString("productName"));
        }
        if (this.isSubInstance() && !moduleCfgs.containsKey(this.productName)) {
            throw new VIPClientInitException("Can't not initialize sub VIPCfg instance, the product name is not defined in config file.");
        }
        if (prop.containsKey("version")) {
            this.setVersion(prop.getString("version"));
        }
        this.setMsgOriginsQueue(new LinkedList<DataSourceEnum>());
        if (prop.containsKey("vipServer")) {
            this.setVipServer(prop.getString("vipServer"));
        }
        if (prop.containsKey("offlineResourcesBaseUrl")) {
            this.setOfflineResourcesBaseUrl(prop.getString("offlineResourcesBaseUrl"));
        }
        if (prop.containsKey("pseudo")) {
            this.setPseudo(Boolean.parseBoolean(prop.getString("pseudo")));
        }
        if (prop.containsKey("collectSource")) {
            this.setCollectSource(Boolean.parseBoolean(prop.getString("collectSource")));
        }
        if (prop.containsKey("initializeCache")) {
            this.setInitializeCache(Boolean.parseBoolean(prop.getString("initializeCache")));
        }
        if (prop.containsKey("cleanCache")) {
            this.setCleanCache(Boolean.parseBoolean(prop.getString("cleanCache")));
        }
        if (prop.containsKey("machineTranslation")) {
            this.setMachineTranslation(Boolean.parseBoolean(prop.getString("machineTranslation")));
        }
        if (prop.containsKey("i18nScope")) {
            this.setI18nScope(prop.getString("i18nScope"));
        }
        if (prop.containsKey("cacheExpiredTime")) {
            this.setCacheExpiredTime(Long.parseLong(prop.getString("cacheExpiredTime")));
        }
        if (prop.containsKey("defaultLocale")) {
            LocaleUtility.setDefaultLocale(Locale.forLanguageTag(prop.getString("defaultLocale")));
            LocaleUtility.setFallbackLocales(new LinkedList<Locale>(Arrays.asList(LocaleUtility.getDefaultLocale(), Locale.forLanguageTag("source"))));
        }
        if (prop.containsKey("sourceLocale")) {
            LocaleUtility.setSourceLocale(Locale.forLanguageTag(prop.getString("sourceLocale")));
        }
    }

    @Deprecated
    public void initializeVIPService() {
    }

    public void setTranslationCache(Cache c) {
        Cache createdCache;
        TranslationCacheManager translationCacheManager = TranslationCacheManager.getInstance();
        translationCacheManager.registerCache(CACHE_L3, c);
        this.logger.info("Translation Cache created.");
        if (this.isInitializeCache()) {
            this.logger.info("Initializing Cache.");
            this.initializeMessageCache();
        }
        if (this.isCleanCache()) {
            this.logger.info("startTaskOfCacheClean.");
            Task.startTaskOfCacheClean(VIPCfg.getInstance(), this.interalCleanCache);
        }
        if ((createdCache = TranslationCacheManager.getCache(CACHE_L3)) != null && this.getCacheExpiredTime() != 0L) {
            c.setExpiredTime(this.getCacheExpiredTime());
        }
    }

    public synchronized Cache createTranslationCache(Class cacheClass) {
        TranslationCacheManager translationCacheManager = TranslationCacheManager.getInstance();
        if (TranslationCacheManager.getCache(CACHE_L3) == null) {
            Cache c;
            translationCacheManager.registerCache(CACHE_L3, cacheClass);
            this.logger.info("Translation Cache created.");
            if (this.isInitializeCache()) {
                this.logger.info("InitializeCache.");
                this.initializeMessageCache();
            }
            if (this.isCleanCache()) {
                this.logger.info("startTaskOfCacheClean.");
                Task.startTaskOfCacheClean(VIPCfg.getInstance(), this.interalCleanCache);
            }
            if ((c = TranslationCacheManager.getCache(CACHE_L3)) != null && this.getCacheExpiredTime() != 0L) {
                c.setExpiredTime(this.getCacheExpiredTime());
            }
        }
        return TranslationCacheManager.getCache(CACHE_L3);
    }

    public Cache createFormattingCache(Class cacheClass) {
        TranslationCacheManager translationCacheManager = TranslationCacheManager.getInstance();
        translationCacheManager.registerCache(CACHE_L2, cacheClass);
        this.logger.info("Formatting cache created.");
        if (this.isCleanCache()) {
            this.logger.error("clean cache.");
            Task.startTaskOfCacheClean(VIPCfg.getInstance(), this.interalCleanCache);
        }
        return TranslationCacheManager.getCache(CACHE_L2);
    }

    public void initializeMessageCache() {
        MessagesDTO dto = new MessagesDTO();
        dto.setProductID(this.getProductName());
        dto.setVersion(this.getVersion());
        new ProductService(dto).getAllComponentTranslation();
        this.logger.info("Translation data is loaded to cache, size is " + TranslationCacheManager.getInstance().size() + ".");
    }

    public String getProductName() {
        return this.productName;
    }

    public void setProductName(String productName) {
        this.productName = productName;
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public String getVipServer() {
        if (this.getVipService() == null) {
            return null;
        }
        return this.getVipService().getVipServer();
    }

    public void setVipServer(String vipServer) {
        try {
            this.vipService = new VIPService(vipServer);
            this.addMsgOriginsQueue(DataSourceEnum.VIP);
        }
        catch (Exception e) {
            this.logger.error("'vipServer' " + this.getVipServer() + " in configuration isn't a valid URL!");
        }
    }

    public boolean isPseudo() {
        return this.pseudo;
    }

    public void setPseudo(boolean pseudo) {
        this.pseudo = pseudo;
    }

    public boolean isCollectSource() {
        return this.collectSource;
    }

    public void setCollectSource(boolean collectSource) {
        this.collectSource = collectSource;
    }

    public boolean isCleanCache() {
        return this.cleanCache;
    }

    public void setCleanCache(boolean cleanCache) {
        this.cleanCache = cleanCache;
    }

    public VIPService getVipService() {
        return this.vipService;
    }

    public TranslationCacheManager getCacheManager() {
        return TranslationCacheManager.getInstance();
    }

    public int getInteralCleanCache() {
        return this.interalCleanCache;
    }

    public void setInteralCleanCache(int interalCleanCache) {
        this.interalCleanCache = interalCleanCache;
    }

    public String getI18nScope() {
        return this.i18nScope;
    }

    public void setI18nScope(String i18nScope) {
        this.i18nScope = i18nScope;
    }

    public boolean isMachineTranslation() {
        return this.machineTranslation;
    }

    public void setMachineTranslation(boolean machineTranslation) {
        this.machineTranslation = machineTranslation;
    }

    @Deprecated
    public DataSourceEnum getMessageOrigin() {
        return this.messageOrigin;
    }

    @Deprecated
    public void setMessageOrigin(DataSourceEnum messageOrigin) {
        this.messageOrigin = messageOrigin;
    }

    public boolean isInitializeCache() {
        return this.initializeCache;
    }

    public void setInitializeCache(boolean initializeCache) {
        this.initializeCache = initializeCache;
    }

    @Deprecated
    public long getCacheExpiredTime() {
        return this.cacheExpiredTime;
    }

    @Deprecated
    public void setCacheExpiredTime(long cacheExpiredTime) {
        this.cacheExpiredTime = cacheExpiredTime;
    }

    public CacheMode getCacheMode() {
        return this.cacheMode;
    }

    public void setCacheMode(CacheMode cacheMode) {
        this.cacheMode = cacheMode;
    }

    public String getCachePath() {
        return this.cachePath;
    }

    public void setCachePath(String cachePath) {
        this.cachePath = cachePath;
    }

    public String getOfflineResourcesBaseUrl() {
        return this.offlineResourcesBaseUrl;
    }

    public void setOfflineResourcesBaseUrl(String offlineResourcesBaseUrl) {
        this.offlineResourcesBaseUrl = offlineResourcesBaseUrl;
        this.addMsgOriginsQueue(DataSourceEnum.Bundle);
    }

    public List<DataSourceEnum> getMsgOriginsQueue() {
        return this.msgOriginsQueue;
    }

    public void addMsgOriginsQueue(DataSourceEnum dataSource) {
        this.msgOriginsQueue.add(dataSource);
    }

    public void setMsgOriginsQueue(List<DataSourceEnum> msgOriginsQueue) {
        this.msgOriginsQueue = msgOriginsQueue;
    }

    static {
        moduleCfgs = new HashMap<String, VIPCfg>();
    }
}

