/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vipclient.i18n.filters;

import com.vmware.vipclient.i18n.I18nFactory;
import com.vmware.vipclient.i18n.VIPCfg;
import com.vmware.vipclient.i18n.base.instances.PatternMessage;
import com.vmware.vipclient.i18n.exceptions.VIPJavaClientException;
import com.vmware.vipclient.i18n.filters.FilterUtils;
import com.vmware.vipclient.i18n.util.LocaleUtility;
import com.vmware.vipclient.i18n.util.StringUtil;
import java.io.IOException;
import java.util.Locale;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VIPPatternFilter
implements Filter {
    Logger logger = LoggerFactory.getLogger(VIPPatternFilter.class);
    private PatternMessage patternMessage;
    private VIPCfg gc = VIPCfg.getInstance();

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        try {
            JSONObject jsonObject;
            String locale = FilterUtils.getParamFromQuery(request, "locale");
            this.logger.debug("locale: " + locale);
            String patterns = "{}";
            if (!StringUtil.isEmpty(locale) && !LocaleUtility.isDefaultLocale(locale) && (jsonObject = this.patternMessage.getPatternMessage(Locale.forLanguageTag(locale))) != null) {
                patterns = jsonObject.toString();
            }
            ServletOutputStream os = response.getOutputStream();
            response.setContentType("text/javascript;charset=UTF-8");
            os.write(("var localeData =" + patterns).getBytes("UTF-8"));
        }
        catch (VIPJavaClientException e) {
            this.logger.error(e.getMessage());
            String errorMsg = "{\"code\":400, \"message\": \"" + e.getMessage() + "\"}";
            FilterUtils.printErrorMsg(response, errorMsg);
        }
    }

    public void destroy() {
    }

    public void init(FilterConfig filterConfig) throws ServletException {
        I18nFactory i18n = I18nFactory.getInstance();
        try {
            this.patternMessage = (PatternMessage)i18n.getMessageInstance(PatternMessage.class);
        }
        catch (NullPointerException e) {
            throw new ServletException("Haven't init I18nFactory, please init VIPCfg with your config first when your service starts(for example init VIPCfg in listener), then initialize I18nFactory with VIPCfg!", (Throwable)e);
        }
    }
}

