/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vipclient.i18n.messages.api.opt.server;

import com.vmware.vipclient.i18n.VIPCfg;
import com.vmware.vipclient.i18n.base.cache.MessageCacheItem;
import com.vmware.vipclient.i18n.messages.api.opt.BaseOpt;
import com.vmware.vipclient.i18n.messages.api.opt.ProductOpt;
import com.vmware.vipclient.i18n.messages.api.url.URLUtils;
import com.vmware.vipclient.i18n.messages.api.url.V2URL;
import com.vmware.vipclient.i18n.messages.dto.BaseDTO;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.json.JSONArray;

public class RemoteProductOpt
extends BaseOpt
implements ProductOpt {
    private BaseDTO dto = null;

    public RemoteProductOpt(BaseDTO dto) {
        this.dto = dto;
    }

    @Override
    public List<String> getComponents() {
        Object dataObj;
        JSONArray msgObject = new JSONArray();
        String responseStr = "";
        Map<String, Object> response = VIPCfg.getInstance().getVipService().getHttpRequester().request(V2URL.getComponentListURL(this.dto, VIPCfg.getInstance().getVipService().getHttpRequester().getBaseURL()), "GET", null);
        responseStr = (String)response.get("body");
        if (null != responseStr && !responseStr.equals("") && (dataObj = this.getMessagesFromResponse(responseStr, "components")) != null) {
            msgObject = (JSONArray)dataObj;
        }
        return msgObject.toList().stream().map(obj -> obj == null ? null : obj.toString()).collect(Collectors.toList());
    }

    @Override
    public void getSupportedLocales(MessageCacheItem cacheItem) {
        Map<String, Object> response;
        Integer responseCode;
        HashMap<String, String> headers = new HashMap<String, String>();
        if (cacheItem.getEtag() != null) {
            headers.put("If-None-Match", cacheItem.getEtag());
        }
        if ((responseCode = (Integer)(response = VIPCfg.getInstance().getVipService().getHttpRequester().request(V2URL.getSupportedLocaleListURL(this.dto, VIPCfg.getInstance().getVipService().getHttpRequester().getBaseURL()), "GET", null, headers)).get("response_code")) != null && (responseCode.equals(200) || responseCode.equals(304))) {
            Long maxAgeMillis;
            long timestamp = response.get("response_timestamp") == null ? System.currentTimeMillis() : (Long)response.get("response_timestamp");
            String etag = URLUtils.createEtagString((Map)response.get("headers"));
            Long l = maxAgeMillis = response.get("max-age") == null ? null : (Long)response.get("max-age");
            if (responseCode.equals(200)) {
                Object dataObj;
                String responseStr = (String)response.get("body");
                if (responseStr != null && !responseStr.isEmpty() && (dataObj = this.getMessagesFromResponse(responseStr, "locales")) != null) {
                    List supportedLocales = ((JSONArray)dataObj).toList().stream().map(obj -> obj == null ? null : obj.toString()).collect(Collectors.toList());
                    HashMap<String, String> languageTags = new HashMap<String, String>();
                    if (!supportedLocales.isEmpty()) {
                        for (String languageTag : supportedLocales) {
                            languageTags.put(languageTag, languageTag);
                        }
                        cacheItem.setCacheItem(languageTags, etag, timestamp, maxAgeMillis);
                    }
                }
            } else {
                cacheItem.setCacheItem(null, etag, timestamp, maxAgeMillis);
            }
        }
    }
}

