/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vipclient.i18n.messages.service;

import com.vmware.vipclient.i18n.VIPCfg;
import com.vmware.vipclient.i18n.base.DataSourceEnum;
import com.vmware.vipclient.i18n.messages.dto.MessagesDTO;
import com.vmware.vipclient.i18n.messages.service.ProductService;
import com.vmware.vipclient.i18n.util.LocaleUtility;
import java.util.Locale;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BaseService {
    Logger logger = LoggerFactory.getLogger(BaseService.class);

    public void doLocaleMatching(MessagesDTO dto) {
        dto.setLocale(LocaleUtility.fmtToMappedLocale(dto.getLocale()).toLanguageTag());
        Set<Locale> supportedLocales = LocaleUtility.langTagtoLocaleSet(new ProductService(dto).getCachedSupportedLocales());
        Locale matchedLocale = LocaleUtility.pickupLocaleFromList(supportedLocales, Locale.forLanguageTag(dto.getLocale()));
        if (matchedLocale != null) {
            dto.setLocale(matchedLocale.toLanguageTag());
        }
    }

    public boolean proceed(MessagesDTO dto, DataSourceEnum dataSource) {
        ProductService ps = new ProductService(dto);
        Set<String> supportedLocales = ps.getCachedSupportedLocales(dataSource);
        this.logger.debug("supported languages: [{}]", supportedLocales);
        return supportedLocales.isEmpty() || supportedLocales.contains(dto.getLocale()) || "source".equals(dto.getLocale()) || VIPCfg.getInstance().isPseudo();
    }
}

