/*
 * Decompiled with CFR 0.152.
 */
package com.volcengine.auth;

import com.volcengine.ApiClient;
import com.volcengine.ApiException;
import com.volcengine.ApiResponse;
import com.volcengine.ContentType;
import com.volcengine.HttpMethod;
import com.volcengine.UniversalApi;
import com.volcengine.UniversalRequest;
import com.volcengine.auth.CredentialValue;
import com.volcengine.auth.Provider;
import com.volcengine.sign.Credentials;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;

public class StsAssumeRoleProvider
implements Provider {
    private String accessKey;
    private String securityKey;
    private String roleName;
    private String accountId;
    private String host = "sts.volcengineapi.com";
    private String region = "cn-north-1";
    private String schema = "https";
    private int timeout = 30;
    private int durationSeconds = 3600;
    private int expireBufferSeconds = 60;
    private CredentialValue credentialValue;
    private long expirationTime;
    private ApiClient apiClient;

    public StsAssumeRoleProvider(String accessKey, String securityKey, String roleName, String accountId) {
        this.accessKey = accessKey;
        this.securityKey = securityKey;
        this.roleName = roleName;
        this.accountId = accountId;
        this.apiClient = new ApiClient().setEndpoint(this.host).setCredentials(Credentials.getCredentials(accessKey, securityKey)).setRegion(this.region);
    }

    public String getAccessKey() {
        return this.accessKey;
    }

    public void setAccessKey(String accessKey) {
        this.accessKey = accessKey;
        this.apiClient.getCredentials().setAccessKey(accessKey);
    }

    public String getSecurityKey() {
        return this.securityKey;
    }

    public void setSecurityKey(String securityKey) {
        this.securityKey = securityKey;
        this.apiClient.getCredentials().setSecretKey(securityKey);
    }

    public String getRoleName() {
        return this.roleName;
    }

    public void setRoleName(String roleName) {
        this.roleName = roleName;
    }

    public String getAccountId() {
        return this.accountId;
    }

    public void setAccountId(String accountId) {
        this.accountId = accountId;
    }

    public String getHost() {
        return this.host;
    }

    public void setHost(String host) {
        this.host = host;
        this.apiClient.setEndpoint(host);
    }

    public String getRegion() {
        return this.region;
    }

    public void setRegion(String region) {
        this.region = region;
        this.apiClient.setRegion(region);
    }

    public String getSchema() {
        return this.schema;
    }

    public void setSchema(String schema) {
        this.schema = schema;
        this.apiClient.setDisableSSL(schema.equals("http"));
    }

    public int getTimeout() {
        return this.timeout;
    }

    public void setTimeout(int timeout) {
        this.timeout = timeout;
    }

    public int getDurationSeconds() {
        return this.durationSeconds;
    }

    public void setDurationSeconds(int durationSeconds) {
        this.durationSeconds = durationSeconds;
    }

    public int getExpireBufferSeconds() {
        return this.expireBufferSeconds;
    }

    public void setExpireBufferSeconds(int expireBufferSeconds) {
        this.expireBufferSeconds = expireBufferSeconds;
    }

    public CredentialValue getCredentialValue() {
        return this.credentialValue;
    }

    public void setCredentialValue(CredentialValue credentialValue) {
        this.credentialValue = credentialValue;
    }

    public long getExpirationTime() {
        return this.expirationTime;
    }

    public void setExpirationTime(long expirationTime) {
        this.expirationTime = expirationTime;
    }

    @Override
    public CredentialValue retrieve() throws ApiException {
        if (this.isExpired()) {
            this.refresh();
        }
        return this.credentialValue;
    }

    @Override
    public boolean isExpired() {
        return System.currentTimeMillis() / 1000L > this.expirationTime;
    }

    @Override
    public void refresh() throws ApiException {
        UniversalApi api = new UniversalApi(this.apiClient);
        UniversalRequest request = new UniversalRequest("sts", "AssumeRole", "2018-01-01", HttpMethod.GET, ContentType.Default);
        HashMap<String, Object> requestMap = new HashMap<String, Object>();
        requestMap.put("DurationSeconds", this.durationSeconds);
        requestMap.put("RoleSessionName", UUID.randomUUID().toString());
        requestMap.put("RoleTrn", String.format("trn:iam::%s:role/%s", this.accountId, this.roleName));
        long now = System.currentTimeMillis() / 1000L;
        ApiResponse<Map<String, Object>> apiResponse = api.doCallWithHttpInfo(request, requestMap);
        if (apiResponse.getStatusCode() == 200) {
            Map<String, Object> responseData = apiResponse.getData();
            try {
                if (responseData != null) {
                    Map responseMetadata;
                    if (responseData.get("ResponseMetadata") != null && (responseMetadata = (Map)responseData.get("ResponseMetadata")).get("Error") != null) {
                        throw new ApiException("StsAssumeRole request return Error");
                    }
                    if (responseData.get("Result") != null) {
                        Map resultMap = (Map)responseData.get("Result");
                        Object credentials = resultMap.get("Credentials");
                        Map credentialMap = (Map)credentials;
                        String accessKey = (String)credentialMap.get("AccessKeyId");
                        String secretAccessKey = (String)credentialMap.get("SecretAccessKey");
                        String sessionToken = (String)credentialMap.get("SessionToken");
                        this.credentialValue = new CredentialValue(accessKey, secretAccessKey, sessionToken, "StsCredentialProvider");
                        this.expirationTime = now + (long)this.durationSeconds - (long)this.expireBufferSeconds;
                        return;
                    }
                    throw new ApiException("StsAssumeRole request return Error");
                }
            }
            catch (Exception e) {
                throw new ApiException("StsAssumeRole Provider Error", apiResponse.getStatusCode(), apiResponse.getHeaders(), this.apiClient.getJSON().serialize(apiResponse.getData()));
            }
        }
        throw new ApiException("StsAssumeRole Provider Error", apiResponse.getStatusCode(), apiResponse.getHeaders(), this.apiClient.getJSON().serialize(apiResponse.getData()));
    }
}

