/*
 * Decompiled with CFR 0.152.
 */
package com.wandrell.pattern.outputter.yaml;

import com.wandrell.pattern.outputter.Outputter;
import java.io.BufferedWriter;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import org.yaml.snakeyaml.DumperOptions;
import org.yaml.snakeyaml.Yaml;

public final class YAMLOutputter
implements Outputter<Object> {
    private static final String ENCODING = "UTF-8";
    private final Yaml yaml;

    public YAMLOutputter() {
        DumperOptions options = new DumperOptions();
        options.setDefaultFlowStyle(DumperOptions.FlowStyle.BLOCK);
        this.yaml = new Yaml(options);
    }

    public final void output(Object value, OutputStream stream) throws UnsupportedEncodingException {
        this.output(value, new BufferedWriter(new OutputStreamWriter(stream, this.getEncoding())));
    }

    public final void output(Object value, Writer writer) {
        this.getYaml().dump(value, writer);
    }

    private final String getEncoding() {
        return ENCODING;
    }

    private final Yaml getYaml() {
        return this.yaml;
    }
}

