/*
 * Decompiled with CFR 0.152.
 */
package com.wandrell.pattern.parser.xml;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.wandrell.pattern.conf.XMLValidationType;
import com.wandrell.pattern.parser.xml.AbstractAttributesFilterXMLFileParser;
import com.wandrell.pattern.parser.xml.XMLFileParser;
import java.io.Reader;
import java.util.Collection;
import java.util.List;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.filter.Filters;
import org.jdom2.xpath.XPathExpression;
import org.jdom2.xpath.XPathFactory;

public final class FilteredEntriesXMLFileParser
extends AbstractAttributesFilterXMLFileParser {
    private final XMLFileParser baseParser = new XMLFileParser();
    private String expression;
    private final String nodeName;
    private XPathExpression<Element> xpath;

    public FilteredEntriesXMLFileParser(String node) {
        Preconditions.checkNotNull((Object)node, (Object)"Received a null pointer as node");
        this.nodeName = node;
    }

    public FilteredEntriesXMLFileParser(XMLValidationType validation, Reader validationFile, String node) {
        Preconditions.checkNotNull((Object)node, (Object)"Received a null pointer as node");
        this.nodeName = node;
        this.setValidation(validation, validationFile);
    }

    public final XMLValidationType getValidationType() {
        return this.getBaseParser().getValidationType();
    }

    public final Document parse(Reader input) {
        return this.filter(this.getBaseParser().parse(input));
    }

    public final void setValidation(XMLValidationType type, Reader file) {
        this.getBaseParser().setValidation(type, file);
    }

    public final String toString() {
        return MoreObjects.toStringHelper((Object)this).add("node", (Object)this.nodeName).add("rejected attributes", this.getRejectedAttributes()).add("required attributes", this.getRequiredAttributes()).toString();
    }

    private final String buildAttributesPredicate() {
        StringBuffer predicate = new StringBuffer();
        for (String attribute : this.getRequiredAttributesModifiable()) {
            if (predicate.length() > 0) {
                predicate.append(" and ");
            }
            predicate.append(String.format("@%s='%s'", attribute, "true"));
        }
        for (String attribute : this.getRejectedAttributesModifiable()) {
            if (predicate.length() > 0) {
                predicate.append(" and ");
            }
            predicate.append(String.format("@%s='%s'", attribute, "false"));
        }
        return predicate.toString();
    }

    private final Document filter(Document document) {
        Preconditions.checkNotNull((Object)document, (Object)"Received a null pointer as document");
        Preconditions.checkArgument((boolean)document.hasRootElement(), (Object)"Received a document with no root");
        String rootName = document.getRootElement().getName();
        List nodes = this.getXPathExpression().evaluate((Object)document.getRootElement());
        for (Element node : nodes) {
            node.detach();
        }
        Element root = new Element(rootName);
        root.setContent((Collection)nodes);
        return new Document(root);
    }

    private final XMLFileParser getBaseParser() {
        return this.baseParser;
    }

    private final String getExpression() {
        if (this.expression == null) {
            String attrbFilter = this.buildAttributesPredicate();
            this.expression = attrbFilter.length() > 0 ? String.format("//%s[%s]", this.getFilteredNodeName(), attrbFilter) : String.format("//%s", this.getFilteredNodeName());
        }
        return this.expression;
    }

    private final String getFilteredNodeName() {
        return this.nodeName;
    }

    private final XPathExpression<Element> getXPathExpression() {
        if (this.xpath == null) {
            this.xpath = XPathFactory.instance().compile(this.getExpression(), Filters.element());
        }
        return this.xpath;
    }

    @Override
    protected final void onAttributesChange() {
        this.expression = null;
        this.xpath = null;
    }
}

