/*
 * Decompiled with CFR 0.152.
 */
package com.wandrell.pattern.parser.xml;

import com.wandrell.pattern.parser.Parser;
import java.io.Reader;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.jdom2.Document;
import org.jdom2.JDOMException;
import org.jdom2.input.StAXStreamBuilder;

public final class NotValidatedXMLFileParser
implements Parser<Reader, Document> {
    private StAXStreamBuilder builder;

    @Override
    public final Document parse(Reader input) throws JDOMException {
        return this.getBuilder().build(this.getXMLReader(input));
    }

    private final StAXStreamBuilder getBuilder() {
        if (this.builder == null) {
            this.builder = new StAXStreamBuilder();
        }
        return this.builder;
    }

    private final XMLStreamReader getXMLReader(Reader reader) {
        XMLStreamReader staxReader;
        if (reader instanceof XMLStreamReader) {
            staxReader = (XMLStreamReader)((Object)reader);
        } else {
            XMLInputFactory factory = XMLInputFactory.newInstance();
            try {
                staxReader = factory.createXMLStreamReader(reader);
            }
            catch (XMLStreamException e) {
                throw new RuntimeException(e);
            }
        }
        return staxReader;
    }
}

