/*
 * Decompiled with CFR 0.152.
 */
package com.wandrell.pattern.parser.xml;

import com.google.common.base.Preconditions;
import com.wandrell.pattern.conf.XMLValidationType;
import com.wandrell.pattern.parser.Parser;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import org.apache.commons.io.IOUtils;
import org.jdom2.Document;
import org.jdom2.JDOMException;
import org.jdom2.input.SAXBuilder;
import org.jdom2.input.sax.XMLReaderJDOMFactory;
import org.jdom2.input.sax.XMLReaderXSDFactory;
import org.jdom2.input.sax.XMLReaders;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;

public final class ValidatedXMLFileParser
implements Parser<Reader, Document> {
    private SAXBuilder builder;
    private Boolean valChanged = true;
    private Reader valData;
    private XMLValidationType valType;

    public ValidatedXMLFileParser() {
        this.valType = XMLValidationType.NONE;
    }

    public ValidatedXMLFileParser(XMLValidationType validationType, Reader validationFile) {
        Preconditions.checkNotNull((Object)((Object)validationType), (Object)"Received a null pointer as validation type");
        Preconditions.checkNotNull((Object)validationFile, (Object)"Received a null pointer as validation file reader");
        this.valType = validationType;
        this.valData = validationFile;
    }

    public final XMLValidationType getValidationType() {
        return this.valType;
    }

    @Override
    public final Document parse(Reader input) throws JDOMException, IOException {
        return this.getBuilder().build(input);
    }

    public final void setValidation(XMLValidationType type, Reader file) {
        Preconditions.checkNotNull((Object)((Object)type), (Object)"Received a null pointer as validation type");
        if (type != XMLValidationType.NONE) {
            Preconditions.checkNotNull((Object)file, (Object)"Received a null pointer as validation file reader");
        }
        this.valType = type;
        this.valData = file;
        this.setValidationChanged(true);
    }

    private final SAXBuilder getBuilder() {
        if (this.builder == null) {
            this.builder = new SAXBuilder();
        }
        if (this.hasValidationChanged().booleanValue()) {
            this.builder = new SAXBuilder();
            switch (this.getValidationType()) {
                case XSD: {
                    this.builder.setXMLReaderFactory(this.getXSDValidationFactory());
                    break;
                }
                case DTD: {
                    this.builder.setXMLReaderFactory((XMLReaderJDOMFactory)XMLReaders.DTDVALIDATING);
                    this.builder.setEntityResolver(this.getEntityResolver());
                    break;
                }
                default: {
                    this.builder.setXMLReaderFactory(null);
                }
            }
            this.setValidationChanged(false);
        }
        return this.builder;
    }

    private final EntityResolver getEntityResolver() {
        return new EntityResolver(){
            private String dtd;

            @Override
            public final InputSource resolveEntity(String publicId, String systemId) throws IOException {
                InputSource source = new InputSource(IOUtils.toInputStream((String)this.getDTDFileContents(), (String)"UTF-8"));
                source.setPublicId(publicId);
                source.setSystemId(systemId);
                return source;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private final String getDTDFileContents() throws IOException {
                if (this.dtd == null) {
                    StringBuilder readDTD;
                    try (BufferedReader reader = null;){
                        reader = IOUtils.toBufferedReader((Reader)ValidatedXMLFileParser.this.getValidationData());
                        readDTD = new StringBuilder();
                        String line = reader.readLine();
                        while (line != null) {
                            readDTD.append(line);
                            line = reader.readLine();
                        }
                    }
                    this.dtd = readDTD.toString();
                }
                return this.dtd;
            }
        };
    }

    private final Reader getValidationData() {
        return this.valData;
    }

    private final XMLReaderJDOMFactory getXSDValidationFactory() {
        XMLReaderXSDFactory factoryValidation;
        try {
            Source[] sources = new Source[]{new StreamSource(this.getValidationData())};
            factoryValidation = new XMLReaderXSDFactory(sources);
        }
        catch (JDOMException e) {
            throw new RuntimeException(e);
        }
        return factoryValidation;
    }

    private final Boolean hasValidationChanged() {
        return this.valChanged;
    }

    private final void setValidationChanged(Boolean changed) {
        this.valChanged = changed;
    }
}

