/*
 * Decompiled with CFR 0.152.
 */
package com.wavefront.integrations;

import com.wavefront.integrations.WavefrontSender;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.UnknownHostException;
import java.nio.charset.Charset;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import javax.net.SocketFactory;
import org.apache.commons.lang.StringUtils;

public class Wavefront
implements WavefrontSender {
    private static final Pattern WHITESPACE = Pattern.compile("[\\s]+");
    private static final Charset UTF_8 = Charset.forName("UTF-8");
    private final InetSocketAddress address;
    private final SocketFactory socketFactory;
    private volatile Socket socket;
    private volatile Writer writer;
    private AtomicInteger failures = new AtomicInteger();
    private String source;

    public Wavefront(String agentHostName, int port) {
        this(agentHostName, port, SocketFactory.getDefault());
    }

    public Wavefront(String agentHostName, int port, SocketFactory socketFactory) {
        this(new InetSocketAddress(agentHostName, port), socketFactory);
    }

    public Wavefront(InetSocketAddress agentAddress) {
        this(agentAddress, SocketFactory.getDefault());
    }

    public Wavefront(InetSocketAddress agentAddress, SocketFactory socketFactory) {
        this.address = agentAddress;
        this.socketFactory = socketFactory;
    }

    private void initializeSource() throws UnknownHostException {
        if (this.source == null) {
            this.source = InetAddress.getLocalHost().getHostName();
        }
    }

    @Override
    public synchronized void connect() throws IllegalStateException, IOException {
        if (this.socket != null) {
            throw new IllegalStateException("Already connected");
        }
        InetSocketAddress address = new InetSocketAddress(this.address.getHostName(), this.address.getPort());
        if (address.getAddress() == null) {
            throw new UnknownHostException(address.getHostName());
        }
        this.socket = this.socketFactory.createSocket(address.getAddress(), address.getPort());
        this.writer = new BufferedWriter(new OutputStreamWriter(this.socket.getOutputStream(), UTF_8));
    }

    @Override
    public void send(String name, double value) throws IOException {
        this.initializeSource();
        this.internalSend(name, value, null, this.source, null);
    }

    @Override
    public void send(String name, double value, @Nullable Long timestamp) throws IOException {
        this.initializeSource();
        this.internalSend(name, value, null, this.source, null);
    }

    @Override
    public void send(String name, double value, @Nullable Long timestamp, String source) throws IOException {
        this.internalSend(name, value, timestamp, source, null);
    }

    @Override
    public void send(String name, double value, @Nullable Long timestamp, String source, @Nullable Map<String, String> pointTags) throws IOException {
        this.internalSend(name, value, timestamp, source, pointTags);
    }

    @Override
    public boolean isConnected() {
        return this.socket != null && this.socket.isConnected() && !this.socket.isClosed();
    }

    private void internalSend(String name, double value, @Nullable Long timestamp, String source, @Nullable Map<String, String> pointTags) throws IOException {
        if (!this.isConnected()) {
            this.socket = null;
            try {
                this.connect();
            }
            catch (IllegalStateException illegalStateException) {
                // empty catch block
            }
        }
        if (StringUtils.isBlank((String)name)) {
            throw new IllegalArgumentException("metric name cannot be blank");
        }
        if (StringUtils.isBlank((String)source)) {
            throw new IllegalArgumentException("source cannot be blank");
        }
        StringBuilder sb = new StringBuilder();
        try {
            sb.append(Wavefront.sanitize(name));
            sb.append(' ');
            sb.append(Double.toString(value));
            if (timestamp != null) {
                sb.append(' ');
                sb.append(Long.toString(timestamp));
            }
            sb.append(" host=");
            sb.append(Wavefront.sanitize(source));
            if (pointTags != null) {
                for (Map.Entry<String, String> tag : pointTags.entrySet()) {
                    if (StringUtils.isBlank((String)tag.getKey())) {
                        throw new IllegalArgumentException("point tag key cannot be blank");
                    }
                    if (StringUtils.isBlank((String)tag.getValue())) {
                        throw new IllegalArgumentException("point tag value cannot be blank");
                    }
                    sb.append(' ');
                    sb.append(Wavefront.sanitize(tag.getKey()));
                    sb.append('=');
                    sb.append(Wavefront.sanitize(tag.getValue()));
                }
            }
            sb.append('\n');
            this.writer.write(sb.toString());
        }
        catch (IOException e) {
            this.failures.incrementAndGet();
            throw e;
        }
    }

    @Override
    public int getFailureCount() {
        return this.failures.get();
    }

    @Override
    public void flush() throws IOException {
        if (this.writer != null) {
            this.writer.flush();
        }
    }

    @Override
    public synchronized void close() throws IOException {
        IOException exception = null;
        try {
            this.flush();
        }
        catch (IOException ex) {
            exception = ex;
        }
        if (this.socket != null) {
            this.socket.close();
        }
        this.socket = null;
        this.writer = null;
        if (exception != null) {
            throw exception;
        }
    }

    static String sanitize(String s) {
        String whitespaceSanitized = WHITESPACE.matcher(s).replaceAll("-");
        if (s.contains("\"") || s.contains("'")) {
            return "\"" + whitespaceSanitized.replaceAll("\"", "\\\\\"") + "\"";
        }
        return "\"" + whitespaceSanitized + "\"";
    }
}

