/*
 * Decompiled with CFR 0.152.
 */
package com.wavefront.integrations;

import com.wavefront.api.DataIngesterAPI;
import com.wavefront.common.NamedThreadFactory;
import com.wavefront.integrations.WavefrontSender;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.zip.GZIPOutputStream;
import javax.annotation.Nullable;
import javax.validation.constraints.NotNull;
import javax.ws.rs.core.Response;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WavefrontDirectSender
implements WavefrontSender,
Runnable {
    private static final String DEFAULT_SOURCE = "wavefrontDirectSender";
    private static final Logger LOGGER = LoggerFactory.getLogger(WavefrontDirectSender.class);
    private static final String quote = "\"";
    private static final String escapedQuote = "\\\"";
    private static final int MAX_QUEUE_SIZE = 50000;
    private static final int BATCH_SIZE = 10000;
    private ScheduledExecutorService scheduler;
    private final String server;
    private final String token;
    private DataIngesterAPI directService;
    private final LinkedBlockingQueue<String> buffer = new LinkedBlockingQueue(50000);

    public WavefrontDirectSender(String server, String token) {
        this.server = server;
        this.token = token;
    }

    @Override
    public synchronized void connect() throws IllegalStateException, IOException {
        if (this.directService == null) {
            this.directService = new DataIngesterService(this.server, this.token);
            this.scheduler = Executors.newScheduledThreadPool(1, (ThreadFactory)new NamedThreadFactory(DEFAULT_SOURCE));
            this.scheduler.scheduleAtFixedRate(this, 1L, 1L, TimeUnit.SECONDS);
        }
    }

    @Override
    public void send(String name, double value) throws IOException {
        this.addPoint(name, value, null, DEFAULT_SOURCE, null);
    }

    @Override
    public void send(String name, double value, @Nullable Long timestamp) throws IOException {
        this.addPoint(name, value, timestamp, DEFAULT_SOURCE, null);
    }

    @Override
    public void send(String name, double value, @Nullable Long timestamp, String source) throws IOException {
        this.addPoint(name, value, timestamp, source, null);
    }

    @Override
    public void send(String name, double value, String source, @Nullable Map<String, String> pointTags) throws IOException {
        this.addPoint(name, value, null, source, pointTags);
    }

    @Override
    public void send(String name, double value, @Nullable Long timestamp, String source, @Nullable Map<String, String> pointTags) throws IOException {
        this.addPoint(name, value, timestamp, source, pointTags);
    }

    private void addPoint(@NotNull String name, double value, @Nullable Long timestamp, @NotNull String source, @Nullable Map<String, String> pointTags) throws IOException {
        String point = WavefrontDirectSender.pointToString(name, value, timestamp, source, pointTags);
        if (point != null && !this.buffer.offer(point)) {
            LOGGER.debug("Buffer full, dropping point " + name);
        }
    }

    private static String escapeQuotes(String raw) {
        return StringUtils.replace((String)raw, (String)quote, (String)escapedQuote);
    }

    @Nullable
    static String pointToString(String name, double value, @Nullable Long timestamp, String source, @Nullable Map<String, String> pointTags) {
        if (StringUtils.isBlank((String)name) || StringUtils.isBlank((String)source)) {
            LOGGER.debug("Invalid point: Empty name/source");
            return null;
        }
        StringBuilder sb = new StringBuilder(quote).append(WavefrontDirectSender.escapeQuotes(name)).append(quote).append(" ").append(Double.toString(value)).append(" ");
        if (timestamp != null) {
            sb.append(Long.toString(timestamp)).append(" ");
        }
        sb.append("source=").append(quote).append(WavefrontDirectSender.escapeQuotes(source)).append(quote);
        if (pointTags != null) {
            for (Map.Entry<String, String> entry : pointTags.entrySet()) {
                sb.append(' ').append(quote).append(WavefrontDirectSender.escapeQuotes(entry.getKey())).append(quote).append("=").append(quote).append(WavefrontDirectSender.escapeQuotes(entry.getValue())).append(quote);
            }
        }
        return sb.toString();
    }

    @Override
    public void flush() throws IOException {
        this.internalFlush();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void internalFlush() throws IOException {
        if (!this.isConnected()) {
            return;
        }
        List<String> points = this.getPointsBatch();
        if (points.isEmpty()) {
            return;
        }
        try (Response response = null;
             InputStream is = this.pointsToStream(points);){
            response = this.directService.report("graphite_v2", is);
            if (response.getStatusInfo().getFamily() == Response.Status.Family.SERVER_ERROR || response.getStatusInfo().getFamily() == Response.Status.Family.CLIENT_ERROR) {
                LOGGER.debug("Error reporting points, respStatus=" + response.getStatus());
                try {
                    this.buffer.addAll(points);
                }
                catch (Exception ex) {
                    LOGGER.debug("Buffer full, dropping attempted points");
                }
            }
        }
    }

    private InputStream pointsToStream(List<String> points) {
        StringBuilder sb = new StringBuilder();
        boolean newLine = false;
        for (String point : points) {
            if (newLine) {
                sb.append("\n");
            }
            sb.append(point);
            newLine = true;
        }
        return new ByteArrayInputStream(sb.toString().getBytes());
    }

    private List<String> getPointsBatch() {
        int blockSize = Math.min(this.buffer.size(), 10000);
        ArrayList<String> points = new ArrayList<String>(blockSize);
        this.buffer.drainTo(points, blockSize);
        return points;
    }

    @Override
    public synchronized boolean isConnected() {
        return this.directService != null;
    }

    @Override
    public int getFailureCount() {
        return 0;
    }

    @Override
    public synchronized void close() throws IOException {
        if (this.directService != null) {
            try {
                this.scheduler.shutdownNow();
            }
            catch (SecurityException ex) {
                LOGGER.debug("shutdown error", (Throwable)ex);
            }
            this.scheduler = null;
            this.directService = null;
        }
    }

    @Override
    public void run() {
        try {
            this.internalFlush();
        }
        catch (Throwable ex) {
            LOGGER.debug("Unable to report to Wavefront", ex);
        }
    }

    private static final class DataIngesterService
    implements DataIngesterAPI {
        private final String token;
        private final URI uri;
        private static final String BAD_REQUEST = "Bad client request";
        private static final int CONNECT_TIMEOUT = 30000;
        private static final int READ_TIMEOUT = 10000;

        public DataIngesterService(String server, String token) throws IOException {
            this.token = token;
            this.uri = URI.create(server);
        }

        public Response report(String format, InputStream stream) throws IOException {
            String respMsg;
            int statusCode;
            block16: {
                statusCode = 400;
                respMsg = BAD_REQUEST;
                HttpURLConnection urlConn = null;
                try {
                    URL url = new URL(this.uri.getScheme(), this.uri.getHost(), this.uri.getPort(), String.format("/report?f=" + format, new Object[0]));
                    urlConn = (HttpURLConnection)url.openConnection();
                    urlConn.setDoOutput(true);
                    urlConn.addRequestProperty("Content-Type", "application/octet-stream");
                    urlConn.addRequestProperty("Content-Encoding", "gzip");
                    urlConn.addRequestProperty("Authorization", "Bearer " + this.token);
                    urlConn.setConnectTimeout(30000);
                    urlConn.setReadTimeout(10000);
                    try (GZIPOutputStream gzipOS = new GZIPOutputStream(urlConn.getOutputStream());){
                        byte[] buffer = new byte[4096];
                        int len = 0;
                        while ((len = stream.read(buffer)) > 0) {
                            gzipOS.write(buffer);
                        }
                        gzipOS.flush();
                    }
                    statusCode = urlConn.getResponseCode();
                    respMsg = urlConn.getResponseMessage();
                    this.readAndClose(urlConn.getInputStream());
                }
                catch (IOException ex) {
                    if (urlConn == null) break block16;
                    statusCode = urlConn.getResponseCode();
                    respMsg = urlConn.getResponseMessage();
                    this.readAndClose(urlConn.getErrorStream());
                }
            }
            return Response.status((int)statusCode).entity((Object)respMsg).build();
        }

        private void readAndClose(InputStream stream) throws IOException {
            if (stream != null) {
                try (InputStream is = stream;){
                    byte[] buffer = new byte[4096];
                    int ret = 0;
                    while ((ret = is.read(buffer)) > 0) {
                    }
                }
            }
        }
    }
}

