/*
 * Decompiled with CFR 0.152.
 */
package com.wavefront.ingester;

import com.wavefront.ingester.AbstractIngesterFormatter;
import com.wavefront.ingester.StringParser;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import wavefront.report.ReportEvent;

public class EventIngesterFormatter
extends AbstractIngesterFormatter<ReportEvent> {
    private EventIngesterFormatter(List<AbstractIngesterFormatter.FormatterElement<ReportEvent>> elements) {
        super(elements);
    }

    public static AbstractIngesterFormatter.IngesterFormatBuilder<ReportEvent> newBuilder() {
        return new EventIngesterFormatBuilder();
    }

    @Override
    public ReportEvent drive(String input, Supplier<String> defaultHostNameSupplier, String customerId, @Nullable List<String> customSourceTags) {
        ReportEvent event = new ReportEvent();
        StringParser parser = new StringParser(input);
        event.setHosts(new ArrayList<String>());
        event.setAnnotations(new HashMap<String, String>());
        try {
            for (AbstractIngesterFormatter.FormatterElement element : this.elements) {
                element.consume(parser, event);
            }
        }
        catch (Exception ex) {
            throw new RuntimeException("Could not parse: " + input, ex);
        }
        Iterator<Map.Entry<String, List<String>>> iter = event.getDimensions().entrySet().iterator();
        block12: while (iter.hasNext()) {
            Map.Entry<String, List<String>> entry = iter.next();
            switch (entry.getKey()) {
                case "host": {
                    event.setHosts(entry.getValue());
                    iter.remove();
                    continue block12;
                }
                case "tag": 
                case "eventTag": {
                    event.setTags(entry.getValue());
                    iter.remove();
                    continue block12;
                }
            }
            if (entry.getValue().size() != 1) continue;
            event.getAnnotations().put(entry.getKey(), entry.getValue().get(0));
            iter.remove();
        }
        if (event.getDimensions().isEmpty()) {
            event.setDimensions(null);
        }
        if (event.getEndTime() == null || event.getEndTime() == 0L) {
            event.setEndTime(event.getStartTime() + 1L);
        }
        return event;
    }

    public static class EventIngesterFormatBuilder
    extends AbstractIngesterFormatter.IngesterFormatBuilder<ReportEvent> {
        public EventIngesterFormatter build() {
            return new EventIngesterFormatter(this.elements);
        }
    }
}

