/*
 * Decompiled with CFR 0.152.
 */
package com.wavefront.ingester;

import com.google.common.annotations.VisibleForTesting;
import com.wavefront.common.SerializerUtils;
import java.util.function.Function;
import wavefront.report.Span;

public class SpanSerializer
implements Function<Span, String> {
    @Override
    public String apply(Span span) {
        return SpanSerializer.spanToString(span);
    }

    @VisibleForTesting
    static String spanToString(Span span) {
        StringBuilder sb = new StringBuilder();
        SerializerUtils.appendQuoted(sb, span.getName());
        sb.append(' ');
        if (span.getSource() != null) {
            sb.append("source=");
            SerializerUtils.appendQuoted(sb, span.getSource()).append(' ');
        }
        if (span.getSpanId() != null) {
            sb.append("spanId=");
            SerializerUtils.appendQuoted(sb, span.getSpanId()).append(' ');
        }
        if (span.getTraceId() != null) {
            sb.append("traceId=");
            SerializerUtils.appendQuoted(sb, span.getTraceId());
        }
        SerializerUtils.appendAnnotations(sb, span.getAnnotations()).append(' ').append(span.getStartMillis()).append(' ').append(span.getDuration());
        return sb.toString();
    }
}

