/*
 * Decompiled with CFR 0.152.
 */
package com.wavefront.ingester;

import com.google.common.base.Function;
import com.wavefront.ingester.Ingester;
import io.netty.bootstrap.ServerBootstrap;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelOption;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.nio.NioServerSocketChannel;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

public class TcpIngester
extends Ingester {
    private static final Logger logger = Logger.getLogger(TcpIngester.class.getCanonicalName());

    public TcpIngester(List<Function<Channel, ChannelHandler>> decoders, ChannelHandler commandHandler, int port) {
        super(decoders, commandHandler, port);
    }

    public TcpIngester(ChannelInitializer initializer, int port) {
        super(initializer, port);
    }

    @Override
    public void run() {
        ServerBootstrap b = new ServerBootstrap();
        NioEventLoopGroup parentGroup = new NioEventLoopGroup(1);
        NioEventLoopGroup childGroup = new NioEventLoopGroup();
        try {
            ((ServerBootstrap)((ServerBootstrap)((ServerBootstrap)b.group((EventLoopGroup)parentGroup, (EventLoopGroup)childGroup).channel(NioServerSocketChannel.class)).option(ChannelOption.SO_BACKLOG, (Object)1024)).localAddress(this.listeningPort)).childHandler((ChannelHandler)this.initializer);
            if (this.parentChannelOptions != null) {
                for (Map.Entry entry : this.parentChannelOptions.entrySet()) {
                    b.option((ChannelOption)entry.getKey(), entry.getValue());
                }
            }
            if (this.childChannelOptions != null) {
                for (Map.Entry entry : this.childChannelOptions.entrySet()) {
                    b.childOption((ChannelOption)entry.getKey(), entry.getValue());
                }
            }
            ChannelFuture f = b.bind().sync();
            f.channel().closeFuture().sync();
        }
        catch (InterruptedException e) {
            logger.log(Level.WARNING, "Interrupted");
            parentGroup.shutdownGracefully();
            childGroup.shutdownGracefully();
            logger.info("Listener on port " + String.valueOf(this.listeningPort) + " shut down");
        }
    }
}

