/*
 * Decompiled with CFR 0.152.
 */
package com.wavefront.ingester;

import com.google.common.base.Charsets;
import com.google.common.base.Function;
import com.wavefront.ingester.TcpIngester;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.handler.codec.LineBasedFrameDecoder;
import io.netty.handler.codec.string.StringDecoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.annotation.Nullable;
import org.apache.commons.lang.StringUtils;

public class StringLineIngester
extends TcpIngester {
    private static final String PUSH_DATA_DELIMETER = "\n";
    private static final int MAXIMUM_FRAME_LENGTH_DEFAULT = 4096;

    public StringLineIngester(List<Function<Channel, ChannelHandler>> decoders, ChannelHandler commandHandler, int port, int maxLength) {
        super(StringLineIngester.createDecoderList(decoders, maxLength), commandHandler, port);
    }

    public StringLineIngester(List<Function<Channel, ChannelHandler>> decoders, ChannelHandler commandHandler, int port) {
        this(decoders, commandHandler, port, 4096);
    }

    public StringLineIngester(ChannelHandler commandHandler, int port, int maxLength) {
        super(StringLineIngester.createDecoderList(null, maxLength), commandHandler, port);
    }

    public StringLineIngester(ChannelHandler commandHandler, int port) {
        this(commandHandler, port, 4096);
    }

    private static List<Function<Channel, ChannelHandler>> createDecoderList(@Nullable List<Function<Channel, ChannelHandler>> decoders, final int maxLength) {
        ArrayList<Object> copy = decoders == null ? new ArrayList() : new ArrayList<Function<Channel, ChannelHandler>>(decoders);
        copy.add(0, new Function<Channel, ChannelHandler>(){

            public ChannelHandler apply(Channel input) {
                return new LineBasedFrameDecoder(maxLength, true, false);
            }
        });
        copy.add(1, new Function<Channel, ChannelHandler>(){

            public ChannelHandler apply(Channel input) {
                return new StringDecoder(Charsets.UTF_8);
            }
        });
        return copy;
    }

    public static List<String> unjoinPushData(String pushData) {
        return Arrays.asList(StringUtils.split((String)pushData, (String)PUSH_DATA_DELIMETER));
    }

    public static String joinPushData(List<String> pushData) {
        return StringUtils.join(pushData, (String)PUSH_DATA_DELIMETER);
    }

    public static List<Integer> indexPushData(String pushData) {
        ArrayList<Integer> index = new ArrayList<Integer>();
        index.add(0);
        int lastIndex = pushData.indexOf(PUSH_DATA_DELIMETER);
        int delimiterLength = PUSH_DATA_DELIMETER.length();
        while (lastIndex != -1) {
            index.add(lastIndex);
            index.add(lastIndex + delimiterLength);
            lastIndex = pushData.indexOf(PUSH_DATA_DELIMETER, lastIndex + delimiterLength);
        }
        index.add(pushData.length());
        return index;
    }

    public static int pushDataSize(String pushData) {
        int length = StringUtils.countMatches((String)pushData, (String)PUSH_DATA_DELIMETER);
        return length > 0 ? length + 1 : (pushData.length() > 0 ? 1 : 0);
    }
}

