/*
 * Decompiled with CFR 0.152.
 */
package com.wavefront.metrics;

import com.google.common.base.Throwables;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.net.Socket;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.net.SocketFactory;

public class ReconnectingSocket {
    protected static final Logger logger = Logger.getLogger(ReconnectingSocket.class.getCanonicalName());
    private final String host;
    private final int port;
    private final SocketFactory socketFactory;
    private Socket underlyingSocket;
    private BufferedOutputStream stream;

    public ReconnectingSocket(String host, int port, SocketFactory socketFactory) throws IOException {
        this.host = host;
        this.port = port;
        this.socketFactory = socketFactory;
        this.stream = null;
        this.resetSocket();
    }

    public ReconnectingSocket(String host, int port) throws IOException {
        this(host, port, SocketFactory.getDefault());
    }

    private void resetSocket() throws IOException {
        try {
            if (this.stream != null) {
                this.stream.close();
            }
        }
        catch (Throwable throwable) {
            this.underlyingSocket = this.socketFactory.createSocket(this.host, this.port);
            this.stream = new BufferedOutputStream(this.underlyingSocket.getOutputStream());
            logger.log(Level.INFO, String.format("Successfully reset connection to %s:%d", this.host, this.port));
            throw throwable;
        }
        this.underlyingSocket = this.socketFactory.createSocket(this.host, this.port);
        this.stream = new BufferedOutputStream(this.underlyingSocket.getOutputStream());
        logger.log(Level.INFO, String.format("Successfully reset connection to %s:%d", this.host, this.port));
    }

    public void write(String message) throws Exception {
        try {
            this.stream.write(message.getBytes());
        }
        catch (Exception e) {
            try {
                logger.log(Level.WARNING, "Attempting to reset socket connection.", e);
                this.resetSocket();
                this.stream.write(message.getBytes());
            }
            catch (Exception e2) {
                throw Throwables.propagate((Throwable)e2);
            }
        }
    }

    public void flush() throws IOException {
        try {
            this.stream.flush();
        }
        catch (Exception e) {
            logger.log(Level.WARNING, "Attempting to reset socket connection.", e);
            this.resetSocket();
        }
    }

    public void close() throws IOException {
        try {
            this.flush();
        }
        finally {
            this.stream.close();
        }
    }
}

