/*
 * Decompiled with CFR 0.152.
 */
package com.wavefront.sdk.direct.ingestion;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.wavefront.sdk.common.NamedThreadFactory;
import com.wavefront.sdk.common.Pair;
import com.wavefront.sdk.common.Utils;
import com.wavefront.sdk.common.WavefrontSender;
import com.wavefront.sdk.common.annotation.Nullable;
import com.wavefront.sdk.common.metrics.WavefrontSdkCounter;
import com.wavefront.sdk.common.metrics.WavefrontSdkMetricsRegistry;
import com.wavefront.sdk.direct.ingestion.DataIngesterAPI;
import com.wavefront.sdk.direct.ingestion.DataIngesterService;
import com.wavefront.sdk.entities.histograms.HistogramGranularity;
import com.wavefront.sdk.entities.tracing.SpanLog;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.management.ManagementFactory;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;

public class WavefrontDirectIngestionClient
implements WavefrontSender,
Runnable {
    private static final Logger logger = Logger.getLogger(WavefrontDirectIngestionClient.class.getCanonicalName());
    private final String defaultSource;
    private final String clientId;
    private final int batchSize;
    private final LinkedBlockingQueue<String> metricsBuffer;
    private final LinkedBlockingQueue<String> histogramsBuffer;
    private final LinkedBlockingQueue<String> tracingSpansBuffer;
    private final LinkedBlockingQueue<String> spanLogsBuffer;
    private final DataIngesterAPI directService;
    private final ScheduledExecutorService scheduler;
    private final WavefrontSdkMetricsRegistry sdkMetricsRegistry;
    private final WavefrontSdkCounter pointsValid;
    private final WavefrontSdkCounter pointsInvalid;
    private final WavefrontSdkCounter pointsDropped;
    private final WavefrontSdkCounter pointReportErrors;
    private final WavefrontSdkCounter histogramsValid;
    private final WavefrontSdkCounter histogramsInvalid;
    private final WavefrontSdkCounter histogramsDropped;
    private final WavefrontSdkCounter histogramReportErrors;
    private final WavefrontSdkCounter spansValid;
    private final WavefrontSdkCounter spansInvalid;
    private final WavefrontSdkCounter spansDropped;
    private final WavefrontSdkCounter spanReportErrors;
    private final WavefrontSdkCounter spanLogsValid;
    private final WavefrontSdkCounter spanLogsInvalid;
    private final WavefrontSdkCounter spanLogsDropped;
    private final WavefrontSdkCounter spanLogReportErrors;

    private WavefrontDirectIngestionClient(Builder builder) {
        String tempSource = "unknown";
        try {
            tempSource = InetAddress.getLocalHost().getHostName();
        }
        catch (UnknownHostException ex) {
            logger.log(Level.WARNING, "Unable to resolve local host name. Source will default to 'unknown'", ex);
        }
        this.defaultSource = tempSource;
        this.batchSize = builder.batchSize;
        this.metricsBuffer = new LinkedBlockingQueue(builder.maxQueueSize);
        this.histogramsBuffer = new LinkedBlockingQueue(builder.maxQueueSize);
        this.tracingSpansBuffer = new LinkedBlockingQueue(builder.maxQueueSize);
        this.spanLogsBuffer = new LinkedBlockingQueue(builder.maxQueueSize);
        this.directService = new DataIngesterService(builder.server, builder.token);
        this.scheduler = Executors.newScheduledThreadPool(1, new NamedThreadFactory("wavefrontDirectSender"));
        this.scheduler.scheduleAtFixedRate(this, 1L, builder.flushIntervalSeconds, TimeUnit.SECONDS);
        String processId = ManagementFactory.getRuntimeMXBean().getName().split("@")[0];
        this.sdkMetricsRegistry = new WavefrontSdkMetricsRegistry.Builder(this).prefix("~sdk.java.core.sender.direct").tag("pid", processId).build();
        this.sdkMetricsRegistry.newGauge("points.queue.size", this.metricsBuffer::size);
        this.sdkMetricsRegistry.newGauge("points.queue.remaining_capacity", this.metricsBuffer::remainingCapacity);
        this.pointsValid = this.sdkMetricsRegistry.newCounter("points.valid");
        this.pointsInvalid = this.sdkMetricsRegistry.newCounter("points.invalid");
        this.pointsDropped = this.sdkMetricsRegistry.newCounter("points.dropped");
        this.pointReportErrors = this.sdkMetricsRegistry.newCounter("points.report.errors");
        this.sdkMetricsRegistry.newGauge("histograms.queue.size", this.histogramsBuffer::size);
        this.sdkMetricsRegistry.newGauge("histograms.queue.remaining_capacity", this.histogramsBuffer::remainingCapacity);
        this.histogramsValid = this.sdkMetricsRegistry.newCounter("histograms.valid");
        this.histogramsInvalid = this.sdkMetricsRegistry.newCounter("histograms.invalid");
        this.histogramsDropped = this.sdkMetricsRegistry.newCounter("histograms.dropped");
        this.histogramReportErrors = this.sdkMetricsRegistry.newCounter("histograms.report.errors");
        this.sdkMetricsRegistry.newGauge("spans.queue.size", this.tracingSpansBuffer::size);
        this.sdkMetricsRegistry.newGauge("spans.queue.remaining_capacity", this.tracingSpansBuffer::remainingCapacity);
        this.spansValid = this.sdkMetricsRegistry.newCounter("spans.valid");
        this.spansInvalid = this.sdkMetricsRegistry.newCounter("spans.invalid");
        this.spansDropped = this.sdkMetricsRegistry.newCounter("spans.dropped");
        this.spanReportErrors = this.sdkMetricsRegistry.newCounter("spans.report.errors");
        this.sdkMetricsRegistry.newGauge("span_logs.queue.size", this.spanLogsBuffer::size);
        this.sdkMetricsRegistry.newGauge("span_logs.queue.remaining_capacity", this.spanLogsBuffer::remainingCapacity);
        this.spanLogsValid = this.sdkMetricsRegistry.newCounter("span_logs.valid");
        this.spanLogsInvalid = this.sdkMetricsRegistry.newCounter("span_logs.invalid");
        this.spanLogsDropped = this.sdkMetricsRegistry.newCounter("span_logs.dropped");
        this.spanLogReportErrors = this.sdkMetricsRegistry.newCounter("span_logs.report.errors");
        this.clientId = builder.server;
    }

    @Override
    public String getClientId() {
        return this.clientId;
    }

    @Override
    public void sendMetric(String name, double value, @Nullable Long timestamp, @Nullable String source, @Nullable Map<String, String> tags) throws IOException {
        String point;
        try {
            point = Utils.metricToLineData(name, value, timestamp, source, tags, this.defaultSource);
            this.pointsValid.inc();
        }
        catch (IllegalArgumentException e) {
            this.pointsInvalid.inc();
            throw e;
        }
        if (!this.metricsBuffer.offer(point)) {
            this.pointsDropped.inc();
            logger.log(Level.WARNING, "Buffer full, dropping metric point: " + point);
        }
    }

    @Override
    public void sendFormattedMetric(String point) throws IOException {
        String finalPoint;
        if (point == null || "".equals(point.trim())) {
            this.pointsInvalid.inc();
            throw new IllegalArgumentException("point must be non-null and in WF data format");
        }
        this.pointsValid.inc();
        String string = finalPoint = point.endsWith("\n") ? point : point + "\n";
        if (!this.metricsBuffer.offer(finalPoint)) {
            this.pointsDropped.inc();
            logger.log(Level.WARNING, "Buffer full, dropping metric point: " + finalPoint);
        }
    }

    @Override
    public void sendDistribution(String name, List<Pair<Double, Integer>> centroids, Set<HistogramGranularity> histogramGranularities, @Nullable Long timestamp, @Nullable String source, @Nullable Map<String, String> tags) throws IOException {
        String histograms;
        try {
            histograms = Utils.histogramToLineData(name, centroids, histogramGranularities, timestamp, source, tags, this.defaultSource);
            this.histogramsValid.inc();
        }
        catch (IllegalArgumentException e) {
            this.histogramsInvalid.inc();
            throw e;
        }
        if (!this.histogramsBuffer.offer(histograms)) {
            this.histogramsDropped.inc();
            logger.log(Level.WARNING, "Buffer full, dropping histograms: " + histograms);
        }
    }

    @Override
    public void sendSpan(String name, long startMillis, long durationMillis, @Nullable String source, UUID traceId, UUID spanId, @Nullable List<UUID> parents, @Nullable List<UUID> followsFrom, @Nullable List<Pair<String, String>> tags, @Nullable List<SpanLog> spanLogs) throws IOException {
        String span;
        try {
            span = Utils.tracingSpanToLineData(name, startMillis, durationMillis, source, traceId, spanId, parents, followsFrom, tags, spanLogs, this.defaultSource);
            this.spansValid.inc();
        }
        catch (IllegalArgumentException e) {
            this.spansInvalid.inc();
            throw e;
        }
        if (this.tracingSpansBuffer.offer(span)) {
            if (spanLogs != null && !spanLogs.isEmpty()) {
                this.sendSpanLogs(traceId, spanId, spanLogs);
            }
        } else {
            this.spansDropped.inc();
            if (spanLogs != null && !spanLogs.isEmpty()) {
                this.spanLogsDropped.inc();
            }
            logger.log(Level.WARNING, "Buffer full, dropping span: " + span);
        }
    }

    private void sendSpanLogs(UUID traceId, UUID spanId, List<SpanLog> spanLogs) {
        try {
            String spanLogsJson = Utils.spanLogsToLineData(traceId, spanId, spanLogs);
            this.spanLogsValid.inc();
            if (!this.spanLogsBuffer.offer(spanLogsJson)) {
                this.spanLogsDropped.inc();
                logger.log(Level.WARNING, "Buffer full, dropping spanLogs: " + spanLogsJson);
            }
        }
        catch (JsonProcessingException e) {
            this.spanLogsInvalid.inc();
            logger.log(Level.WARNING, "unable to serialize span logs to json: traceId:" + traceId + " spanId:" + spanId + " spanLogs:" + spanLogs);
        }
    }

    @Override
    public void run() {
        try {
            this.flush();
        }
        catch (Throwable ex) {
            logger.log(Level.WARNING, "Unable to report to Wavefront cluster", ex);
        }
    }

    @Override
    public void flush() throws IOException {
        this.internalFlush(this.metricsBuffer, "wavefront", "points", this.pointsDropped, this.pointReportErrors);
        this.internalFlush(this.histogramsBuffer, "histogram", "histograms", this.histogramsDropped, this.histogramReportErrors);
        this.internalFlush(this.tracingSpansBuffer, "trace", "spans", this.spansDropped, this.spanReportErrors);
        this.internalFlush(this.spanLogsBuffer, "spanLogs", "span_logs", this.spanLogsDropped, this.spanLogReportErrors);
    }

    private void internalFlush(LinkedBlockingQueue<String> buffer, String format, String entityPrefix, WavefrontSdkCounter dropped, WavefrontSdkCounter reportErrors) throws IOException {
        block20: {
            List<String> batch = this.getBatch(buffer);
            if (batch.isEmpty()) {
                return;
            }
            try (InputStream is = this.batchToStream(batch);){
                int statusCode = this.directService.report(format, is);
                this.sdkMetricsRegistry.newCounter(entityPrefix + ".report." + statusCode).inc();
                if (400 > statusCode || statusCode > 599) break block20;
                logger.log(Level.WARNING, "Error reporting points, respStatus=" + statusCode);
                int numAddedBackToBuffer = 0;
                for (String item : batch) {
                    if (buffer.offer(item)) {
                        ++numAddedBackToBuffer;
                        continue;
                    }
                    dropped.inc(batch.size() - numAddedBackToBuffer);
                    logger.log(Level.WARNING, "Buffer full, dropping attempted points");
                    return;
                }
            }
            catch (IOException ex) {
                dropped.inc(batch.size());
                reportErrors.inc();
                throw ex;
            }
        }
    }

    private List<String> getBatch(LinkedBlockingQueue<String> buffer) {
        int blockSize = Math.min(buffer.size(), this.batchSize);
        ArrayList<String> points = new ArrayList<String>(blockSize);
        buffer.drainTo(points, blockSize);
        return points;
    }

    private InputStream batchToStream(List<String> batch) {
        StringBuilder sb = new StringBuilder();
        for (String item : batch) {
            sb.append(item);
        }
        return new ByteArrayInputStream(sb.toString().getBytes());
    }

    @Override
    public int getFailureCount() {
        return (int)(this.pointReportErrors.count() + this.histogramReportErrors.count() + this.spanReportErrors.count());
    }

    @Override
    public synchronized void close() {
        try {
            this.flush();
        }
        catch (IOException e) {
            logger.log(Level.WARNING, "error flushing buffer", e);
        }
        this.sdkMetricsRegistry.close();
        try {
            this.scheduler.shutdownNow();
        }
        catch (SecurityException ex) {
            logger.log(Level.WARNING, "shutdown error", ex);
        }
    }

    public static class Builder {
        private final String server;
        private final String token;
        private int maxQueueSize = 50000;
        private int batchSize = 10000;
        private int flushIntervalSeconds = 1;

        public Builder(String server, String token) {
            this.server = server;
            this.token = token;
        }

        public Builder maxQueueSize(int maxQueueSize) {
            this.maxQueueSize = maxQueueSize;
            return this;
        }

        public Builder batchSize(int batchSize) {
            this.batchSize = batchSize;
            return this;
        }

        public Builder flushIntervalSeconds(int flushIntervalSeconds) {
            this.flushIntervalSeconds = flushIntervalSeconds;
            return this;
        }

        public WavefrontDirectIngestionClient build() {
            return new WavefrontDirectIngestionClient(this);
        }
    }
}

