/*
 * Decompiled with CFR 0.152.
 */
package com.wavefront.sdk.entities.tracing.sampling;

import com.wavefront.sdk.entities.tracing.sampling.Sampler;

public class RateSampler
implements Sampler {
    private static final double MIN_SAMPLING_RATE = 0.0;
    private static final double MAX_SAMPLING_RATE = 1.0;
    private static final long MOD_FACTOR = 10000L;
    private volatile long boundary;

    public RateSampler(double samplingRate) {
        this.setSamplingRate(samplingRate);
    }

    @Override
    public boolean sample(String operationName, long traceId, long duration) {
        return Math.abs(traceId % 10000L) <= this.boundary;
    }

    public static boolean sample(double samplingRate, long traceId, long duration) {
        long localBoundary = RateSampler.calculateBoundary(samplingRate);
        return Math.abs(traceId % 10000L) <= localBoundary;
    }

    @Override
    public boolean isEarly() {
        return true;
    }

    public void setSamplingRate(double samplingRate) {
        this.boundary = RateSampler.calculateBoundary(samplingRate);
    }

    private static long calculateBoundary(double samplingRate) {
        if (samplingRate < 0.0 || samplingRate > 1.0) {
            throw new IllegalArgumentException("sampling rate must be between 0.0 and 1.0");
        }
        return (long)(samplingRate * 10000.0);
    }
}

