/*
 * Decompiled with CFR 0.152.
 */
package com.wavefront.sdk.common.clients.service;

import com.wavefront.java_sdk.com.google.common.annotations.VisibleForTesting;
import com.wavefront.sdk.common.annotation.Nullable;
import com.wavefront.sdk.common.clients.service.ReportAPI;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.util.zip.GZIPOutputStream;

public class ReportingService
implements ReportAPI {
    private final String token;
    private final URI uri;
    private static final int CONNECT_TIMEOUT_MILLIS = 30000;
    private static final int READ_TIMEOUT_MILLIS = 10000;
    private static final int BUFFER_SIZE = 4096;

    public ReportingService(String server, @Nullable String token) {
        this.uri = URI.create(server);
        this.token = token;
    }

    @Override
    public int send(String format, InputStream stream) throws IOException {
        int statusCode;
        block17: {
            HttpURLConnection urlConn = null;
            statusCode = 400;
            try {
                URL url = ReportingService.getReportingUrl(this.uri, format);
                urlConn = (HttpURLConnection)url.openConnection();
                urlConn.setDoOutput(true);
                urlConn.setRequestMethod("POST");
                urlConn.addRequestProperty("Content-Type", "application/octet-stream");
                urlConn.addRequestProperty("Content-Encoding", "gzip");
                if (this.token != null && !this.token.equals("")) {
                    urlConn.addRequestProperty("Authorization", "Bearer " + this.token);
                }
                urlConn.setConnectTimeout(30000);
                urlConn.setReadTimeout(10000);
                try (GZIPOutputStream gzipOS = new GZIPOutputStream(urlConn.getOutputStream());){
                    byte[] buffer = new byte[4096];
                    while (stream.available() > 0) {
                        gzipOS.write(buffer, 0, stream.read(buffer));
                    }
                    gzipOS.flush();
                }
                statusCode = urlConn.getResponseCode();
                this.readAndClose(urlConn.getInputStream());
            }
            catch (IOException ex) {
                if (urlConn == null) break block17;
                statusCode = urlConn.getResponseCode();
                this.readAndClose(urlConn.getErrorStream());
            }
        }
        return statusCode;
    }

    private void readAndClose(InputStream stream) throws IOException {
        if (stream != null) {
            try (InputStream is = stream;){
                byte[] buffer = new byte[4096];
                while (is.read(buffer) > 0) {
                }
            }
        }
    }

    @VisibleForTesting
    public static URL getReportingUrl(URI server, String format) throws MalformedURLException {
        String originalPath = server.getPath() != null ? server.getPath() : "";
        originalPath = originalPath.replaceAll("(\\/){2,}", "/");
        String string = originalPath = originalPath.equals("/") ? "" : originalPath;
        if (originalPath.endsWith("/report/")) {
            originalPath = originalPath.replaceAll("/report/$", "/report");
        } else if (!originalPath.endsWith("/report")) {
            originalPath = originalPath + "/report";
        }
        URL url = new URL(server.getScheme(), server.getHost(), server.getPort(), originalPath + "?f=" + format);
        return url;
    }
}

