/*
 * Decompiled with CFR 0.152.
 */
package com.wavefront.sdk.entities.histograms;

import com.wavefront.java_sdk.com.tdunning.math.stats.AVLTreeDigest;
import com.wavefront.java_sdk.com.tdunning.math.stats.Centroid;
import com.wavefront.java_sdk.com.tdunning.math.stats.TDigest;
import com.wavefront.sdk.common.Pair;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.ConcurrentLinkedDeque;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.StampedLock;
import java.util.function.Supplier;
import java.util.stream.Collectors;

public class WavefrontHistogramImpl {
    private static final int ACCURACY = 32;
    private static final double RECOMPRESSION_THRESHOLD_FACTOR = 2.0;
    private static final int MAX_BINS = 10;
    private final Supplier<Long> clockMillis;
    private final List<WeakReference<ConcurrentLinkedDeque<MinuteBin>>> globalHistogramBinsList = new ArrayList<WeakReference<ConcurrentLinkedDeque<MinuteBin>>>();
    private final StampedLock stampedLock = new StampedLock();
    private final Lock readLock = this.stampedLock.asReadLock();
    private final Lock writeLock = this.stampedLock.asWriteLock();
    private final ThreadLocal<ConcurrentLinkedDeque<MinuteBin>> histogramBinsList = ThreadLocal.withInitial(() -> {
        ConcurrentLinkedDeque sharedBinsInstance = new ConcurrentLinkedDeque();
        try {
            this.writeLock.lock();
            this.globalHistogramBinsList.add(new WeakReference(sharedBinsInstance));
        }
        finally {
            this.writeLock.unlock();
        }
        return sharedBinsInstance;
    });

    public WavefrontHistogramImpl() {
        this(System::currentTimeMillis);
    }

    public WavefrontHistogramImpl(Supplier<Long> clockMillis) {
        this.clockMillis = clockMillis;
    }

    public void update(int value) {
        this.update((double)value);
    }

    public void update(long value) {
        this.update((double)value);
    }

    public void update(double value) {
        this.getCurrentBin().distribution.add(value);
    }

    public void bulkUpdate(List<Double> means, List<Integer> counts) {
        if (means != null && counts != null) {
            int n = Math.min(means.size(), counts.size());
            MinuteBin currentBin = this.getCurrentBin();
            for (int i = 0; i < n; ++i) {
                currentBin.distribution.add(means.get(i), counts.get(i));
            }
        }
    }

    public long getCount() {
        try {
            this.readLock.lock();
            long l = this.globalHistogramBinsList.stream().map(Reference::get).filter(Objects::nonNull).flatMap(Collection::stream).mapToLong(bin -> bin.distribution.size()).sum();
            return l;
        }
        finally {
            this.readLock.unlock();
        }
    }

    public double getMax() {
        try {
            this.readLock.lock();
            double d = this.globalHistogramBinsList.stream().map(Reference::get).filter(Objects::nonNull).flatMap(Collection::stream).mapToDouble(bin -> bin.distribution.getMax()).max().orElse(Double.NaN);
            return d;
        }
        finally {
            this.readLock.unlock();
        }
    }

    public double getMin() {
        try {
            this.readLock.lock();
            double d = this.globalHistogramBinsList.stream().map(Reference::get).filter(Objects::nonNull).flatMap(Collection::stream).mapToDouble(bin -> bin.distribution.getMin()).min().orElse(Double.NaN);
            return d;
        }
        finally {
            this.readLock.unlock();
        }
    }

    public double getMean() {
        List<Centroid> centroids = this.getCentroids();
        Centroid mean = this.getMeanCentroid(centroids);
        return this.getMean(centroids, mean);
    }

    private Centroid getMeanCentroid(Collection<Centroid> centroids) {
        return centroids.stream().reduce((x, y) -> new Centroid(x.mean() + y.mean() * (double)y.count(), x.count() + y.count())).orElse(null);
    }

    private double getMean(Collection<Centroid> centroids, Centroid mean) {
        return mean == null || centroids.size() == 0 ? Double.NaN : mean.mean() / (double)mean.count();
    }

    public double getSum() {
        return this.getCentroids().stream().mapToDouble(c -> (double)c.count() * c.mean()).sum();
    }

    public double stdDev() {
        List<Centroid> centroids = this.getCentroids();
        double mean = this.getMean(centroids, this.getMeanCentroid(centroids));
        double varianceSum = centroids.stream().mapToDouble(c -> {
            double diff = c.mean() - mean;
            return diff * diff * (double)c.count();
        }).sum();
        double count = centroids.stream().mapToDouble(Centroid::count).sum();
        double variance = count == 0.0 ? 0.0 : varianceSum / count;
        return Math.sqrt(variance);
    }

    private List<Centroid> getCentroids() {
        ArrayList<Centroid> centroids = new ArrayList<Centroid>();
        try {
            this.readLock.lock();
            this.globalHistogramBinsList.stream().map(Reference::get).filter(Objects::nonNull).flatMap(Collection::stream).forEach(bin -> centroids.addAll(bin.distribution.centroids()));
        }
        finally {
            this.readLock.unlock();
        }
        return centroids;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Distribution> flushDistributions() {
        long cutoffMillis = this.currentMinuteMillis();
        try {
            this.writeLock.lock();
            List<Distribution> list = this.processGlobalHistogramBinsList(cutoffMillis);
            return list;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    private List<Distribution> processGlobalHistogramBinsList(long cutoffMillis) {
        ArrayList<Distribution> distributions = new ArrayList<Distribution>();
        Iterator<WeakReference<ConcurrentLinkedDeque<MinuteBin>>> globalBinsIter = this.globalHistogramBinsList.iterator();
        HashMap<Long, MinuteBin> mergedBins = new HashMap<Long, MinuteBin>();
        while (globalBinsIter.hasNext()) {
            WeakReference<ConcurrentLinkedDeque<MinuteBin>> weakRef = globalBinsIter.next();
            ConcurrentLinkedDeque sharedBinsInstance = (ConcurrentLinkedDeque)weakRef.get();
            if (sharedBinsInstance == null) {
                globalBinsIter.remove();
                continue;
            }
            Iterator binsIter = sharedBinsInstance.iterator();
            while (binsIter.hasNext()) {
                MinuteBin minuteBin = (MinuteBin)binsIter.next();
                if (minuteBin.minuteMillis >= cutoffMillis) continue;
                mergedBins.compute(minuteBin.minuteMillis, (k, v) -> {
                    if (v == null) {
                        return minuteBin;
                    }
                    v.distribution.add(minuteBin.distribution);
                    return v;
                });
                binsIter.remove();
            }
        }
        mergedBins.forEach((key, value) -> {
            if ((double)value.distribution.centroidCount() > 64.0) {
                value.distribution.compress();
            }
            List<Pair<Double, Integer>> centroids = value.distribution.centroids().stream().map(c -> new Pair<Double, Integer>(c.mean(), c.count())).collect(Collectors.toList());
            distributions.add(new Distribution((long)key, centroids));
        });
        return distributions;
    }

    public Snapshot getSnapshot() {
        AVLTreeDigest snapshot = new AVLTreeDigest(32.0);
        try {
            this.readLock.lock();
            this.globalHistogramBinsList.stream().map(Reference::get).filter(Objects::nonNull).flatMap(Collection::stream).forEach(bin -> snapshot.add(bin.distribution));
        }
        finally {
            this.readLock.unlock();
        }
        if ((double)((TDigest)snapshot).centroidCount() > 64.0) {
            ((TDigest)snapshot).compress();
        }
        return new Snapshot(snapshot);
    }

    private long currentMinuteMillis() {
        return this.clockMillis.get() / 60000L * 60000L;
    }

    private MinuteBin getCurrentBin() {
        ConcurrentLinkedDeque<MinuteBin> sharedBinsInstance = this.histogramBinsList.get();
        long currMinuteMillis = this.currentMinuteMillis();
        if (sharedBinsInstance.isEmpty() || sharedBinsInstance.getLast().minuteMillis != currMinuteMillis) {
            sharedBinsInstance.add(new MinuteBin(32, currMinuteMillis));
            if (sharedBinsInstance.size() > 10) {
                sharedBinsInstance.removeFirst();
            }
        }
        return sharedBinsInstance.getLast();
    }

    private static class MinuteBin {
        public final TDigest distribution;
        public final long minuteMillis;

        MinuteBin(int accuracy, long minuteMillis) {
            this.distribution = new AVLTreeDigest(accuracy);
            this.minuteMillis = minuteMillis;
        }
    }

    public static class Distribution {
        public final long timestamp;
        public final List<Pair<Double, Integer>> centroids;

        public Distribution(long timestamp, List<Pair<Double, Integer>> centroids) {
            this.timestamp = timestamp;
            this.centroids = centroids;
        }
    }

    public static class Snapshot {
        private final TDigest distribution;

        Snapshot(TDigest dist) {
            this.distribution = dist;
        }

        public long getCount() {
            return this.distribution.size();
        }

        public double getMax() {
            double max = this.distribution.getMax();
            return max == Double.NEGATIVE_INFINITY ? Double.NaN : max;
        }

        public double getMin() {
            double min = this.distribution.getMin();
            return min == Double.POSITIVE_INFINITY ? Double.NaN : min;
        }

        public double getMean() {
            Collection<Centroid> centroids = this.distribution.centroids();
            Centroid mean = centroids.stream().reduce((x, y) -> new Centroid(x.mean() + y.mean() * (double)y.count(), x.count() + y.count())).orElse(null);
            return mean == null || centroids.size() == 0 ? Double.NaN : mean.mean() / (double)mean.count();
        }

        public double getSum() {
            return this.distribution.centroids().stream().mapToDouble(c -> (double)c.count() * c.mean()).sum();
        }

        public double getValue(double quantile) {
            return this.distribution.quantile(quantile);
        }

        public int getSize() {
            return (int)this.distribution.size();
        }
    }
}

