/*
 * Decompiled with CFR 0.152.
 */
package com.wavefront.sdk.common.clients.service.token;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.wavefront.sdk.common.NamedThreadFactory;
import com.wavefront.sdk.common.Utils;
import com.wavefront.sdk.common.clients.service.token.CSPAuthorizeResponse;
import com.wavefront.sdk.common.clients.service.token.TokenService;
import java.io.DataOutputStream;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Base64;
import java.util.List;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Logger;
import java.util.stream.Collectors;

public class CSPServerToServerTokenService
implements TokenService,
Runnable {
    private static final Logger log = Logger.getLogger(CSPServerToServerTokenService.class.getCanonicalName());
    private static final String OAUTH_PATH = "/csp/gateway/am/api/auth/authorize";
    private static final int TEN_MINUTES = 600;
    private static final int THIRTY_SECONDS = 30;
    private static final int THREE_MINUTES = 180;
    private static int DEFAULT_THREAD_DELAY = 60;
    private final ScheduledExecutorService executor = Executors.newScheduledThreadPool(1, new NamedThreadFactory("csp-server-to-server-token-service"));
    private final ObjectMapper mapper = new ObjectMapper();
    private final AtomicBoolean tokenReady = new AtomicBoolean(false);
    private final String cspBaseURL;
    private final String cspClientId;
    private final String cspClientSecret;
    private final int connectTimeoutMillis;
    private final int readTimeoutMillis;
    private String cspAccessToken;

    public CSPServerToServerTokenService(String cspBaseURL, String cspClientId, String cspClientSecret) {
        this.cspBaseURL = cspBaseURL;
        this.cspClientId = cspClientId;
        this.cspClientSecret = cspClientSecret;
        this.connectTimeoutMillis = 30000;
        this.readTimeoutMillis = 10000;
    }

    public CSPServerToServerTokenService(String cspBaseURL, String cspClientId, String cspClientSecret, int connectTimeoutMillis, int readTimeoutMillis) {
        this.cspBaseURL = cspBaseURL;
        this.cspClientId = cspClientId;
        this.cspClientSecret = cspClientSecret;
        this.connectTimeoutMillis = connectTimeoutMillis;
        this.readTimeoutMillis = readTimeoutMillis;
    }

    @Override
    public synchronized String getToken() {
        if (!this.tokenReady.get()) {
            this.run();
            this.tokenReady.set(true);
        }
        return this.cspAccessToken;
    }

    private String getCSPToken() {
        HttpURLConnection urlConn = null;
        String urlParameters = "grant_type=client_credentials";
        byte[] postData = "grant_type=client_credentials".getBytes(StandardCharsets.UTF_8);
        try {
            URL url = new URL(this.cspBaseURL + OAUTH_PATH);
            urlConn = (HttpURLConnection)url.openConnection();
            urlConn.setDoOutput(true);
            urlConn.setRequestMethod("POST");
            urlConn.addRequestProperty("Content-Type", "application/x-www-form-urlencoded");
            urlConn.addRequestProperty("Authorization", "Basic " + this.buildHttpBasicToken(this.cspClientId, this.cspClientSecret));
            urlConn.setRequestProperty("Content-Length", Integer.toString(postData.length));
            urlConn.setConnectTimeout(this.connectTimeoutMillis);
            urlConn.setReadTimeout(this.readTimeoutMillis);
            DataOutputStream wr = new DataOutputStream(urlConn.getOutputStream());
            wr.write(postData);
            wr.flush();
            wr.close();
            int statusCode = urlConn.getResponseCode();
            if (statusCode == 200) {
                try {
                    CSPAuthorizeResponse parsedResponse = (CSPAuthorizeResponse)this.mapper.readValue(urlConn.getInputStream(), CSPAuthorizeResponse.class);
                    if (!CSPServerToServerTokenService.hasDirectIngestScope(parsedResponse.scope)) {
                        log.warning("The CSP response did not find any scope matching 'aoa:directDataIngestion' which is required for Wavefront direct ingestion.");
                    }
                    int threadDelay = this.getThreadDelay(parsedResponse.expiresIn);
                    log.info("A CSP token has been received. Will schedule the CSP token to be refreshed in: " + threadDelay + " seconds");
                    this.executor.schedule(this, (long)threadDelay, TimeUnit.SECONDS);
                    return parsedResponse.accessToken;
                }
                catch (JsonProcessingException e) {
                    log.severe("The request to CSP returned invalid json. Please restart your app.");
                    return "INVALID_TOKEN";
                }
            }
            log.warning("The request to CSP returned: " + statusCode);
            if (statusCode >= 500 && statusCode < 600) {
                log.info("The Wavefront SDK will try to reauthenticate with CSP on the next request.");
                this.tokenReady.set(false);
                return null;
            }
            return "INVALID_TOKEN";
        }
        catch (IOException ex) {
            log.warning("Error connecting to CSP: " + ex.getLocalizedMessage());
            log.info("The Wavefront SDK will try to reauthenticate with CSP on the next request.");
            this.tokenReady.set(false);
            return null;
        }
    }

    private int getThreadDelay(int expiresIn) {
        int retVal = expiresIn < 600 ? expiresIn - 30 : expiresIn - 180;
        if (retVal <= 0) {
            retVal = DEFAULT_THREAD_DELAY;
        }
        return retVal;
    }

    @Override
    public synchronized void run() {
        this.cspAccessToken = this.getCSPToken();
    }

    private static List<String> parseScopes(String scope) {
        return Arrays.stream(scope.split("\\s")).collect(Collectors.toList());
    }

    public static boolean hasDirectIngestScope(String scopeList) {
        if (!Utils.isNullOrEmpty(scopeList)) {
            return CSPServerToServerTokenService.parseScopes(scopeList).stream().anyMatch(s -> s.contains("aoa:directDataIngestion") || s.contains("aoa/*") || s.contains("aoa:*"));
        }
        return false;
    }

    private String buildHttpBasicToken(String cspClientId, String cspClientSecret) {
        String encodeMe = cspClientId + ":" + cspClientSecret;
        return Base64.getEncoder().encodeToString(encodeMe.getBytes());
    }
}

