/*
 * Decompiled with CFR 0.152.
 */
package com.wavesenterprise.protobuf.service.contract;

import com.google.protobuf.AbstractMessage;
import com.google.protobuf.AbstractMessageLite;
import com.google.protobuf.AbstractParser;
import com.google.protobuf.ByteString;
import com.google.protobuf.CodedInputStream;
import com.google.protobuf.CodedOutputStream;
import com.google.protobuf.Descriptors;
import com.google.protobuf.ExtensionRegistryLite;
import com.google.protobuf.GeneratedMessageV3;
import com.google.protobuf.InvalidProtocolBufferException;
import com.google.protobuf.LazyStringArrayList;
import com.google.protobuf.LazyStringList;
import com.google.protobuf.Message;
import com.google.protobuf.MessageLite;
import com.google.protobuf.Parser;
import com.google.protobuf.ProtocolStringList;
import com.google.protobuf.SingleFieldBuilderV3;
import com.google.protobuf.StringValue;
import com.google.protobuf.StringValueOrBuilder;
import com.google.protobuf.UninitializedMessageException;
import com.google.protobuf.UnknownFieldSet;
import com.wavesenterprise.protobuf.constants.Constants;
import com.wavesenterprise.protobuf.service.contract.ContractCryptoService;
import com.wavesenterprise.protobuf.service.contract.EncryptDataRequestOrBuilder;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.util.Collection;
import java.util.List;

public final class EncryptDataRequest
extends GeneratedMessageV3
implements EncryptDataRequestOrBuilder {
    private static final long serialVersionUID = 0L;
    public static final int SENDER_FIELD_NUMBER = 1;
    private volatile Object sender_;
    public static final int PASSWORD_FIELD_NUMBER = 2;
    private StringValue password_;
    public static final int ENCRYPTION_DATA_FIELD_NUMBER = 3;
    private ByteString encryptionData_;
    public static final int RECIPIENTS_PUBLIC_KEYS_FIELD_NUMBER = 4;
    private LazyStringList recipientsPublicKeys_;
    public static final int CRYPTO_ALGO_FIELD_NUMBER = 5;
    private int cryptoAlgo_;
    private byte memoizedIsInitialized = (byte)-1;
    private static final EncryptDataRequest DEFAULT_INSTANCE = new EncryptDataRequest();
    private static final Parser<EncryptDataRequest> PARSER = new AbstractParser<EncryptDataRequest>(){

        public EncryptDataRequest parsePartialFrom(CodedInputStream input, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
            return new EncryptDataRequest(input, extensionRegistry);
        }
    };

    private EncryptDataRequest(GeneratedMessageV3.Builder<?> builder) {
        super(builder);
    }

    private EncryptDataRequest() {
        this.sender_ = "";
        this.encryptionData_ = ByteString.EMPTY;
        this.recipientsPublicKeys_ = LazyStringArrayList.EMPTY;
        this.cryptoAlgo_ = 0;
    }

    protected Object newInstance(GeneratedMessageV3.UnusedPrivateParameter unused) {
        return new EncryptDataRequest();
    }

    public final UnknownFieldSet getUnknownFields() {
        return this.unknownFields;
    }

    private EncryptDataRequest(CodedInputStream input, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
        this();
        if (extensionRegistry == null) {
            throw new NullPointerException();
        }
        boolean mutable_bitField0_ = false;
        UnknownFieldSet.Builder unknownFields = UnknownFieldSet.newBuilder();
        try {
            boolean done = false;
            block15: while (!done) {
                int tag = input.readTag();
                switch (tag) {
                    case 0: {
                        done = true;
                        continue block15;
                    }
                    case 10: {
                        String s = input.readStringRequireUtf8();
                        this.sender_ = s;
                        continue block15;
                    }
                    case 18: {
                        StringValue.Builder subBuilder = null;
                        if (this.password_ != null) {
                            subBuilder = this.password_.toBuilder();
                        }
                        this.password_ = (StringValue)input.readMessage(StringValue.parser(), extensionRegistry);
                        if (subBuilder == null) continue block15;
                        subBuilder.mergeFrom(this.password_);
                        this.password_ = subBuilder.buildPartial();
                        continue block15;
                    }
                    case 26: {
                        this.encryptionData_ = input.readBytes();
                        continue block15;
                    }
                    case 34: {
                        String s = input.readStringRequireUtf8();
                        if (!(mutable_bitField0_ & true)) {
                            this.recipientsPublicKeys_ = new LazyStringArrayList();
                            mutable_bitField0_ |= true;
                        }
                        this.recipientsPublicKeys_.add((Object)s);
                        continue block15;
                    }
                    case 40: {
                        int rawValue;
                        this.cryptoAlgo_ = rawValue = input.readEnum();
                        continue block15;
                    }
                }
                if (this.parseUnknownField(input, unknownFields, extensionRegistry, tag)) continue;
                done = true;
            }
        }
        catch (InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage((MessageLite)this);
        }
        catch (UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage((MessageLite)this);
        }
        catch (IOException e) {
            throw new InvalidProtocolBufferException(e).setUnfinishedMessage((MessageLite)this);
        }
        finally {
            if (mutable_bitField0_ & true) {
                this.recipientsPublicKeys_ = this.recipientsPublicKeys_.getUnmodifiableView();
            }
            this.unknownFields = unknownFields.build();
            this.makeExtensionsImmutable();
        }
    }

    public static final Descriptors.Descriptor getDescriptor() {
        return ContractCryptoService.internal_static_wavesenterprise_EncryptDataRequest_descriptor;
    }

    protected GeneratedMessageV3.FieldAccessorTable internalGetFieldAccessorTable() {
        return ContractCryptoService.internal_static_wavesenterprise_EncryptDataRequest_fieldAccessorTable.ensureFieldAccessorsInitialized(EncryptDataRequest.class, Builder.class);
    }

    @Override
    public String getSender() {
        Object ref = this.sender_;
        if (ref instanceof String) {
            return (String)ref;
        }
        ByteString bs = (ByteString)ref;
        String s = bs.toStringUtf8();
        this.sender_ = s;
        return s;
    }

    @Override
    public ByteString getSenderBytes() {
        Object ref = this.sender_;
        if (ref instanceof String) {
            ByteString b = ByteString.copyFromUtf8((String)((String)ref));
            this.sender_ = b;
            return b;
        }
        return (ByteString)ref;
    }

    @Override
    public boolean hasPassword() {
        return this.password_ != null;
    }

    @Override
    public StringValue getPassword() {
        return this.password_ == null ? StringValue.getDefaultInstance() : this.password_;
    }

    @Override
    public StringValueOrBuilder getPasswordOrBuilder() {
        return this.getPassword();
    }

    @Override
    public ByteString getEncryptionData() {
        return this.encryptionData_;
    }

    public ProtocolStringList getRecipientsPublicKeysList() {
        return this.recipientsPublicKeys_;
    }

    @Override
    public int getRecipientsPublicKeysCount() {
        return this.recipientsPublicKeys_.size();
    }

    @Override
    public String getRecipientsPublicKeys(int index) {
        return (String)this.recipientsPublicKeys_.get(index);
    }

    @Override
    public ByteString getRecipientsPublicKeysBytes(int index) {
        return this.recipientsPublicKeys_.getByteString(index);
    }

    @Override
    public int getCryptoAlgoValue() {
        return this.cryptoAlgo_;
    }

    @Override
    public Constants.CryptoAlgo getCryptoAlgo() {
        Constants.CryptoAlgo result = Constants.CryptoAlgo.valueOf(this.cryptoAlgo_);
        return result == null ? Constants.CryptoAlgo.UNRECOGNIZED : result;
    }

    public final boolean isInitialized() {
        byte isInitialized = this.memoizedIsInitialized;
        if (isInitialized == 1) {
            return true;
        }
        if (isInitialized == 0) {
            return false;
        }
        this.memoizedIsInitialized = 1;
        return true;
    }

    public void writeTo(CodedOutputStream output) throws IOException {
        if (!GeneratedMessageV3.isStringEmpty((Object)this.sender_)) {
            GeneratedMessageV3.writeString((CodedOutputStream)output, (int)1, (Object)this.sender_);
        }
        if (this.password_ != null) {
            output.writeMessage(2, (MessageLite)this.getPassword());
        }
        if (!this.encryptionData_.isEmpty()) {
            output.writeBytes(3, this.encryptionData_);
        }
        for (int i = 0; i < this.recipientsPublicKeys_.size(); ++i) {
            GeneratedMessageV3.writeString((CodedOutputStream)output, (int)4, (Object)this.recipientsPublicKeys_.getRaw(i));
        }
        if (this.cryptoAlgo_ != Constants.CryptoAlgo.UNKNOWN_CRYPTO_ALGO.getNumber()) {
            output.writeEnum(5, this.cryptoAlgo_);
        }
        this.unknownFields.writeTo(output);
    }

    public int getSerializedSize() {
        int size = this.memoizedSize;
        if (size != -1) {
            return size;
        }
        size = 0;
        if (!GeneratedMessageV3.isStringEmpty((Object)this.sender_)) {
            size += GeneratedMessageV3.computeStringSize((int)1, (Object)this.sender_);
        }
        if (this.password_ != null) {
            size += CodedOutputStream.computeMessageSize((int)2, (MessageLite)this.getPassword());
        }
        if (!this.encryptionData_.isEmpty()) {
            size += CodedOutputStream.computeBytesSize((int)3, (ByteString)this.encryptionData_);
        }
        int dataSize = 0;
        for (int i = 0; i < this.recipientsPublicKeys_.size(); ++i) {
            dataSize += EncryptDataRequest.computeStringSizeNoTag((Object)this.recipientsPublicKeys_.getRaw(i));
        }
        size += dataSize;
        size += 1 * this.getRecipientsPublicKeysList().size();
        if (this.cryptoAlgo_ != Constants.CryptoAlgo.UNKNOWN_CRYPTO_ALGO.getNumber()) {
            size += CodedOutputStream.computeEnumSize((int)5, (int)this.cryptoAlgo_);
        }
        this.memoizedSize = size += this.unknownFields.getSerializedSize();
        return size;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof EncryptDataRequest)) {
            return super.equals(obj);
        }
        EncryptDataRequest other = (EncryptDataRequest)obj;
        if (!this.getSender().equals(other.getSender())) {
            return false;
        }
        if (this.hasPassword() != other.hasPassword()) {
            return false;
        }
        if (this.hasPassword() && !this.getPassword().equals((Object)other.getPassword())) {
            return false;
        }
        if (!this.getEncryptionData().equals((Object)other.getEncryptionData())) {
            return false;
        }
        if (!this.getRecipientsPublicKeysList().equals(other.getRecipientsPublicKeysList())) {
            return false;
        }
        if (this.cryptoAlgo_ != other.cryptoAlgo_) {
            return false;
        }
        return this.unknownFields.equals((Object)other.unknownFields);
    }

    public int hashCode() {
        if (this.memoizedHashCode != 0) {
            return this.memoizedHashCode;
        }
        int hash = 41;
        hash = 19 * hash + EncryptDataRequest.getDescriptor().hashCode();
        hash = 37 * hash + 1;
        hash = 53 * hash + this.getSender().hashCode();
        if (this.hasPassword()) {
            hash = 37 * hash + 2;
            hash = 53 * hash + this.getPassword().hashCode();
        }
        hash = 37 * hash + 3;
        hash = 53 * hash + this.getEncryptionData().hashCode();
        if (this.getRecipientsPublicKeysCount() > 0) {
            hash = 37 * hash + 4;
            hash = 53 * hash + this.getRecipientsPublicKeysList().hashCode();
        }
        hash = 37 * hash + 5;
        hash = 53 * hash + this.cryptoAlgo_;
        this.memoizedHashCode = hash = 29 * hash + this.unknownFields.hashCode();
        return hash;
    }

    public static EncryptDataRequest parseFrom(ByteBuffer data) throws InvalidProtocolBufferException {
        return (EncryptDataRequest)PARSER.parseFrom(data);
    }

    public static EncryptDataRequest parseFrom(ByteBuffer data, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
        return (EncryptDataRequest)PARSER.parseFrom(data, extensionRegistry);
    }

    public static EncryptDataRequest parseFrom(ByteString data) throws InvalidProtocolBufferException {
        return (EncryptDataRequest)PARSER.parseFrom(data);
    }

    public static EncryptDataRequest parseFrom(ByteString data, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
        return (EncryptDataRequest)PARSER.parseFrom(data, extensionRegistry);
    }

    public static EncryptDataRequest parseFrom(byte[] data) throws InvalidProtocolBufferException {
        return (EncryptDataRequest)PARSER.parseFrom(data);
    }

    public static EncryptDataRequest parseFrom(byte[] data, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
        return (EncryptDataRequest)PARSER.parseFrom(data, extensionRegistry);
    }

    public static EncryptDataRequest parseFrom(InputStream input) throws IOException {
        return (EncryptDataRequest)GeneratedMessageV3.parseWithIOException(PARSER, (InputStream)input);
    }

    public static EncryptDataRequest parseFrom(InputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
        return (EncryptDataRequest)GeneratedMessageV3.parseWithIOException(PARSER, (InputStream)input, (ExtensionRegistryLite)extensionRegistry);
    }

    public static EncryptDataRequest parseDelimitedFrom(InputStream input) throws IOException {
        return (EncryptDataRequest)GeneratedMessageV3.parseDelimitedWithIOException(PARSER, (InputStream)input);
    }

    public static EncryptDataRequest parseDelimitedFrom(InputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
        return (EncryptDataRequest)GeneratedMessageV3.parseDelimitedWithIOException(PARSER, (InputStream)input, (ExtensionRegistryLite)extensionRegistry);
    }

    public static EncryptDataRequest parseFrom(CodedInputStream input) throws IOException {
        return (EncryptDataRequest)GeneratedMessageV3.parseWithIOException(PARSER, (CodedInputStream)input);
    }

    public static EncryptDataRequest parseFrom(CodedInputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
        return (EncryptDataRequest)GeneratedMessageV3.parseWithIOException(PARSER, (CodedInputStream)input, (ExtensionRegistryLite)extensionRegistry);
    }

    public Builder newBuilderForType() {
        return EncryptDataRequest.newBuilder();
    }

    public static Builder newBuilder() {
        return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(EncryptDataRequest prototype) {
        return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    public Builder toBuilder() {
        return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    protected Builder newBuilderForType(GeneratedMessageV3.BuilderParent parent) {
        Builder builder = new Builder(parent);
        return builder;
    }

    public static EncryptDataRequest getDefaultInstance() {
        return DEFAULT_INSTANCE;
    }

    public static Parser<EncryptDataRequest> parser() {
        return PARSER;
    }

    public Parser<EncryptDataRequest> getParserForType() {
        return PARSER;
    }

    public EncryptDataRequest getDefaultInstanceForType() {
        return DEFAULT_INSTANCE;
    }

    public static final class Builder
    extends GeneratedMessageV3.Builder<Builder>
    implements EncryptDataRequestOrBuilder {
        private int bitField0_;
        private Object sender_ = "";
        private StringValue password_;
        private SingleFieldBuilderV3<StringValue, StringValue.Builder, StringValueOrBuilder> passwordBuilder_;
        private ByteString encryptionData_ = ByteString.EMPTY;
        private LazyStringList recipientsPublicKeys_ = LazyStringArrayList.EMPTY;
        private int cryptoAlgo_ = 0;

        public static final Descriptors.Descriptor getDescriptor() {
            return ContractCryptoService.internal_static_wavesenterprise_EncryptDataRequest_descriptor;
        }

        protected GeneratedMessageV3.FieldAccessorTable internalGetFieldAccessorTable() {
            return ContractCryptoService.internal_static_wavesenterprise_EncryptDataRequest_fieldAccessorTable.ensureFieldAccessorsInitialized(EncryptDataRequest.class, Builder.class);
        }

        private Builder() {
            this.maybeForceBuilderInitialization();
        }

        private Builder(GeneratedMessageV3.BuilderParent parent) {
            super(parent);
            this.maybeForceBuilderInitialization();
        }

        private void maybeForceBuilderInitialization() {
            if (alwaysUseFieldBuilders) {
                // empty if block
            }
        }

        public Builder clear() {
            super.clear();
            this.sender_ = "";
            if (this.passwordBuilder_ == null) {
                this.password_ = null;
            } else {
                this.password_ = null;
                this.passwordBuilder_ = null;
            }
            this.encryptionData_ = ByteString.EMPTY;
            this.recipientsPublicKeys_ = LazyStringArrayList.EMPTY;
            this.bitField0_ &= 0xFFFFFFFE;
            this.cryptoAlgo_ = 0;
            return this;
        }

        public Descriptors.Descriptor getDescriptorForType() {
            return ContractCryptoService.internal_static_wavesenterprise_EncryptDataRequest_descriptor;
        }

        public EncryptDataRequest getDefaultInstanceForType() {
            return EncryptDataRequest.getDefaultInstance();
        }

        public EncryptDataRequest build() {
            EncryptDataRequest result = this.buildPartial();
            if (!result.isInitialized()) {
                throw Builder.newUninitializedMessageException((Message)result);
            }
            return result;
        }

        public EncryptDataRequest buildPartial() {
            EncryptDataRequest result = new EncryptDataRequest(this);
            int from_bitField0_ = this.bitField0_;
            result.sender_ = this.sender_;
            if (this.passwordBuilder_ == null) {
                result.password_ = this.password_;
            } else {
                result.password_ = (StringValue)this.passwordBuilder_.build();
            }
            result.encryptionData_ = this.encryptionData_;
            if ((this.bitField0_ & 1) != 0) {
                this.recipientsPublicKeys_ = this.recipientsPublicKeys_.getUnmodifiableView();
                this.bitField0_ &= 0xFFFFFFFE;
            }
            result.recipientsPublicKeys_ = this.recipientsPublicKeys_;
            result.cryptoAlgo_ = this.cryptoAlgo_;
            this.onBuilt();
            return result;
        }

        public Builder clone() {
            return (Builder)super.clone();
        }

        public Builder setField(Descriptors.FieldDescriptor field, Object value) {
            return (Builder)super.setField(field, value);
        }

        public Builder clearField(Descriptors.FieldDescriptor field) {
            return (Builder)super.clearField(field);
        }

        public Builder clearOneof(Descriptors.OneofDescriptor oneof) {
            return (Builder)super.clearOneof(oneof);
        }

        public Builder setRepeatedField(Descriptors.FieldDescriptor field, int index, Object value) {
            return (Builder)super.setRepeatedField(field, index, value);
        }

        public Builder addRepeatedField(Descriptors.FieldDescriptor field, Object value) {
            return (Builder)super.addRepeatedField(field, value);
        }

        public Builder mergeFrom(Message other) {
            if (other instanceof EncryptDataRequest) {
                return this.mergeFrom((EncryptDataRequest)other);
            }
            super.mergeFrom(other);
            return this;
        }

        public Builder mergeFrom(EncryptDataRequest other) {
            if (other == EncryptDataRequest.getDefaultInstance()) {
                return this;
            }
            if (!other.getSender().isEmpty()) {
                this.sender_ = other.sender_;
                this.onChanged();
            }
            if (other.hasPassword()) {
                this.mergePassword(other.getPassword());
            }
            if (other.getEncryptionData() != ByteString.EMPTY) {
                this.setEncryptionData(other.getEncryptionData());
            }
            if (!other.recipientsPublicKeys_.isEmpty()) {
                if (this.recipientsPublicKeys_.isEmpty()) {
                    this.recipientsPublicKeys_ = other.recipientsPublicKeys_;
                    this.bitField0_ &= 0xFFFFFFFE;
                } else {
                    this.ensureRecipientsPublicKeysIsMutable();
                    this.recipientsPublicKeys_.addAll((Collection)other.recipientsPublicKeys_);
                }
                this.onChanged();
            }
            if (other.cryptoAlgo_ != 0) {
                this.setCryptoAlgoValue(other.getCryptoAlgoValue());
            }
            this.mergeUnknownFields(other.unknownFields);
            this.onChanged();
            return this;
        }

        public final boolean isInitialized() {
            return true;
        }

        public Builder mergeFrom(CodedInputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
            EncryptDataRequest parsedMessage = null;
            try {
                parsedMessage = (EncryptDataRequest)PARSER.parsePartialFrom(input, extensionRegistry);
            }
            catch (InvalidProtocolBufferException e) {
                parsedMessage = (EncryptDataRequest)e.getUnfinishedMessage();
                throw e.unwrapIOException();
            }
            finally {
                if (parsedMessage != null) {
                    this.mergeFrom(parsedMessage);
                }
            }
            return this;
        }

        @Override
        public String getSender() {
            Object ref = this.sender_;
            if (!(ref instanceof String)) {
                ByteString bs = (ByteString)ref;
                String s = bs.toStringUtf8();
                this.sender_ = s;
                return s;
            }
            return (String)ref;
        }

        @Override
        public ByteString getSenderBytes() {
            Object ref = this.sender_;
            if (ref instanceof String) {
                ByteString b = ByteString.copyFromUtf8((String)((String)ref));
                this.sender_ = b;
                return b;
            }
            return (ByteString)ref;
        }

        public Builder setSender(String value) {
            if (value == null) {
                throw new NullPointerException();
            }
            this.sender_ = value;
            this.onChanged();
            return this;
        }

        public Builder clearSender() {
            this.sender_ = EncryptDataRequest.getDefaultInstance().getSender();
            this.onChanged();
            return this;
        }

        public Builder setSenderBytes(ByteString value) {
            if (value == null) {
                throw new NullPointerException();
            }
            EncryptDataRequest.checkByteStringIsUtf8((ByteString)value);
            this.sender_ = value;
            this.onChanged();
            return this;
        }

        @Override
        public boolean hasPassword() {
            return this.passwordBuilder_ != null || this.password_ != null;
        }

        @Override
        public StringValue getPassword() {
            if (this.passwordBuilder_ == null) {
                return this.password_ == null ? StringValue.getDefaultInstance() : this.password_;
            }
            return (StringValue)this.passwordBuilder_.getMessage();
        }

        public Builder setPassword(StringValue value) {
            if (this.passwordBuilder_ == null) {
                if (value == null) {
                    throw new NullPointerException();
                }
                this.password_ = value;
                this.onChanged();
            } else {
                this.passwordBuilder_.setMessage((AbstractMessage)value);
            }
            return this;
        }

        public Builder setPassword(StringValue.Builder builderForValue) {
            if (this.passwordBuilder_ == null) {
                this.password_ = builderForValue.build();
                this.onChanged();
            } else {
                this.passwordBuilder_.setMessage((AbstractMessage)builderForValue.build());
            }
            return this;
        }

        public Builder mergePassword(StringValue value) {
            if (this.passwordBuilder_ == null) {
                this.password_ = this.password_ != null ? StringValue.newBuilder((StringValue)this.password_).mergeFrom(value).buildPartial() : value;
                this.onChanged();
            } else {
                this.passwordBuilder_.mergeFrom((AbstractMessage)value);
            }
            return this;
        }

        public Builder clearPassword() {
            if (this.passwordBuilder_ == null) {
                this.password_ = null;
                this.onChanged();
            } else {
                this.password_ = null;
                this.passwordBuilder_ = null;
            }
            return this;
        }

        public StringValue.Builder getPasswordBuilder() {
            this.onChanged();
            return (StringValue.Builder)this.getPasswordFieldBuilder().getBuilder();
        }

        @Override
        public StringValueOrBuilder getPasswordOrBuilder() {
            if (this.passwordBuilder_ != null) {
                return (StringValueOrBuilder)this.passwordBuilder_.getMessageOrBuilder();
            }
            return this.password_ == null ? StringValue.getDefaultInstance() : this.password_;
        }

        private SingleFieldBuilderV3<StringValue, StringValue.Builder, StringValueOrBuilder> getPasswordFieldBuilder() {
            if (this.passwordBuilder_ == null) {
                this.passwordBuilder_ = new SingleFieldBuilderV3((AbstractMessage)this.getPassword(), (AbstractMessage.BuilderParent)this.getParentForChildren(), this.isClean());
                this.password_ = null;
            }
            return this.passwordBuilder_;
        }

        @Override
        public ByteString getEncryptionData() {
            return this.encryptionData_;
        }

        public Builder setEncryptionData(ByteString value) {
            if (value == null) {
                throw new NullPointerException();
            }
            this.encryptionData_ = value;
            this.onChanged();
            return this;
        }

        public Builder clearEncryptionData() {
            this.encryptionData_ = EncryptDataRequest.getDefaultInstance().getEncryptionData();
            this.onChanged();
            return this;
        }

        private void ensureRecipientsPublicKeysIsMutable() {
            if ((this.bitField0_ & 1) == 0) {
                this.recipientsPublicKeys_ = new LazyStringArrayList(this.recipientsPublicKeys_);
                this.bitField0_ |= 1;
            }
        }

        public ProtocolStringList getRecipientsPublicKeysList() {
            return this.recipientsPublicKeys_.getUnmodifiableView();
        }

        @Override
        public int getRecipientsPublicKeysCount() {
            return this.recipientsPublicKeys_.size();
        }

        @Override
        public String getRecipientsPublicKeys(int index) {
            return (String)this.recipientsPublicKeys_.get(index);
        }

        @Override
        public ByteString getRecipientsPublicKeysBytes(int index) {
            return this.recipientsPublicKeys_.getByteString(index);
        }

        public Builder setRecipientsPublicKeys(int index, String value) {
            if (value == null) {
                throw new NullPointerException();
            }
            this.ensureRecipientsPublicKeysIsMutable();
            this.recipientsPublicKeys_.set(index, (Object)value);
            this.onChanged();
            return this;
        }

        public Builder addRecipientsPublicKeys(String value) {
            if (value == null) {
                throw new NullPointerException();
            }
            this.ensureRecipientsPublicKeysIsMutable();
            this.recipientsPublicKeys_.add((Object)value);
            this.onChanged();
            return this;
        }

        public Builder addAllRecipientsPublicKeys(Iterable<String> values) {
            this.ensureRecipientsPublicKeysIsMutable();
            AbstractMessageLite.Builder.addAll(values, (List)this.recipientsPublicKeys_);
            this.onChanged();
            return this;
        }

        public Builder clearRecipientsPublicKeys() {
            this.recipientsPublicKeys_ = LazyStringArrayList.EMPTY;
            this.bitField0_ &= 0xFFFFFFFE;
            this.onChanged();
            return this;
        }

        public Builder addRecipientsPublicKeysBytes(ByteString value) {
            if (value == null) {
                throw new NullPointerException();
            }
            EncryptDataRequest.checkByteStringIsUtf8((ByteString)value);
            this.ensureRecipientsPublicKeysIsMutable();
            this.recipientsPublicKeys_.add(value);
            this.onChanged();
            return this;
        }

        @Override
        public int getCryptoAlgoValue() {
            return this.cryptoAlgo_;
        }

        public Builder setCryptoAlgoValue(int value) {
            this.cryptoAlgo_ = value;
            this.onChanged();
            return this;
        }

        @Override
        public Constants.CryptoAlgo getCryptoAlgo() {
            Constants.CryptoAlgo result = Constants.CryptoAlgo.valueOf(this.cryptoAlgo_);
            return result == null ? Constants.CryptoAlgo.UNRECOGNIZED : result;
        }

        public Builder setCryptoAlgo(Constants.CryptoAlgo value) {
            if (value == null) {
                throw new NullPointerException();
            }
            this.cryptoAlgo_ = value.getNumber();
            this.onChanged();
            return this;
        }

        public Builder clearCryptoAlgo() {
            this.cryptoAlgo_ = 0;
            this.onChanged();
            return this;
        }

        public final Builder setUnknownFields(UnknownFieldSet unknownFields) {
            return (Builder)super.setUnknownFields(unknownFields);
        }

        public final Builder mergeUnknownFields(UnknownFieldSet unknownFields) {
            return (Builder)super.mergeUnknownFields(unknownFields);
        }
    }
}

